/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.filter;

import io.netty.handler.ipfilter.IpFilterRule;
import io.netty.handler.ipfilter.IpFilterRuleType;
import io.netty.handler.ipfilter.IpSubnetFilterRule;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.security.transport.filter.PatternRule;

public class SecurityIpFilterRule
implements IpFilterRule,
ToXContentFragment {
    public static final SecurityIpFilterRule ACCEPT_ALL = new SecurityIpFilterRule(true, "accept_all"){

        @Override
        public boolean matches(InetSocketAddress remoteAddress) {
            return true;
        }

        @Override
        public IpFilterRuleType ruleType() {
            return IpFilterRuleType.ACCEPT;
        }
    };
    public static final SecurityIpFilterRule DENY_ALL = new SecurityIpFilterRule(true, "deny_all"){

        @Override
        public boolean matches(InetSocketAddress remoteAddress) {
            return true;
        }

        @Override
        public IpFilterRuleType ruleType() {
            return IpFilterRuleType.REJECT;
        }
    };
    private final IpFilterRule ipFilterRule;
    private final String ruleSpec;

    public SecurityIpFilterRule(boolean isAllowRule, String ruleSpec) {
        this.ipFilterRule = SecurityIpFilterRule.getRule(isAllowRule, ruleSpec);
        this.ruleSpec = ruleSpec;
    }

    SecurityIpFilterRule(boolean isAllowRule, TransportAddress ... addresses) {
        this.ruleSpec = SecurityIpFilterRule.getRuleSpec(addresses);
        this.ipFilterRule = SecurityIpFilterRule.getRule(isAllowRule, this.ruleSpec);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.ruleType() == IpFilterRuleType.ACCEPT) {
            builder.append("allow ");
        } else {
            builder.append("deny ");
        }
        builder.append(this.ruleSpec);
        return builder.toString();
    }

    static Tuple<InetAddress, Integer> parseSubnetMask(String address) throws UnknownHostException {
        int mask;
        int p = address.indexOf(47);
        if (p < 0) {
            throw new UnknownHostException("Invalid CIDR notation used: " + address);
        }
        if (p == address.length() - 1) {
            throw new IllegalArgumentException("address must not end with a '/");
        }
        String addrString = address.substring(0, p);
        String maskString = address.substring(p + 1);
        InetAddress addr = InetAddress.getByName(addrString);
        if (maskString.indexOf(46) < 0) {
            mask = SecurityIpFilterRule.parseInt(maskString, -1);
        } else {
            mask = SecurityIpFilterRule.getNetMask(maskString);
            if (addr instanceof Inet6Address) {
                mask += 96;
            }
        }
        if (mask < 0) {
            throw new UnknownHostException("Invalid mask length used: " + maskString);
        }
        return new Tuple((Object)addr, (Object)mask);
    }

    private static int getNetMask(String netMask) {
        StringTokenizer nm = new StringTokenizer(netMask, ".");
        int i = 0;
        int[] netmask = new int[4];
        while (nm.hasMoreTokens()) {
            netmask[i] = Integer.parseInt(nm.nextToken());
            ++i;
        }
        int mask1 = 0;
        for (i = 0; i < 4; ++i) {
            mask1 += Integer.bitCount(netmask[i]);
        }
        return mask1;
    }

    private static int parseInt(String intstr, int def) {
        Integer res;
        if (intstr == null) {
            return def;
        }
        try {
            res = Integer.decode(intstr);
        }
        catch (Exception e) {
            res = def;
        }
        return res;
    }

    static IpFilterRule getRule(boolean isAllowRule, String value) {
        IpFilterRuleType filterRuleType = isAllowRule ? IpFilterRuleType.ACCEPT : IpFilterRuleType.REJECT;
        String[] values = value.split(",");
        if (Arrays.stream(values).anyMatch("_all"::equals)) {
            if (values.length != 1) {
                throw new IllegalArgumentException("rules that specify _all may not have other values!");
            }
            return isAllowRule ? ACCEPT_ALL : DENY_ALL;
        }
        if (value.contains("/")) {
            if (values.length != 1) {
                throw new IllegalArgumentException("multiple subnet filters cannot be specified in a single rule!");
            }
            try {
                Tuple<InetAddress, Integer> inetAddressIntegerTuple = SecurityIpFilterRule.parseSubnetMask(value);
                return new IpSubnetFilterRule((InetAddress)inetAddressIntegerTuple.v1(), ((Integer)inetAddressIntegerTuple.v2()).intValue(), filterRuleType);
            }
            catch (UnknownHostException e) {
                String ruleType = isAllowRule ? "allow " : "deny ";
                throw new ElasticsearchException("unable to create ip filter for rule [" + ruleType + " " + value + "]", (Throwable)e, new Object[0]);
            }
        }
        StringJoiner rules = new StringJoiner(",");
        for (String pattern : values) {
            if (InetAddresses.isInetAddress((String)pattern)) {
                InetAddress inetAddress = InetAddresses.forString((String)pattern);
                pattern = "i:" + NetworkAddress.format((InetAddress)inetAddress);
            } else {
                pattern = "n:" + pattern;
            }
            rules.add(pattern);
        }
        return new PatternRule(filterRuleType, rules.toString());
    }

    static String getRuleSpec(TransportAddress ... addresses) {
        StringBuilder ruleSpec = new StringBuilder();
        boolean firstAdded = false;
        for (TransportAddress transportAddress : addresses) {
            if (firstAdded) {
                ruleSpec.append(",");
            } else {
                firstAdded = true;
            }
            ruleSpec.append(NetworkAddress.format((InetAddress)transportAddress.address().getAddress()));
        }
        return ruleSpec.toString();
    }

    public boolean matches(InetSocketAddress remoteAddress) {
        return this.ipFilterRule.matches(remoteAddress);
    }

    public IpFilterRuleType ruleType() {
        return this.ipFilterRule.ruleType();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.toString());
    }
}

