/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.logstash.LogstashFeatureSetUsage;

public class LogstashFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;

    @Inject
    public LogstashFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState) {
        this.enabled = (Boolean)XPackSettings.LOGSTASH_ENABLED.get(settings);
        this.licenseState = licenseState;
    }

    public String name() {
        return "logstash";
    }

    public String description() {
        return "Logstash management component for X-Pack";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isLogstashAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        listener.onResponse((Object)new LogstashFeatureSetUsage(this.available(), this.enabled()));
    }
}

