/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;

final class Pre67PutFollow {
    private static final Logger logger = LogManager.getLogger(Pre67PutFollow.class);
    private final Client client;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final ActiveShardsObserver activeShardsObserver;

    Pre67PutFollow(Client client, ClusterService clusterService, AllocationService allocationService, ActiveShardsObserver activeShardsObserver) {
        this.client = client;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.activeShardsObserver = activeShardsObserver;
    }

    void doPre67PutFollow(final PutFollowAction.Request request, final IndexMetaData leaderIndexMetaData, final String[] historyUUIDs, ActionListener<PutFollowAction.Response> listener) {
        ActionListener handler = ActionListener.wrap(result -> {
            if (result.booleanValue()) {
                this.initiateFollowing(request, listener);
            } else {
                listener.onResponse((Object)new PutFollowAction.Response(true, false, false));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.clusterService.submitStateUpdateTask("create_following_index", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Boolean>((AckedRequest)request, handler){

            protected Boolean newResponse(boolean acknowledged) {
                return acknowledged;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                String followIndex = request.getFollowerIndex();
                IndexMetaData currentIndex = currentState.metaData().index(followIndex);
                if (currentIndex != null) {
                    throw new ResourceAlreadyExistsException(currentIndex.getIndex());
                }
                MetaData.Builder mdBuilder = MetaData.builder((MetaData)currentState.metaData());
                IndexMetaData.Builder imdBuilder = IndexMetaData.builder((String)followIndex);
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("leader_index_shard_history_uuids", String.join((CharSequence)",", historyUUIDs));
                metadata.put("leader_index_uuid", leaderIndexMetaData.getIndexUUID());
                metadata.put("leader_index_name", leaderIndexMetaData.getIndex().getName());
                metadata.put("remote_cluster_name", request.getRemoteCluster());
                imdBuilder.putCustom("ccr", metadata);
                Settings.Builder settingsBuilder = Settings.builder();
                settingsBuilder.put(leaderIndexMetaData.getSettings());
                settingsBuilder.put("index.uuid", UUIDs.randomBase64UUID());
                settingsBuilder.put("index.provided_name", followIndex);
                settingsBuilder.put(CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey(), true);
                settingsBuilder.put(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), true);
                imdBuilder.settings(settingsBuilder);
                for (ObjectObjectCursor cursor : leaderIndexMetaData.getMappings()) {
                    imdBuilder.putMapping((MappingMetaData)cursor.value);
                }
                imdBuilder.setRoutingNumShards(leaderIndexMetaData.getRoutingNumShards());
                IndexMetaData followIMD = imdBuilder.build();
                mdBuilder.put(followIMD, false);
                ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                builder.metaData(mdBuilder.build());
                ClusterState updatedState = builder.build();
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder((RoutingTable)updatedState.routingTable()).addAsNew(updatedState.metaData().index(request.getFollowerIndex()));
                updatedState = Pre67PutFollow.this.allocationService.reroute(ClusterState.builder((ClusterState)updatedState).routingTable(routingTableBuilder.build()).build(), "follow index [" + request.getFollowerIndex() + "] created");
                logger.info("[{}] creating index, cause [ccr_create_and_follow], shards [{}]/[{}]", (Object)followIndex, (Object)followIMD.getNumberOfShards(), (Object)followIMD.getNumberOfReplicas());
                return updatedState;
            }
        });
    }

    private void initiateFollowing(PutFollowAction.Request request, ActionListener<PutFollowAction.Response> listener) {
        this.activeShardsObserver.waitForActiveShards(new String[]{request.getFollowerIndex()}, ActiveShardCount.DEFAULT, request.timeout(), result -> {
            if (result.booleanValue()) {
                ResumeFollowAction.Request resumeFollowRequest = new ResumeFollowAction.Request();
                resumeFollowRequest.setFollowerIndex(request.getFollowerIndex());
                resumeFollowRequest.setParameters(request.getParameters());
                this.client.execute((Action)ResumeFollowAction.INSTANCE, (ActionRequest)resumeFollowRequest, ActionListener.wrap(r -> listener.onResponse((Object)new PutFollowAction.Response(true, true, r.isAcknowledged())), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onResponse((Object)new PutFollowAction.Response(true, false, false));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }
}

