/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ErrorLogSeverity {
    DEBUG,
    FATAL_ERROR,
    INFORMATION,
    MILD_ERROR,
    MILD_WARNING,
    NOTICE,
    SEVERE_ERROR,
    SEVERE_WARNING;


    public static ErrorLogSeverity forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "debug": {
                return DEBUG;
            }
            case "fatalerror": 
            case "fatal-error": 
            case "fatal_error": {
                return FATAL_ERROR;
            }
            case "information": {
                return INFORMATION;
            }
            case "milderror": 
            case "mild-error": 
            case "mild_error": {
                return MILD_ERROR;
            }
            case "mildwarning": 
            case "mild-warning": 
            case "mild_warning": {
                return MILD_WARNING;
            }
            case "notice": {
                return NOTICE;
            }
            case "severeerror": 
            case "severe-error": 
            case "severe_error": {
                return SEVERE_ERROR;
            }
            case "severewarning": 
            case "severe-warning": 
            case "severe_warning": {
                return SEVERE_WARNING;
            }
        }
        return null;
    }
}

