/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.AggregateInputStream;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PassphraseEncryptedInputStream;
import com.unboundid.util.PassphraseEncryptedStreamHeader;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ToolUtils {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    private static final Method GET_PASSPHRASE_FOR_ENCRYPTION_SETTINGS_ID_METHOD;

    private ToolUtils() {
    }

    /*
     * Exception decompiling
     */
    public static String readEncryptionPassphraseFromFile(File f) throws LDAPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String promptForEncryptionPassphrase(boolean allowEmpty, boolean confirm, PrintStream out, PrintStream err) throws LDAPException {
        return ToolUtils.promptForEncryptionPassphrase(allowEmpty, confirm, ToolMessages.INFO_TOOL_UTILS_ENCRYPTION_PW_PROMPT.get(), ToolMessages.INFO_TOOL_UTILS_ENCRYPTION_PW_CONFIRM.get(), out, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String promptForEncryptionPassphrase(boolean allowEmpty, boolean confirm, CharSequence initialPrompt, CharSequence confirmPrompt, PrintStream out, PrintStream err) throws LDAPException {
        String string;
        char[] confirmChars;
        block12: {
            char[] passphraseChars;
            Validator.ensureTrue(initialPrompt != null && initialPrompt.length() > 0, "TestUtils.promptForEncryptionPassphrase.initialPrompt must not be null or empty.");
            Validator.ensureTrue(!confirm || confirmPrompt != null && confirmPrompt.length() > 0, "TestUtils.promptForEncryptionPassphrase.confirmPrompt must not be null or empty when confirm is true.");
            Validator.ensureTrue(out != null, "ToolUtils.promptForEncryptionPassphrase.out must not be null");
            Validator.ensureTrue(err != null, "ToolUtils.promptForEncryptionPassphrase.err must not be null");
            while (true) {
                block11: {
                    block9: {
                        block10: {
                            passphraseChars = null;
                            confirmChars = null;
                            ToolUtils.wrapPrompt(initialPrompt, true, out);
                            passphraseChars = PasswordReader.readPasswordChars();
                            if (passphraseChars != null && passphraseChars.length != 0) break block9;
                            if (allowEmpty) {
                                passphraseChars = StaticUtils.NO_CHARS;
                                break block9;
                            }
                            ToolUtils.wrap(ToolMessages.ERR_TOOL_UTILS_ENCRYPTION_PW_EMPTY.get(), err);
                            err.println();
                            if (passphraseChars == null) break block10;
                            Arrays.fill(passphraseChars, '\u0000');
                        }
                        if (confirmChars == null) continue;
                        Arrays.fill(confirmChars, '\u0000');
                        continue;
                    }
                    if (!confirm) break;
                    ToolUtils.wrapPrompt(confirmPrompt, true, out);
                    confirmChars = PasswordReader.readPasswordChars();
                    if (confirmChars != null && Arrays.equals(passphraseChars, confirmChars)) break;
                    ToolUtils.wrap(ToolMessages.ERR_TOOL_UTILS_ENCRYPTION_PW_MISMATCH.get(), err);
                    err.println();
                    if (passphraseChars == null) break block11;
                    Arrays.fill(passphraseChars, '\u0000');
                }
                if (confirmChars == null) continue;
                Arrays.fill(confirmChars, '\u0000');
            }
            try {
                string = new String(passphraseChars);
                if (passphraseChars == null) break block12;
            }
            catch (Throwable throwable) {
                if (passphraseChars != null) {
                    Arrays.fill(passphraseChars, '\u0000');
                }
                if (confirmChars != null) {
                    Arrays.fill(confirmChars, '\u0000');
                }
                throw throwable;
            }
            Arrays.fill(passphraseChars, '\u0000');
        }
        if (confirmChars != null) {
            Arrays.fill(confirmChars, '\u0000');
        }
        return string;
    }

    public static void wrap(CharSequence message, PrintStream out) {
        Validator.ensureTrue(out != null, "ToolUtils.wrap.out must not be null.");
        if (message == null || message.length() == 0) {
            out.println();
            return;
        }
        for (String line : StaticUtils.wrapLine(message.toString(), WRAP_COLUMN)) {
            out.println(line);
        }
    }

    public static void wrapPrompt(CharSequence prompt, boolean ensureTrailingSpace, PrintStream out) {
        Validator.ensureTrue(prompt != null && prompt.length() > 0, "ToolUtils.wrapPrompt.prompt must not be null or empty.");
        Validator.ensureTrue(out != null, "ToolUtils.wrapPrompt.out must not be null.");
        String promptString = prompt.toString();
        if (ensureTrailingSpace && !promptString.endsWith(" ")) {
            promptString = promptString + ' ';
        }
        List<String> lines = StaticUtils.wrapLine(promptString, WRAP_COLUMN);
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (iterator.hasNext()) {
                out.println(line);
                continue;
            }
            out.print(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectPair<InputStream, String> getInputStreamForLDIFFiles(List<File> ldifFiles, String encryptionPassphrase, PrintStream out, PrintStream err) throws IOException {
        Validator.ensureTrue(ldifFiles != null && !ldifFiles.isEmpty(), "ToolUtils.getInputStreamForLDIFFiles.ldifFiles must not be null or empty.");
        Validator.ensureTrue(out != null, "ToolUtils.getInputStreamForLDIFFiles.out must not be null");
        Validator.ensureTrue(err != null, "ToolUtils.getInputStreamForLDIFFiles.err must not be null");
        boolean createdSuccessfully = false;
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(ldifFiles.size() * 2);
        try {
            ObjectPair<InputStream, String> objectPair;
            byte[] twoEOLs = null;
            String passphrase = encryptionPassphrase;
            for (File f : ldifFiles) {
                if (!inputStreams.isEmpty()) {
                    if (twoEOLs == null) {
                        ByteStringBuffer buffer = new ByteStringBuffer(4);
                        buffer.append(StaticUtils.EOL_BYTES);
                        buffer.append(StaticUtils.EOL_BYTES);
                        twoEOLs = buffer.toByteArray();
                    }
                    inputStreams.add(new ByteArrayInputStream(twoEOLs));
                }
                InputStream inputStream = new FileInputStream(f);
                try {
                    ObjectPair<InputStream, String> p = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream, passphrase, encryptionPassphrase == null, (CharSequence)ToolMessages.INFO_TOOL_UTILS_ENCRYPTED_LDIF_FILE_PW_PROMPT.get(f.getPath()), (CharSequence)ToolMessages.ERR_TOOL_UTILS_ENCRYPTED_LDIF_FILE_WRONG_PW.get(), out, err);
                    inputStream = p.getFirst();
                    if (p.getSecond() != null && passphrase == null) {
                        passphrase = p.getSecond();
                    }
                }
                catch (GeneralSecurityException e) {
                    Debug.debugException(e);
                    inputStream.close();
                    throw new IOException(ToolMessages.ERR_TOOL_UTILS_ENCRYPTED_LDIF_FILE_CANNOT_DECRYPT.get(f.getPath(), StaticUtils.getExceptionMessage(e)), e);
                }
                inputStream = ToolUtils.getPossiblyGZIPCompressedInputStream(inputStream);
                inputStreams.add(inputStream);
            }
            createdSuccessfully = true;
            if (inputStreams.size() == 1) {
                objectPair = new ObjectPair(inputStreams.get(0), passphrase);
                return objectPair;
            }
            objectPair = new ObjectPair<AggregateInputStream, String>(new AggregateInputStream(inputStreams), passphrase);
            return objectPair;
        }
        finally {
            if (!createdSuccessfully) {
                for (InputStream inputStream : inputStreams) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        Debug.debugException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getPossiblyGZIPCompressedInputStream(InputStream inputStream) throws IOException {
        boolean isCompressed;
        Validator.ensureTrue(inputStream != null, "StaticUtils.getPossiblyGZIPCompressedInputStream.inputStream must not be null.");
        InputStream markableInputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        markableInputStream.mark(2);
        try {
            isCompressed = markableInputStream.read() == 31 && markableInputStream.read() == 139;
        }
        finally {
            markableInputStream.reset();
        }
        if (isCompressed) {
            return new GZIPInputStream(markableInputStream);
        }
        return markableInputStream;
    }

    public static ObjectPair<InputStream, String> getPossiblyPassphraseEncryptedInputStream(InputStream inputStream, String passphrase, boolean promptOnIncorrectPassphrase, CharSequence passphrasePrompt, CharSequence incorrectPassphraseError, PrintStream standardOutput, PrintStream standardError) throws IOException, InvalidKeyException, GeneralSecurityException {
        ObjectPair<InputStream, char[]> p = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream, passphrase == null ? null : passphrase.toCharArray(), promptOnIncorrectPassphrase, passphrasePrompt, incorrectPassphraseError, standardOutput, standardError);
        if (p.getSecond() == null) {
            return new ObjectPair<InputStream, Object>(p.getFirst(), null);
        }
        return new ObjectPair<InputStream, String>(p.getFirst(), new String(p.getSecond()));
    }

    public static ObjectPair<InputStream, char[]> getPossiblyPassphraseEncryptedInputStream(InputStream inputStream, char[] passphrase, boolean promptOnIncorrectPassphrase, CharSequence passphrasePrompt, CharSequence incorrectPassphraseError, PrintStream out, PrintStream err) throws IOException, InvalidKeyException, GeneralSecurityException {
        PassphraseEncryptedStreamHeader streamHeaderShell;
        Validator.ensureTrue(inputStream != null, "StaticUtils.getPossiblyPassphraseEncryptedInputStream.inputStream must not be null.");
        Validator.ensureTrue(passphrasePrompt != null && passphrasePrompt.length() > 0, "StaticUtils.getPossiblyPassphraseEncryptedInputStream.passphrasePrompt must not be null or empty.");
        Validator.ensureTrue(incorrectPassphraseError != null && incorrectPassphraseError.length() > 0, "StaticUtils.getPossiblyPassphraseEncryptedInputStream.incorrectPassphraseError must not be null or empty.");
        Validator.ensureTrue(out != null, "StaticUtils.getPossiblyPassphraseEncryptedInputStream.standardOutput must not be null.");
        Validator.ensureTrue(err != null, "StaticUtils.getPossiblyPassphraseEncryptedInputStream.standardError must not be null.");
        InputStream markableInputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        markableInputStream.mark(1024);
        try {
            streamHeaderShell = PassphraseEncryptedStreamHeader.readFrom(markableInputStream, null);
        }
        catch (LDAPException e) {
            Debug.debugException(Level.FINEST, e);
            markableInputStream.reset();
            return new ObjectPair<InputStream, Object>(markableInputStream, null);
        }
        if (passphrase != null) {
            try {
                PassphraseEncryptedStreamHeader validStreamHeader = PassphraseEncryptedStreamHeader.decode(streamHeaderShell.getEncodedHeader(), passphrase);
                return new ObjectPair<InputStream, char[]>(new PassphraseEncryptedInputStream(markableInputStream, validStreamHeader), passphrase);
            }
            catch (InvalidKeyException e) {
                Debug.debugException(e);
                if (!promptOnIncorrectPassphrase) {
                    throw e;
                }
            }
            catch (GeneralSecurityException e) {
                Debug.debugException(e);
                throw e;
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new GeneralSecurityException(e.getMessage(), e);
            }
        }
        if (streamHeaderShell.getKeyIdentifier() != null && GET_PASSPHRASE_FOR_ENCRYPTION_SETTINGS_ID_METHOD != null) {
            try {
                Object passphraseObject = GET_PASSPHRASE_FOR_ENCRYPTION_SETTINGS_ID_METHOD.invoke(null, streamHeaderShell.getKeyIdentifier(), out, err);
                if (passphraseObject != null && passphraseObject instanceof String) {
                    char[] passphraseChars = ((String)passphraseObject).toCharArray();
                    PassphraseEncryptedStreamHeader validStreamHeader = PassphraseEncryptedStreamHeader.decode(streamHeaderShell.getEncodedHeader(), passphraseChars);
                    return new ObjectPair<InputStream, char[]>(new PassphraseEncryptedInputStream(markableInputStream, validStreamHeader), passphraseChars);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        while (true) {
            String promptedPassphrase;
            try {
                promptedPassphrase = ToolUtils.promptForEncryptionPassphrase(false, false, passphrasePrompt, null, out, err);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new IOException(e.getMessage(), e);
            }
            try {
                char[] passphraseChars = promptedPassphrase.toCharArray();
                PassphraseEncryptedStreamHeader validStreamHeader = PassphraseEncryptedStreamHeader.decode(streamHeaderShell.getEncodedHeader(), passphraseChars);
                return new ObjectPair<InputStream, char[]>(new PassphraseEncryptedInputStream(markableInputStream, validStreamHeader), passphraseChars);
            }
            catch (InvalidKeyException e) {
                Debug.debugException(e);
                ToolUtils.wrap(incorrectPassphraseError, err);
                err.println();
                continue;
            }
            catch (GeneralSecurityException e) {
                Debug.debugException(e);
                throw e;
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                throw new GeneralSecurityException(e.getMessage(), e);
            }
            break;
        }
    }

    static {
        Method m = null;
        try {
            Class<?> serverStaticUtilsClass = Class.forName("com.unboundid.directory.server.util.StaticUtils");
            m = serverStaticUtilsClass.getMethod("getPassphraseForEncryptionSettingsID", String.class, PrintStream.class, PrintStream.class);
        }
        catch (Exception e) {
            Debug.debugException(Level.FINEST, e);
        }
        GET_PASSPHRASE_FOR_ENCRYPTION_SETTINGS_ID_METHOD = m;
    }
}

