/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.AbstractScopedSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.core.security.SecurityExtension;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.InternalRealmsSettings;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;

public class RealmSettings {
    public static final String PREFIX = SecurityField.setting("authc.realms.");
    static final Setting<String> TYPE_SETTING = Setting.simpleString((String)"type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Boolean> ENABLED_SETTING = Setting.boolSetting((String)"enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Integer> ORDER_SETTING = Setting.intSetting((String)"order", (int)Integer.MAX_VALUE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public static void addSettings(List<Setting<?>> settingsList, List<SecurityExtension> extensions) {
        settingsList.add(RealmSettings.getGroupSetting(extensions));
    }

    public static Collection<String> getSettingsFilter(List<SecurityExtension> extensions) {
        return RealmSettings.getSettingsByRealm(extensions).values().stream().flatMap(Collection::stream).filter(Setting::isFiltered).map(setting -> PREFIX + "*." + setting.getKey()).collect(Collectors.toSet());
    }

    public static Settings get(Settings settings) {
        return settings.getByPrefix(PREFIX);
    }

    public static Map<String, Settings> getRealmSettings(Settings globalSettings) {
        Settings realmsSettings = RealmSettings.get(globalSettings);
        return realmsSettings.names().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((Settings)realmsSettings).getAsSettings(arg_0)));
    }

    public static String getFullSettingKey(RealmConfig realm, Setting<?> setting) {
        return RealmSettings.getFullSettingKey(realm.name(), setting);
    }

    public static String getFullSettingKey(RealmConfig realm, String subKey) {
        return RealmSettings.getFullSettingKey(realm.name(), subKey);
    }

    private static String getFullSettingKey(String name, Setting<?> setting) {
        return RealmSettings.getFullSettingKey(name, setting.getKey());
    }

    private static String getFullSettingKey(String name, String subKey) {
        return PREFIX + name + "." + subKey;
    }

    private static Setting<Settings> getGroupSetting(List<SecurityExtension> extensions) {
        return Setting.groupSetting((String)PREFIX, RealmSettings.getSettingsValidator(extensions), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }

    private static Consumer<Settings> getSettingsValidator(List<SecurityExtension> extensions) {
        Map<String, Set<Setting<?>>> childSettings = RealmSettings.getSettingsByRealm(extensions);
        childSettings.forEach(RealmSettings::verify);
        return RealmSettings.validator(childSettings);
    }

    private static Map<String, Set<Setting<?>>> getSettingsByRealm(List<SecurityExtension> extensions) {
        HashMap settingsByRealm = new HashMap(InternalRealmsSettings.getSettings());
        if (extensions != null) {
            extensions.forEach(ext -> {
                Map<String, Set<Setting<?>>> extSettings = ext.getRealmSettings();
                extSettings.keySet().stream().filter(settingsByRealm::containsKey).forEach(type -> {
                    throw new IllegalArgumentException("duplicate realm type " + type);
                });
                settingsByRealm.putAll(extSettings);
            });
        }
        return settingsByRealm;
    }

    private static void verify(String type, Set<Setting<?>> settings) {
        HashSet keys = new HashSet();
        settings.forEach(setting -> {
            String key = setting.getKey();
            if (keys.contains(key)) {
                throw new IllegalArgumentException("duplicate setting for key " + key + " in realm type " + type);
            }
            keys.add(key);
            if (!setting.getProperties().contains(Setting.Property.NodeScope)) {
                throw new IllegalArgumentException("setting " + key + " in realm type " + type + " does not have NodeScope");
            }
        });
    }

    private static Consumer<Settings> validator(Map<String, Set<Setting<?>>> validSettings) {
        return settings -> settings.names().forEach(n -> RealmSettings.validateRealm(n, settings.getAsSettings(n), validSettings));
    }

    private static void validateRealm(String name, Settings settings, Map<String, Set<Setting<?>>> validSettings) {
        String type = RealmSettings.getRealmType(settings);
        if (Strings.isNullOrEmpty((String)type)) {
            throw new IllegalArgumentException("missing realm type [" + RealmSettings.getFullSettingKey(name, TYPE_SETTING) + "] for realm");
        }
        RealmSettings.validateRealm(name, type, settings, validSettings.get(type));
    }

    public static String getRealmType(Settings settings) {
        return (String)TYPE_SETTING.get(settings);
    }

    private static void validateRealm(String name, String type, Settings settings, Set<Setting<?>> validSettings) {
        if (validSettings == null) {
            return;
        }
        settings = Settings.builder().put(settings, false).build();
        validSettings.removeIf(s -> s instanceof SecureSetting);
        HashSet settingSet = new HashSet(validSettings);
        settingSet.add(TYPE_SETTING);
        settingSet.add(ENABLED_SETTING);
        settingSet.add(ORDER_SETTING);
        AbstractScopedSettings validator = new AbstractScopedSettings(settings, settingSet, Collections.emptySet(), Setting.Property.NodeScope){};
        try {
            validator.validate(settings, false);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("incorrect configuration for realm [" + RealmSettings.getFullSettingKey(name, "") + "] of type " + type, e);
        }
    }

    private RealmSettings() {
    }
}

