.TH FBHALF 1 25-Jun-90
.CM 3
.SH NAME
fbhalf \- halftone a grayscale image
.SH SYNOPSIS
.nf
fbhalf [ -fbct<parm> ] [-s<sharpen> ] [ -C<clean> -N<nbr>]
       [ -<type> ] [ size ] < 8bit > 1bit
.fi
.SH DESCRIPTION
.PP
Halftones the 8 bit images and produces a pbm format output.  There are
four halftoning algorithms available: Ulichney's "blue noise"
dithering,  Floyd-Steinberg dithering, Jarvis et al's
"constrained averaging", and simple theshholding.
The default is blue noise, but constrained
averaging works better on line drawings and scanned text (with high
values of gamma \- near 20).  For some images, Floyd-Steinberg gives a
tighter, more pleasing pattern than blue noise, but blue noise is more
robust and far less likely to produce significant artifacts.
.sp
The size argument is a maximum number of pixels.  If given,
.I fbhalf
will resize the image so the width is the largest multiple of 8 such
that the width times the height is less than or equal to the specified
size.  The default is to produce output the same size as the input.
.SH OPTIONS
.TP
.BR -f
.I Floyd-Steinberg
halftoning.  Using 7-5-3-1 weights.
.TP
.BR -b<noise>
.I Blue noise,
with <noise> percent random weights.  As per Robert Ulichney's PhD
thesis.
.TP
.BR -c<gamma>
.I constrained-average
halftoning.  As per Jarvis.  Good for line drawings and graphic art
with a gamma of about 20.
.TP
.BR -t<threshhold>
.I Floyd-simple threshholding,
pixels greater than <threshhold> are set to white,
and those less than or equal to <threshhold> are set to black.
.TP
.BR <size>
.I number of pixels,
specifies a desired number of output pixels.
The actual size used will have an aspect ratio of 1.0 and a width which
is the largest possible multiple of 8 so that the image has less than
or equal the specified number of pixels.
This is a positional argument.
.TP
.BR -s<beta>
.I sharpening,
specifies a certain amount of sharpening after resizing but
before halftoning.  The default is no sharpening.
.TP
.BR -C<num>, -N<num>
.I clean
image by flipping isolated pixels.  A pixel is isolated if there are
fwer than C like colored pixels in the nearby NxN square.  This option
can get rid of "snow" in line art images halftoned by the Jarvis
constrained image halftoning.
.TP
.BR -B
.I face
format, as used by Bennet Yee's
.I face
program at CMU. 
.TP
.BR -F
.I FBM,
format (by default, the default).  You are guaranteed not
to lose information by specifying FBM as the default.
.TP
.BR -G
.I GIF,
Compuserve GIF format.
.TP
.BR -I
.I IFF
format, interleaved bitmaps (ILBM), used by Amigas.
.TP
.BR -P
.I PBM,
Jef Poskanzer's bitmap format.
.TP
.BR -S
.I sun,
Sun rasterfiles (not run length encoded).
.SH EXAMPLE
.PP
Given an 8bit sun rasterfile, halftone using Blue Noise and sharpen
with beta of 8.  Output a Sun 1bit rasterfile:
.sp
    % fbhalf -S -s8 < foo.8bit > foo.1bit
.sp
Using Floyd-Steinberg halftoning, convert a color GIF file to a PBM
bitmap with about 300,000 pixels.  Sharpen slightly with a beta of 2.0:
.sp
    % clr2gray < foo.gif | fbhalf -P -s2.0 300000 > foo.pbm
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
On the 386i, the sharpening option causes a core dump.  As a workaround
you can use the fbsharp(1) command prioer to running fbhalf(1).
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
