/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import com.google.common.base.CharMatcher;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.console.UserInputReceiver;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.internal.logging.events.ReadStdInEvent;
import org.gradle.internal.logging.events.UserInputValidationProblemEvent;

public class DefaultUserInputReceiver
implements GlobalUserInputReceiver {
    private final AtomicReference<UserInputReceiver> delegate = new AtomicReference();
    private OutputEventListener console;

    public void attachConsole(OutputEventListener console) {
        this.console = console;
    }

    @Override
    public void readAndForwardText(final PromptOutputEvent event) {
        UserInputReceiver userInput = this.getDelegate();
        userInput.readAndForwardText(new UserInputReceiver.Normalizer(){

            @Override
            @Nullable
            public String normalize(String text) {
                PromptOutputEvent.PromptResult<?> result = event.convert(CharMatcher.javaIsoControl().removeFrom((CharSequence)StringUtils.trim((String)text)));
                if (result.newPrompt != null) {
                    DefaultUserInputReceiver.this.console.onOutput(new UserInputValidationProblemEvent(event.getTimestamp(), result.newPrompt));
                    return null;
                }
                return result.response.toString();
            }
        });
    }

    @Override
    public void readAndForwardStdin(ReadStdInEvent event) {
        UserInputReceiver userInput = this.getDelegate();
        userInput.readAndForwardStdin();
    }

    private UserInputReceiver getDelegate() {
        UserInputReceiver userInput = this.delegate.get();
        if (userInput == null) {
            throw new IllegalStateException("User input has not been initialized.");
        }
        return userInput;
    }

    @Override
    public void dispatchTo(UserInputReceiver userInput) {
        if (!this.delegate.compareAndSet(null, userInput)) {
            throw new IllegalStateException("User input has already been initialized.");
        }
    }

    @Override
    public void stopDispatching() {
        this.delegate.set(null);
    }
}

