/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.NamedCompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.PhaseBuildersKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.lower.JvmStaticAnnotationLoweringKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0010*\u00020\u0011H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0010*\u00020\u0011H\u0000\u001a\"\u0010\u0014\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\"0\u0010\u0000\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003`\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"0\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0001j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b`\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0006\u00a8\u0006\u0018"}, d2={"jvmStaticInCompanionPhase", "Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/phaser/SameTypeNamedCompilerPhase;", "getJvmStaticInCompanionPhase", "()Lorg/jetbrains/kotlin/backend/common/phaser/NamedCompilerPhase;", "jvmStaticInObjectPhase", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "getJvmStaticInObjectPhase", "coerceToUnit", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrTypeOperatorCallImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "isJvmStaticDeclaration", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isJvmStaticInCompanion", "isJvmStaticInObject", "makeStatic", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "replaceCallee", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "backend.jvm.lower"})
public final class JvmStaticAnnotationLoweringKt {
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> jvmStaticInObjectPhase = PhaseBuildersKt.makeIrModulePhase$default(jvmStaticInObjectPhase.1.INSTANCE, "JvmStaticInObject", "Make JvmStatic functions in non-companion objects static and replace all call sites in the module", null, null, null, null, null, 248, null);
    @NotNull
    private static final NamedCompilerPhase<JvmBackendContext, IrFile> jvmStaticInCompanionPhase = PhaseBuildersKt.makeIrFilePhase$default(jvmStaticInCompanionPhase.1.INSTANCE, "JvmStaticInCompanion", "Synthesize static proxy functions for JvmStatic functions in companion objects", null, null, null, null, null, 248, null);

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrModuleFragment> getJvmStaticInObjectPhase() {
        return jvmStaticInObjectPhase;
    }

    @NotNull
    public static final NamedCompilerPhase<JvmBackendContext, IrFile> getJvmStaticInCompanionPhase() {
        return jvmStaticInCompanionPhase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJvmStaticDeclaration(IrDeclaration $this$isJvmStaticDeclaration) {
        boolean bl;
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)$this$isJvmStaticDeclaration, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME())) return true;
        Object object = $this$isJvmStaticDeclaration instanceof IrSimpleFunction ? (IrSimpleFunction)$this$isJvmStaticDeclaration : null;
        if (object != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null) {
            if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)object, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME())) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!($this$isJvmStaticDeclaration instanceof IrProperty)) return false;
        IrProperty irProperty2 = (IrProperty)$this$isJvmStaticDeclaration;
        IrDeclarationBase irDeclarationBase = irProperty2;
        if (irProperty2 == null) return false;
        IrSimpleFunction irSimpleFunction = irDeclarationBase.getGetter();
        irDeclarationBase = irSimpleFunction;
        if (irSimpleFunction == null) return false;
        if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)irDeclarationBase, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_FQ_NAME())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isJvmStaticInCompanion(IrDeclaration $this$isJvmStaticInCompanion) {
        if (!JvmStaticAnnotationLoweringKt.isJvmStaticDeclaration($this$isJvmStaticInCompanion)) return false;
        IrDeclarationParent irDeclarationParent = $this$isJvmStaticInCompanion.getParent();
        if (!(irDeclarationParent instanceof IrClass)) return false;
        IrClass irClass2 = (IrClass)irDeclarationParent;
        if (irClass2 == null) return false;
        if (!irClass2.isCompanion()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isJvmStaticInObject(@NotNull IrDeclaration $this$isJvmStaticInObject) {
        Intrinsics.checkNotNullParameter((Object)$this$isJvmStaticInObject, (String)"<this>");
        if (!JvmStaticAnnotationLoweringKt.isJvmStaticDeclaration($this$isJvmStaticInObject)) return false;
        IrDeclarationParent irDeclarationParent = $this$isJvmStaticInObject.getParent();
        if (!(irDeclarationParent instanceof IrClass)) return false;
        IrClass irClass2 = (IrClass)irDeclarationParent;
        if (irClass2 == null) return false;
        if (!IrUtilsKt.isNonCompanionObject(irClass2)) return false;
        return true;
    }

    private static final IrTypeOperatorCallImpl coerceToUnit(IrExpression $this$coerceToUnit, IrBuiltIns irBuiltIns) {
        return new IrTypeOperatorCallImpl($this$coerceToUnit.getStartOffset(), $this$coerceToUnit.getEndOffset(), irBuiltIns.getUnitType(), IrTypeOperator.IMPLICIT_COERCION_TO_UNIT, irBuiltIns.getUnitType(), $this$coerceToUnit);
    }

    private static final IrExpression makeStatic(IrMemberAccessExpression<?> $this$makeStatic, IrBuiltIns irBuiltIns, IrSimpleFunction replaceCallee) {
        IrBlockImpl irBlockImpl;
        IrExpression irExpression = $this$makeStatic.getDispatchReceiver();
        if (irExpression == null) {
            return $this$makeStatic;
        }
        IrExpression receiver = irExpression;
        $this$makeStatic.setDispatchReceiver(null);
        if (replaceCallee != null) {
            Intrinsics.checkNotNull($this$makeStatic, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
            ((IrCall)$this$makeStatic).setSymbol(replaceCallee.getSymbol());
        }
        if (IrUtilsKt.isTrivial(receiver)) {
            return $this$makeStatic;
        }
        IrBlockImpl $this$makeStatic_u24lambda_u240 = irBlockImpl = new IrBlockImpl($this$makeStatic.getStartOffset(), $this$makeStatic.getEndOffset(), $this$makeStatic.getType(), null, 8, null);
        boolean bl = false;
        ((Collection)$this$makeStatic_u24lambda_u240.getStatements()).add(JvmStaticAnnotationLoweringKt.coerceToUnit(receiver, irBuiltIns));
        ((Collection)$this$makeStatic_u24lambda_u240.getStatements()).add($this$makeStatic);
        return irBlockImpl;
    }

    public static final /* synthetic */ boolean access$isJvmStaticDeclaration(IrDeclaration $receiver) {
        return JvmStaticAnnotationLoweringKt.isJvmStaticDeclaration($receiver);
    }

    public static final /* synthetic */ IrExpression access$makeStatic(IrMemberAccessExpression $receiver, IrBuiltIns irBuiltIns, IrSimpleFunction replaceCallee) {
        return JvmStaticAnnotationLoweringKt.makeStatic($receiver, irBuiltIns, replaceCallee);
    }

    public static final /* synthetic */ boolean access$isJvmStaticInCompanion(IrDeclaration $receiver) {
        return JvmStaticAnnotationLoweringKt.isJvmStaticInCompanion($receiver);
    }
}

