/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mood;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.mood.Mood;
import org.jivesoftware.smackx.mood.element.MoodConcretisation;
import org.jivesoftware.smackx.mood.element.MoodElement;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.PubSubException;

public final class MoodManager
extends Manager {
    public static final String MOOD_NODE = "http://jabber.org/protocol/mood";
    private static final Map<XMPPConnection, MoodManager> INSTANCES = new WeakHashMap<XMPPConnection, MoodManager>();
    private final PepManager pepManager;

    private MoodManager(XMPPConnection connection) {
        super(connection);
        this.pepManager = PepManager.getInstanceFor(connection);
    }

    public static synchronized MoodManager getInstanceFor(XMPPConnection connection) {
        MoodManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new MoodManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public void setMood(Mood mood) throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        this.setMood(mood, null, null);
    }

    public void setMood(Mood mood, String text) throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        this.setMood(mood, null, text);
    }

    public void setMood(Mood mood, MoodConcretisation concretisation) throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        this.setMood(mood, concretisation, null);
    }

    public void setMood(Mood mood, MoodConcretisation concretisation, String text) throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        MoodElement element = MoodManager.buildMood(mood, concretisation, text);
        this.publishMood(element);
    }

    public void clearMood() throws InterruptedException, SmackException.NotLoggedInException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        MoodElement element = MoodManager.buildMood(null, null, null);
        this.publishMood(element);
    }

    private void publishMood(MoodElement moodElement) throws SmackException.NotLoggedInException, InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException {
        this.pepManager.publish(MOOD_NODE, new PayloadItem<MoodElement>(moodElement));
    }

    private static MoodElement buildMood(Mood mood, MoodConcretisation concretisation, String text) {
        return new MoodElement(new MoodElement.MoodSubjectElement(mood, concretisation), text);
    }

    public static void addMoodToMessage(Message message, Mood mood) {
        MoodManager.addMoodToMessage(message, mood, null);
    }

    public static void addMoodToMessage(Message message, Mood mood, MoodConcretisation concretisation) {
        MoodElement element = MoodManager.buildMood(mood, concretisation, null);
        message.addExtension((ExtensionElement)element);
    }

    public boolean addMoodListener(PepEventListener<MoodElement> listener) {
        return this.pepManager.addPepEventListener(MOOD_NODE, MoodElement.class, listener);
    }

    public boolean removeMoodListener(PepEventListener<MoodElement> listener) {
        return this.pepManager.removePepEventListener(listener);
    }
}

