/*
 * Decompiled with CFR 0.152.
 */
package com.agafua.syslog;

import com.agafua.syslog.Message;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.BlockingQueue;

class UdpSender
implements Runnable {
    private static final int FAILURE_TIMEOUT = 5000;
    private final String hostName;
    private final int port;
    private final Thread worker;
    private final BlockingQueue<Message> blockingQueue;

    public UdpSender(String hostName, int port, BlockingQueue<Message> blockingQueue) {
        this.hostName = hostName;
        this.port = port;
        this.worker = new Thread(new Worker());
        this.blockingQueue = blockingQueue;
    }

    @Override
    public void run() {
        this.worker.start();
    }

    private class Worker
    implements Runnable {
        private DatagramSocket socket;
        private InetAddress address;

        private Worker() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (this.socket == null) {
                            this.address = InetAddress.getByName(UdpSender.this.hostName);
                            this.socket = new DatagramSocket();
                        }
                        Message message = (Message)UdpSender.this.blockingQueue.take();
                        DatagramPacket packet = new DatagramPacket(message.getBytes(), message.getLength(), this.address, UdpSender.this.port);
                        this.socket.send(packet);
                    }
                }
                catch (InterruptedException e) {
                    this.releaseResources();
                    return;
                }
                catch (IOException e) {
                    this.releaseResources();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
                catch (Throwable t) {
                    this.releaseResources();
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }

        private void releaseResources() {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (Throwable t) {
                this.socket = null;
            }
        }
    }
}

