/*
 * Decompiled with CFR 0.152.
 */
package free.util.audio;

import free.util.BlockingQueue;
import free.util.PlatformUtils;
import free.util.audio.AudioClip;
import free.util.audio.AudioPlayer;
import java.applet.Applet;
import java.util.Hashtable;

public class AppletAudioPlayer
implements AudioPlayer,
Runnable {
    private Thread playerThread = null;
    private final Hashtable audioClips = new Hashtable();
    private final BlockingQueue clipQueue = new BlockingQueue();

    public boolean isSupported() {
        return PlatformUtils.isJavaBetterThan("1.2");
    }

    public void play(AudioClip audioClip) {
        if (this.playerThread == null) {
            this.playerThread = new Thread((Runnable)this, "AppletAudioPlayer");
            this.playerThread.setDaemon(true);
            this.playerThread.start();
        }
        this.clipQueue.push(audioClip);
    }

    public void run() {
        while (true) {
            AudioClip audioClip;
            try {
                audioClip = (AudioClip)this.clipQueue.pop();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
            java.applet.AudioClip audioClip2 = (java.applet.AudioClip)this.audioClips.get(audioClip);
            if (audioClip2 == null) {
                audioClip2 = Applet.newAudioClip(audioClip.getURL());
                this.audioClips.put(audioClip, audioClip2);
            }
            audioClip2.play();
        }
    }
}

