/*
 * Decompiled with CFR 0.152.
 */
package free.freechess;

import free.util.Struct;
import java.util.StringTokenizer;

public class Style12Struct
extends Struct {
    public static final int MY_GAME = 1;
    public static final int OBSERVED_GAME = 2;
    public static final int ISOLATED_BOARD = 3;

    public Style12Struct(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3, String string3, String string4, int n4, boolean bl5, boolean bl6, int n5, int n6, int n7, int n8, int n9, int n10, int n11, String string5, String string6, int n12, boolean bl7, boolean bl8, int n13) {
        if (n < -1 || n > 7) {
            throw new IllegalArgumentException("Bad value for double pawn push file: " + n);
        }
        if (string == null) {
            throw new IllegalArgumentException("Board may not be null");
        }
        if (string.length() != 64) {
            throw new IllegalArgumentException("Board string length (" + string.length() + ") must be 64 characters");
        }
        if (string2 == null || !string2.equals("W") && !string2.equals("B")) {
            throw new IllegalArgumentException("Current player string (" + string2 + ") must be either \"W\" or \"B\"");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Plies since irreversible move (" + n2 + ") cannot be negative");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("White name may not be null");
        }
        if (string4 == null) {
            throw new IllegalArgumentException("Black name may not be null");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Initial time (" + n5 + ") must be positive");
        }
        if (n6 < 0) {
            throw new IllegalArgumentException("Increment (" + n6 + ") may not be negative");
        }
        if (n7 < 0) {
            throw new IllegalArgumentException("White's material strength (" + n7 + ") may not be negative");
        }
        if (n8 < 0) {
            throw new IllegalArgumentException("Black's material strength (" + n8 + ") may not be negative");
        }
        if (n11 <= 0) {
            throw new IllegalArgumentException("The next move number (" + n11 + ") must be positive");
        }
        if (n12 < 0) {
            throw new IllegalArgumentException("The amount of time taken by the last move (" + n12 + ") may not be negative");
        }
        switch (n4) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown game type: " + n4);
            }
        }
        if (n13 < 0) {
            throw new IllegalArgumentException("Lag may not be negative (really, it's against the laws of physics)");
        }
        this.setStringProperty("BoardLexigraphic", string);
        this.setStringProperty("CurrentPlayer", string2);
        this.setIntegerProperty("DoublePawnPushFile", n);
        this.setBooleanProperty("CanWhiteCastleKingside", bl);
        this.setBooleanProperty("CanWhiteCastleQueenside", bl2);
        this.setBooleanProperty("CanBlackCastleKingside", bl3);
        this.setBooleanProperty("CanBlackCastleQueenside", bl4);
        this.setIntegerProperty("PliesSinceIrreversible", n2);
        this.setIntegerProperty("GameNumber", n3);
        this.setStringProperty("WhiteName", string3);
        this.setStringProperty("BlackName", string4);
        this.setIntegerProperty("GameType", n4);
        this.setBooleanProperty("IsPlayedGame", bl5);
        this.setBooleanProperty("IsMyTurn", bl6);
        this.setIntegerProperty("InitTime", n5);
        this.setIntegerProperty("Increment", n6);
        this.setIntegerProperty("WhiteMaterialStrength", n7);
        this.setIntegerProperty("BlackMaterialStrength", n8);
        this.setIntegerProperty("WhiteTime", n9);
        this.setIntegerProperty("BlackTime", n10);
        this.setIntegerProperty("NextMoveNumber", n11);
        this.setStringProperty("MoveVerbose", string5);
        this.setStringProperty("MoveSAN", string6);
        this.setIntegerProperty("MoveTime", n12);
        this.setBooleanProperty("IsBoardFlipped", bl7);
        this.setBooleanProperty("IsClockRunning", bl8);
        this.setIntegerProperty("Lag", n13);
    }

    public static Style12Struct parseStyle12Line(String string) {
        boolean bl;
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.nextToken().equals("<12>")) {
            throw new IllegalArgumentException("Missing \"<12>\" identifier");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i = 0; i < 8; ++i) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        String string2 = stringBuffer.toString();
        String string3 = stringTokenizer.nextToken();
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        boolean bl2 = Style12Struct.parseBoolean(stringTokenizer.nextToken());
        boolean bl3 = Style12Struct.parseBoolean(stringTokenizer.nextToken());
        boolean bl4 = Style12Struct.parseBoolean(stringTokenizer.nextToken());
        boolean bl5 = Style12Struct.parseBoolean(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        switch (n5) {
            case -3: {
                n = 3;
                bl = false;
                break;
            }
            case -2: {
                n = 2;
                bl = false;
                break;
            }
            case -1: 
            case 1: {
                n = 1;
                bl = true;
                break;
            }
            case 0: {
                n = 2;
                bl = true;
                break;
            }
            case 2: {
                n = 1;
                bl = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad myRelation value: " + n5);
            }
        }
        boolean bl6 = n5 > 0;
        int n6 = 60 * Integer.parseInt(stringTokenizer.nextToken());
        int n7 = Integer.parseInt(stringTokenizer.nextToken());
        int n8 = Integer.parseInt(stringTokenizer.nextToken());
        int n9 = Integer.parseInt(stringTokenizer.nextToken());
        int n10 = Integer.parseInt(stringTokenizer.nextToken());
        int n11 = Integer.parseInt(stringTokenizer.nextToken());
        int n12 = Integer.parseInt(stringTokenizer.nextToken());
        String string6 = stringTokenizer.nextToken();
        if (string6.equals("none")) {
            string6 = null;
        }
        String string7 = stringTokenizer.nextToken();
        string7 = string7.substring(1, string7.length() - 1);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string7, ":.");
        int n13 = Integer.parseInt(stringTokenizer2.nextToken());
        int n14 = Integer.parseInt(stringTokenizer2.nextToken());
        int n15 = Integer.parseInt(stringTokenizer2.nextToken());
        int n16 = 60000 * n13 + 1000 * n14 + n15;
        String string8 = stringTokenizer.nextToken();
        if (string8.equals("none")) {
            string8 = null;
        }
        boolean bl7 = Style12Struct.parseBoolean(stringTokenizer.nextToken());
        boolean bl8 = Style12Struct.parseBoolean(stringTokenizer.nextToken());
        int n17 = Integer.parseInt(stringTokenizer.nextToken());
        return new Style12Struct(string2, string3, n2, bl2, bl3, bl4, bl5, n3, n4, string4, string5, n, bl, bl6, n6, n7, n8, n9, n10, n11, n12, string6, string8, n16, bl7, bl8, n17);
    }

    private static boolean parseBoolean(String string) {
        if (string.equals("1")) {
            return true;
        }
        if (string.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException("Bad boolean value: " + string);
    }

    public String getBoardLexigraphic() {
        return this.getStringProperty("BoardLexigraphic");
    }

    public String getBoardFEN() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getBoardLexigraphic();
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                char c = string.charAt(j + i * 8);
                if (c == '-') {
                    ++n;
                    continue;
                }
                if (n != 0) {
                    stringBuffer.append(n);
                    n = 0;
                }
                stringBuffer.append(c);
            }
            if (n != 0) {
                stringBuffer.append(n);
                n = 0;
            }
            if (i == 7) continue;
            stringBuffer.append('/');
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.getCurrentPlayer().toLowerCase());
        stringBuffer.append(" ");
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.canWhiteCastleKingside()) {
            stringBuffer2.append('K');
        }
        if (this.canWhiteCastleQueenside()) {
            stringBuffer2.append('Q');
        }
        if (this.canBlackCastleKingside()) {
            stringBuffer2.append('k');
        }
        if (this.canBlackCastleQueenside()) {
            stringBuffer2.append('q');
        }
        stringBuffer.append(stringBuffer2.length() == 0 ? "-" : stringBuffer2.toString());
        stringBuffer.append(" ");
        String string2 = this.getDoublePawnPushFile() == -1 ? "-" : "" + (97 + this.getDoublePawnPushFile()) + (this.getCurrentPlayer().equals("W") ? "6" : "3");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(this.getPliesSinceIrreversible());
        stringBuffer.append(" ");
        stringBuffer.append(this.getNextMoveNumber());
        return stringBuffer.toString();
    }

    public String getCurrentPlayer() {
        return this.getStringProperty("CurrentPlayer");
    }

    public int getDoublePawnPushFile() {
        return this.getIntegerProperty("DoublePawnPushFile");
    }

    public boolean canWhiteCastleKingside() {
        return this.getBooleanProperty("CanWhiteCastleKingside");
    }

    public boolean canWhiteCastleQueenside() {
        return this.getBooleanProperty("CanWhiteCastleQueenside");
    }

    public boolean canBlackCastleKingside() {
        return this.getBooleanProperty("CanBlackCastleKingside");
    }

    public boolean canBlackCastleQueenside() {
        return this.getBooleanProperty("CanBlackCastleQueenside");
    }

    public int getPliesSinceIrreversible() {
        return this.getIntegerProperty("PliesSinceIrreversible");
    }

    public int getGameNumber() {
        return this.getIntegerProperty("GameNumber");
    }

    public String getWhiteName() {
        return this.getStringProperty("WhiteName");
    }

    public String getBlackName() {
        return this.getStringProperty("BlackName");
    }

    public int getGameType() {
        return this.getIntegerProperty("GameType");
    }

    public boolean isPlayedGame() {
        return this.getBooleanProperty("IsPlayedGame");
    }

    public boolean isMyTurn() {
        if (this.getGameType() != 1 || !this.isPlayedGame()) {
            throw new IllegalStateException("Either the game type is not MY_GAME or it's not a played game.");
        }
        return this.getBooleanProperty("IsMyTurn");
    }

    public int getInitialTime() {
        return this.getIntegerProperty("InitTime");
    }

    public int getIncrement() {
        return this.getIntegerProperty("Increment");
    }

    public int getWhiteMaterialStrength() {
        return this.getIntegerProperty("WhiteMaterialStrength");
    }

    public int getBlackMaterialStrength() {
        return this.getIntegerProperty("BlackMaterialStrength");
    }

    public int getWhiteTime() {
        return this.getIntegerProperty("WhiteTime");
    }

    public int getBlackTime() {
        return this.getIntegerProperty("BlackTime");
    }

    public int getNextMoveNumber() {
        return this.getIntegerProperty("NextMoveNumber");
    }

    public int getPlayedPlyCount() {
        return (this.getNextMoveNumber() - 1) * 2 + (this.getCurrentPlayer().equals("B") ? 1 : 0);
    }

    public String getMoveVerbose() {
        return this.getStringProperty("MoveVerbose");
    }

    public String getMoveSAN() {
        return this.getStringProperty("MoveSAN");
    }

    public int getMoveTime() {
        return this.getIntegerProperty("MoveTime");
    }

    public boolean isBoardFlipped() {
        return this.getBooleanProperty("IsBoardFlipped");
    }

    public boolean isClockRunning() {
        return this.getBooleanProperty("IsClockRunning");
    }

    public int getLag() {
        return this.getIntegerProperty("Lag");
    }
}

