/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.pageview;

import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.Consumed;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.examples.pageview.JsonPOJODeserializer;
import org.apache.kafka.streams.examples.pageview.JsonPOJOSerializer;
import org.apache.kafka.streams.examples.pageview.JsonTimestampExtractor;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Serialized;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;

public class PageViewTypedDemo {
    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.put("application.id", "streams-pageview-typed");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("default.timestamp.extractor", JsonTimestampExtractor.class);
        props.put("cache.max.bytes.buffering", (Object)0);
        props.put("auto.offset.reset", "earliest");
        StreamsBuilder builder = new StreamsBuilder();
        HashMap<String, Class<PageViewByRegion>> serdeProps = new HashMap<String, Class<PageViewByRegion>>();
        JsonPOJOSerializer pageViewSerializer = new JsonPOJOSerializer();
        serdeProps.put("JsonPOJOClass", PageView.class);
        pageViewSerializer.configure(serdeProps, false);
        JsonPOJODeserializer pageViewDeserializer = new JsonPOJODeserializer();
        serdeProps.put("JsonPOJOClass", PageView.class);
        pageViewDeserializer.configure(serdeProps, false);
        Serde pageViewSerde = Serdes.serdeFrom(pageViewSerializer, pageViewDeserializer);
        JsonPOJOSerializer userProfileSerializer = new JsonPOJOSerializer();
        serdeProps.put("JsonPOJOClass", UserProfile.class);
        userProfileSerializer.configure(serdeProps, false);
        JsonPOJODeserializer userProfileDeserializer = new JsonPOJODeserializer();
        serdeProps.put("JsonPOJOClass", UserProfile.class);
        userProfileDeserializer.configure(serdeProps, false);
        Serde userProfileSerde = Serdes.serdeFrom(userProfileSerializer, userProfileDeserializer);
        JsonPOJOSerializer wPageViewByRegionSerializer = new JsonPOJOSerializer();
        serdeProps.put("JsonPOJOClass", WindowedPageViewByRegion.class);
        wPageViewByRegionSerializer.configure(serdeProps, false);
        JsonPOJODeserializer wPageViewByRegionDeserializer = new JsonPOJODeserializer();
        serdeProps.put("JsonPOJOClass", WindowedPageViewByRegion.class);
        wPageViewByRegionDeserializer.configure(serdeProps, false);
        Serde wPageViewByRegionSerde = Serdes.serdeFrom(wPageViewByRegionSerializer, wPageViewByRegionDeserializer);
        JsonPOJOSerializer regionCountSerializer = new JsonPOJOSerializer();
        serdeProps.put("JsonPOJOClass", RegionCount.class);
        regionCountSerializer.configure(serdeProps, false);
        JsonPOJODeserializer regionCountDeserializer = new JsonPOJODeserializer();
        serdeProps.put("JsonPOJOClass", RegionCount.class);
        regionCountDeserializer.configure(serdeProps, false);
        Serde regionCountSerde = Serdes.serdeFrom(regionCountSerializer, regionCountDeserializer);
        JsonPOJOSerializer pageViewByRegionSerializer = new JsonPOJOSerializer();
        serdeProps.put("JsonPOJOClass", PageViewByRegion.class);
        pageViewByRegionSerializer.configure(serdeProps, false);
        JsonPOJODeserializer pageViewByRegionDeserializer = new JsonPOJODeserializer();
        serdeProps.put("JsonPOJOClass", PageViewByRegion.class);
        pageViewByRegionDeserializer.configure(serdeProps, false);
        Serde pageViewByRegionSerde = Serdes.serdeFrom(pageViewByRegionSerializer, pageViewByRegionDeserializer);
        KStream views = builder.stream("streams-pageview-input", Consumed.with((Serde)Serdes.String(), (Serde)pageViewSerde));
        KTable users = builder.table("streams-userprofile-input", Consumed.with((Serde)Serdes.String(), (Serde)userProfileSerde));
        KStream regionCount = views.leftJoin(users, (ValueJoiner)new ValueJoiner<PageView, UserProfile, PageViewByRegion>(){

            public PageViewByRegion apply(PageView view, UserProfile profile) {
                PageViewByRegion viewByRegion = new PageViewByRegion();
                viewByRegion.user = view.user;
                viewByRegion.page = view.page;
                viewByRegion.region = profile != null ? profile.region : "UNKNOWN";
                return viewByRegion;
            }
        }).map((KeyValueMapper)new KeyValueMapper<String, PageViewByRegion, KeyValue<String, PageViewByRegion>>(){

            public KeyValue<String, PageViewByRegion> apply(String user, PageViewByRegion viewRegion) {
                return new KeyValue((Object)viewRegion.region, (Object)viewRegion);
            }
        }).groupByKey(Serialized.with((Serde)Serdes.String(), (Serde)pageViewByRegionSerde)).windowedBy((Windows)TimeWindows.of((long)TimeUnit.DAYS.toMillis(7L)).advanceBy(TimeUnit.SECONDS.toMillis(1L))).count().toStream().map((KeyValueMapper)new KeyValueMapper<Windowed<String>, Long, KeyValue<WindowedPageViewByRegion, RegionCount>>(){

            public KeyValue<WindowedPageViewByRegion, RegionCount> apply(Windowed<String> key, Long value) {
                WindowedPageViewByRegion wViewByRegion = new WindowedPageViewByRegion();
                wViewByRegion.windowStart = key.window().start();
                wViewByRegion.region = (String)key.key();
                RegionCount rCount = new RegionCount();
                rCount.region = (String)key.key();
                rCount.count = value;
                return new KeyValue((Object)wViewByRegion, (Object)rCount);
            }
        });
        regionCount.to("streams-pageviewstats-typed-output", Produced.with((Serde)wPageViewByRegionSerde, (Serde)regionCountSerde));
        KafkaStreams streams = new KafkaStreams(builder.build(), props);
        streams.start();
        Thread.sleep(5000L);
        streams.close();
    }

    public static class RegionCount {
        public long count;
        public String region;
    }

    public static class WindowedPageViewByRegion {
        public long windowStart;
        public String region;
    }

    public static class PageViewByRegion {
        public String user;
        public String page;
        public String region;
    }

    public static class UserProfile {
        public String region;
        public Long timestamp;
    }

    public static class PageView {
        public String user;
        public String page;
        public Long timestamp;
    }
}

