/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.examples.temperature;

import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.TimeWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.WindowedDeserializer;
import org.apache.kafka.streams.kstream.internals.WindowedSerializer;

public class TemperatureDemo {
    private static final int TEMPERATURE_THRESHOLD = 20;
    private static final int TEMPERATURE_WINDOW_SIZE = 5;

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.put("application.id", "streams-temperature");
        props.put("bootstrap.servers", "localhost:9092");
        props.put("default.key.serde", Serdes.String().getClass());
        props.put("default.value.serde", Serdes.String().getClass());
        props.put("auto.offset.reset", "earliest");
        props.put("cache.max.bytes.buffering", (Object)0);
        StreamsBuilder builder = new StreamsBuilder();
        KStream source = builder.stream("iot-temperature");
        KStream max = source.selectKey((KeyValueMapper)new KeyValueMapper<String, String, String>(){

            public String apply(String key, String value) {
                return "temp";
            }
        }).groupByKey().windowedBy((Windows)TimeWindows.of((long)TimeUnit.SECONDS.toMillis(5L))).reduce((Reducer)new Reducer<String>(){

            public String apply(String value1, String value2) {
                if (Integer.parseInt(value1) > Integer.parseInt(value2)) {
                    return value1;
                }
                return value2;
            }
        }).toStream().filter((Predicate)new Predicate<Windowed<String>, String>(){

            public boolean test(Windowed<String> key, String value) {
                return Integer.parseInt(value) > 20;
            }
        });
        WindowedSerializer windowedSerializer = new WindowedSerializer(Serdes.String().serializer());
        WindowedDeserializer windowedDeserializer = new WindowedDeserializer(Serdes.String().deserializer(), 5L);
        Serde windowedSerde = Serdes.serdeFrom((Serializer)windowedSerializer, (Deserializer)windowedDeserializer);
        max.to("iot-temperature-max", Produced.with((Serde)windowedSerde, (Serde)Serdes.String()));
        final KafkaStreams streams = new KafkaStreams(builder.build(), props);
        final CountDownLatch latch = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread("streams-temperature-shutdown-hook"){

            @Override
            public void run() {
                streams.close();
                latch.countDown();
            }
        });
        try {
            streams.start();
            latch.await();
        }
        catch (Throwable e) {
            System.exit(1);
        }
        System.exit(0);
    }
}

