/* -*- mode: c ; c-file-style: "canonware-c-style" -*-
 ****************************************************************************
 *
 * Copyright (C) 1996-1999 Jason Evans <jasone@canonware.com>.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice(s), this list of conditions and the following disclaimer as
 *    the first lines of this file unmodified other than the possible
 *    addition of one or more copyright notices.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice(s), this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************
 *
 * Version: s19990912a
 *
 * <<< Description >>>
 *
 * Dynamic debug spew class.  The idea is to be able to turn various types
 * of debug spew on and off on the fly, without recompilation, without even
 * restarting the program.
 *
 ****************************************************************************/

typedef struct cw_dbg_s cw_dbg_t;

struct cw_dbg_s
{
  cw_oh_t flag_hash;
};

/****************************************************************************
 *
 * <<< Input(s) >>>
 *
 * None.
 *
 * <<< Output(s) >>>
 *
 * retval : Pointer to a dbg, or NULL.
 *          NULL : Memory allocation error.
 *
 * <<< Description >>>
 *
 * Constructor.
 *
 ****************************************************************************/
cw_dbg_t *
dbg_new(void);

/****************************************************************************
 *
 * <<< Input(s) >>>
 *
 * a_dbg : Pointer to a dbg.
 *
 * <<< Output(s) >>>
 *
 * None.
 *
 * <<< Description >>>
 *
 * Destructor.
 *
 ****************************************************************************/
void
dbg_delete(cw_dbg_t * a_dbg);

/****************************************************************************
 *
 * <<< Input(s) >>>
 *
 * a_dbg : Pointer to a dbg.
 *
 * a_flag : Pointer to a string that represents a debugging flag.
 *
 * <<< Output(s) >>>
 *
 * retval : FALSE == success, TRUE == error.
 *          TRUE : Memory allocation error.
 *               : a_dbg is NULL.
 *
 * <<< Description >>>
 *
 * Register a debug flag string (turn it on).
 *
 ****************************************************************************/
cw_bool_t
dbg_register(cw_dbg_t * a_dbg, const char * a_flag);

/****************************************************************************
 *
 * <<< Input(s) >>>
 *
 * a_dbg : Pointer to a dbg.
 *
 * a_flag : Pointer to a string that represents a debugging flag.
 *
 * <<< Output(s) >>>
 *
 * None.
 *
 * <<< Description >>>
 *
 * Unregister a flag (turn it off) if it is registered.
 *
 ****************************************************************************/
void
dbg_unregister(cw_dbg_t * a_dbg, const char * a_flag);

/****************************************************************************
 *
 * <<< Input(s) >>>
 *
 * a_dbg : Pointer to a dbg.
 *
 * a_flag : Pointer to a string that represents a debugging flag.
 *
 * <<< Output(s) >>>
 *
 * retval : FALSE == not registered, TRUE == registered.
 *
 * <<< Description >>>
 *
 * Return TRUE if a_flag is registered, FALSE, otherwise.
 *
 ****************************************************************************/
cw_bool_t
dbg_is_registered(cw_dbg_t * a_dbg, const char * a_flag);
