/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.ui.GithubDataLoadingComponent;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\u00020\u0004:\u0001\u001bB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0016\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\b\u0010\u0017\u001a\u00020\u0011H\u0014J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubDataLoadingComponent;", "", "Lcom/intellij/openapi/vcs/changes/Change;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "changesBrowser", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent$Companion$PullRequestChangesBrowserWithError;", "diffAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getDiffAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "dispose", "", "handleError", "error", "", "handleResult", "result", "reset", "setBusy", "busy", "", "Companion", "intellij.vcs.github"})
public final class GithubPullRequestChangesComponent
extends GithubDataLoadingComponent<List<? extends Change>>
implements Disposable {
    private final Companion.PullRequestChangesBrowserWithError changesBrowser;
    private final JBLoadingPanel loadingPanel;
    @NotNull
    private final AnAction diffAction;
    private static final String DEFAULT_EMPTY_TEXT = "Select pull request to view list of changed files";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final AnAction getDiffAction() {
        return this.diffAction;
    }

    @Override
    protected void reset() {
        this.changesBrowser.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        this.changesBrowser.setChanges(CollectionsKt.emptyList());
    }

    @Override
    protected void handleResult(@NotNull List<? extends Change> result) {
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        this.changesBrowser.getEmptyText().setText("Pull request does not contain any changes");
        this.changesBrowser.setChanges(result);
    }

    @Override
    protected void handleError(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        StatusText statusText = this.changesBrowser.getEmptyText().clear().appendText("Cannot load changes", SimpleTextAttributes.ERROR_ATTRIBUTES);
        String string = error.getMessage();
        if (string == null) {
            string = "Unknown error";
        }
        statusText.appendSecondaryText(string, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
    }

    @Override
    protected void setBusy(boolean busy) {
        if (busy) {
            this.changesBrowser.getEmptyText().clear();
            this.loadingPanel.startLoading();
        } else {
            this.loadingPanel.stopLoading();
        }
    }

    public void dispose() {
    }

    public GithubPullRequestChangesComponent(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.changesBrowser = new Companion.PullRequestChangesBrowserWithError(project);
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        AnAction anAction = this.changesBrowser.getDiffAction();
        Intrinsics.checkExpressionValueIsNotNull((Object)anAction, (String)"changesBrowser.diffAction");
        this.diffAction = anAction;
        this.loadingPanel.add((Component)((Object)this.changesBrowser), (Object)"Center");
        this.changesBrowser.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        this.setContent((JComponent)this.loadingPanel);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent$Companion;", "", "()V", "DEFAULT_EMPTY_TEXT", "", "PullRequestChangesBrowserWithError", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014R7\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestChangesComponent$Companion$PullRequestChangesBrowserWithError;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserBase;", "Lcom/intellij/util/ui/ComponentWithEmptyText;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "", "Lcom/intellij/openapi/vcs/changes/Change;", "changes", "getChanges", "()Ljava/util/List;", "setChanges", "(Ljava/util/List;)V", "changes$delegate", "Lkotlin/properties/ReadWriteProperty;", "buildTreeModel", "Ljavax/swing/tree/DefaultTreeModel;", "createViewerBorder", "Ljavax/swing/border/Border;", "getEmptyText", "Lcom/intellij/util/ui/StatusText;", "onDoubleClick", "", "intellij.vcs.github"})
        private static final class PullRequestChangesBrowserWithError
        extends ChangesBrowserBase
        implements ComponentWithEmptyText {
            static final /* synthetic */ KProperty[] $$delegatedProperties;
            @NotNull
            private final ReadWriteProperty changes$delegate;

            static {
                $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PullRequestChangesBrowserWithError.class), "changes", "getChanges()Ljava/util/List;"))};
            }

            @NotNull
            public final List<Change> getChanges() {
                return (List)this.changes$delegate.getValue((Object)this, $$delegatedProperties[0]);
            }

            public final void setChanges(@NotNull List<? extends Change> list2) {
                Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
                this.changes$delegate.setValue((Object)this, $$delegatedProperties[0], list2);
            }

            @NotNull
            protected DefaultTreeModel buildTreeModel() {
                DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChanges((Project)this.myProject, (ChangesGroupingPolicyFactory)this.getGrouping(), (Collection)this.getChanges(), null);
                Intrinsics.checkExpressionValueIsNotNull((Object)defaultTreeModel, (String)"TreeModelBuilder.buildFr\u2026 grouping, changes, null)");
                return defaultTreeModel;
            }

            protected void onDoubleClick() {
                if (this.canShowDiff()) {
                    super.onDoubleClick();
                }
            }

            @NotNull
            public StatusText getEmptyText() {
                ChangesTree changesTree = this.myViewer;
                Intrinsics.checkExpressionValueIsNotNull((Object)changesTree, (String)"myViewer");
                StatusText statusText = changesTree.getEmptyText();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"myViewer.emptyText");
                return statusText;
            }

            @NotNull
            protected Border createViewerBorder() {
                Border border = IdeBorderFactory.createBorder((int)2);
                Intrinsics.checkExpressionValueIsNotNull((Object)border, (String)"IdeBorderFactory.createBorder(SideBorder.TOP)");
                return border;
            }

            /*
             * WARNING - void declaration
             */
            public PullRequestChangesBrowserWithError(@NotNull Project project) {
                void initialValue$iv;
                List list2;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                super(project, false, false);
                Delegates delegates = Delegates.INSTANCE;
                PullRequestChangesBrowserWithError pullRequestChangesBrowserWithError = this;
                List list3 = list2 = CollectionsKt.emptyList();
                list2 = (ReadWriteProperty)new ObservableProperty<List<? extends Change>>((Object)initialValue$iv, (Object)initialValue$iv, this){
                    final /* synthetic */ Object $initialValue;
                    final /* synthetic */ PullRequestChangesBrowserWithError this$0;
                    {
                        this.$initialValue = $captured_local_variable$1;
                        this.this$0 = pullRequestChangesBrowserWithError;
                        super($super_call_param$2);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                        List list2 = (List)newValue;
                        List list3 = (List)oldValue;
                        KProperty $noName_0 = property;
                        PullRequestChangesBrowserWithError.access$getMyViewer$p(this.this$0).rebuildTree();
                    }
                };
                pullRequestChangesBrowserWithError.changes$delegate = list2;
                this.init();
            }

            public static final /* synthetic */ ChangesTree access$getMyViewer$p(PullRequestChangesBrowserWithError $this) {
                return $this.myViewer;
            }
        }
    }
}

