/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.remote;

import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsRemoteInterpreterType
extends NodeJsInterpreterType<NodeJsRemoteInterpreter> {
    private static final NodeJsRemoteInterpreterType INSTANCE = new NodeJsRemoteInterpreterType();
    private final NodeJSRemoteInterpreterManager myRemoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstance();

    @NotNull
    public static NodeJsRemoteInterpreterType getInstance() {
        NodeJsRemoteInterpreterType nodeJsRemoteInterpreterType = INSTANCE;
        if (nodeJsRemoteInterpreterType == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(0);
        }
        return nodeJsRemoteInterpreterType;
    }

    @Override
    @NotNull
    public String getName() {
        if ("remote" == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(1);
        }
        return "remote";
    }

    @Override
    public boolean isAvailable() {
        return this.myRemoteInterpreterManager != null;
    }

    public boolean isRemoteReference(@NotNull NodeJsInterpreterRef ref) {
        if (ref == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(2);
        }
        return NodeJsRemoteInterpreterType.isRemoteReferenceName(ref.getReferenceName());
    }

    private static boolean isRemoteReferenceName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(3);
        }
        return referenceName.startsWith("vagrant://") || referenceName.startsWith("sftp://") || referenceName.startsWith("docker://") || referenceName.startsWith("ssh://");
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter findByReferenceName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(4);
        }
        return NodeJsRemoteInterpreterType.isRemoteReferenceName(referenceName) ? new NodeJsRemoteInterpreter(referenceName) : null;
    }

    @Override
    @NotNull
    public List<NodeJsRemoteInterpreter> getInterpreters() {
        if (this.myRemoteInterpreterManager != null) {
            List list = ContainerUtil.map(this.myRemoteInterpreterManager.getRemoteInterpreters(), (Function)((NotNullFunction)NodeJsRemoteInterpreter::new));
            if (list == null) {
                NodeJsRemoteInterpreterType.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<NodeJsRemoteInterpreter> list = Collections.emptyList();
        if (list == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter showAddDialog(@NotNull Project project) {
        String id;
        if (project == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(7);
        }
        if (this.myRemoteInterpreterManager != null && (id = this.myRemoteInterpreterManager.createRemoteInterpreter(project)) != null) {
            return new NodeJsRemoteInterpreter(id);
        }
        return null;
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter edit(@NotNull Project project, @NotNull NodeJsRemoteInterpreter interpreter) {
        String createdId;
        if (project == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(8);
        }
        if (interpreter == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(9);
        }
        if (this.myRemoteInterpreterManager != null && (createdId = this.myRemoteInterpreterManager.editRemoteInterpreter(project, interpreter.getRemoteUrl())) != null) {
            return new NodeJsRemoteInterpreter(createdId);
        }
        return null;
    }

    @Override
    public void setInterpreters(@NotNull List<NodeJsRemoteInterpreter> interpreters) {
        if (interpreters == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(10);
        }
        if (this.myRemoteInterpreterManager != null) {
            HashSet toDelete = ContainerUtil.newHashSet(this.myRemoteInterpreterManager.getRemoteInterpreters());
            for (NodeJsRemoteInterpreter interpreter : interpreters) {
                toDelete.remove(interpreter.getRemoteUrl());
            }
            for (String url : toDelete) {
                this.myRemoteInterpreterManager.deleteRemoteInterpreter(url);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteReferenceName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findByReferenceName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showAddDialog";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

