/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.ui;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorTextField;
import java.awt.Dimension;
import org.jetbrains.annotations.Nullable;

public class JSEditorTextField
extends EditorTextField {
    private final boolean myBorder;
    @Nullable
    private final Computable<Integer> myHeightProvider;

    public JSEditorTextField(Project project, Document document) {
        this(project, document, true, null);
    }

    public JSEditorTextField(Project project, Document document, boolean border, @Nullable Computable<Integer> heightProvider) {
        super(document, project, (FileType)JavaScriptSupportLoader.JAVASCRIPT);
        this.myBorder = border;
        this.myHeightProvider = heightProvider;
    }

    protected EditorEx createEditor() {
        EditorEx editor = super.createEditor();
        editor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(this.getProject(), this.getFileName()));
        return editor;
    }

    protected String getFileName() {
        return PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(this.getDocument()).getName();
    }

    protected boolean shouldHaveBorder() {
        return this.myBorder;
    }

    public Dimension getPreferredSize() {
        Dimension result2 = new Dimension(super.getPreferredSize());
        if (this.myHeightProvider != null) {
            result2.height = (Integer)this.myHeightProvider.compute();
        }
        return result2;
    }
}

