/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpType {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.PhpType");
    public static final String PHPSTORM_HELPERS = "___PHPSTORM_HELPERS";
    public static final String _PHPSTORM_HELPERS_FQN = "\\___PHPSTORM_HELPERS";
    public static final String _OBJECT_FQN = "\\___PHPSTORM_HELPERS\\object";
    public static final String _PHPSTORM_HELPERS_STATIC = "\\___PHPSTORM_HELPERS\\static";
    public static final String _PHPSTORM_HELPERS_$THIS = "\\___PHPSTORM_HELPERS\\this";
    public static final String _OBJECT = "\\object";
    public static final String _MIXED = "\\mixed";
    public static final String _VOID = "\\void";
    public static final String _NULL = "\\null";
    public static final String _ARRAY = "\\array";
    public static final String _ITERABLE = "\\iterable";
    public static final String _INT = "\\int";
    public static final String _INTEGER = "\\integer";
    public static final String _BOOL = "\\bool";
    public static final String _BOOLEAN = "\\boolean";
    public static final String _TRUE = "\\true";
    public static final String _FALSE = "\\false";
    public static final String _STRING = "\\string";
    public static final String _FLOAT = "\\float";
    public static final String _DOUBLE = "\\double";
    public static final String _CLOSURE = "\\Closure";
    @Deprecated
    public static final String _CALLBACK = "\\callback";
    public static final String _CALLABLE = "\\callable";
    public static final String _NUMBER = "\\number";
    public static final String _RESOURCE = "\\resource";
    public static final String _EXCEPTION = "\\Exception";
    public static final String _THROWABLE = "\\Throwable";
    public static final PhpType EMPTY = PhpType.builder().build();
    public static final PhpType MIXED = PhpType.builder().add("\\mixed").build();
    public static final PhpType NULL = PhpType.builder().add("\\null").build();
    public static final PhpType STRING = PhpType.builder().add("\\string").build();
    public static final PhpType BOOLEAN = PhpType.builder().add("\\bool").build();
    public static final PhpType INT = PhpType.builder().add("\\int").build();
    public static final PhpType FLOAT = PhpType.builder().add("\\float").build();
    public static final PhpType OBJECT = PhpType.builder().add("\\object").build();
    public static final PhpType CLOSURE = PhpType.builder().add("\\Closure").build();
    public static final PhpType CALLABLE = PhpType.builder().add("\\callable").build();
    public static final PhpType RESOURCE = PhpType.builder().add("\\resource").build();
    public static final PhpType ARRAY = PhpType.builder().add("\\array").build();
    public static final PhpType ITERABLE = PhpType.builder().add("\\iterable").build();
    public static final PhpType NUMBER = PhpType.builder().add("\\number").build();
    public static final PhpType VOID = PhpType.builder().add("\\void").build();
    public static final PhpType NUMERIC = PhpType.builder().add(STRING).add(INT).build();
    public static final PhpType SCALAR = PhpType.builder().add(INT).add(FLOAT).add(STRING).add(BOOLEAN).build();
    public static final PhpType FLOAT_INT = PhpType.builder().add(FLOAT).add(INT).build();
    public static final PhpType UNSET = PhpType.builder().add("unset").build();
    public static final PhpType STATIC = PhpType.builder().add("static").build();
    public static final PhpType EXCEPTION = PhpType.builder().add("\\Exception").build();
    public static final PhpType THROWABLE = PhpType.builder().add("\\Throwable").build();
    public static final PhpType $THIS = PhpType.builder().add("$this").build();
    @Nullable
    Set<String> types;
    private boolean isComplete = true;
    private boolean dirty = false;
    String myStringResolved;
    String myString;

    @NotNull
    public static PhpTypeBuilder builder() {
        PhpTypeBuilder phpTypeBuilder = new PhpTypeBuilder();
        if (phpTypeBuilder == null) {
            PhpType.$$$reportNull$$$0(0);
        }
        return phpTypeBuilder;
    }

    @NotNull
    public PhpType add(@Nullable String aClass) {
        if (aClass != null && aClass.length() > 0) {
            if (aClass.charAt(0) == '#') {
                this.isComplete = false;
            }
            if (PhpType.isPrimitiveType(aClass) && !aClass.startsWith("\\")) {
                aClass = "\\" + aClass;
            }
            if (aClass.equalsIgnoreCase(_INTEGER)) {
                aClass = _INT;
            } else if (aClass.equals(_STRING)) {
                aClass = _STRING;
            } else if (aClass.equalsIgnoreCase(_ARRAY)) {
                aClass = _ARRAY;
            } else if (aClass.equalsIgnoreCase(_BOOL)) {
                aClass = _BOOL;
            } else if (aClass.equalsIgnoreCase(_MIXED)) {
                aClass = _MIXED;
            } else if (aClass.equalsIgnoreCase(_BOOLEAN)) {
                aClass = _BOOL;
            } else if (aClass.equalsIgnoreCase(_CALLBACK)) {
                aClass = _CALLABLE;
            } else if (aClass.equalsIgnoreCase(_ITERABLE)) {
                aClass = _ITERABLE;
            } else if (aClass.equalsIgnoreCase(_DOUBLE)) {
                aClass = _FLOAT;
            }
            if (this.types == null) {
                this.types = new SmartHashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            }
            if (this.types.size() > 50 && ApplicationManager.getApplication().isInternal()) {
                LOG.warn("too much type variants: " + this.types);
            } else {
                this.types.add(aClass);
            }
            this.dirty = true;
        }
        PhpType phpType = this;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    @NotNull
    public PhpType add(@Nullable PsiElement other) {
        if (other instanceof PhpTypedElement) {
            PhpType type = ((PhpTypedElement)other).getType();
            this.add(type);
        }
        PhpType phpType = this;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    @NotNull
    public PhpType add(PhpType type) {
        if (type != null && type.types != null && type.types.size() > 0) {
            try {
                this.isComplete &= type.isComplete;
                if (this.types == null) {
                    this.types = type.types.size() < 2 ? new SmartHashSet(type.types, (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE) : new THashSet(type.types, (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                } else {
                    this.types.addAll(type.types);
                    if (this.types.size() > 50 && ApplicationManager.getApplication().isInternal()) {
                        LOG.warn("too much type variants: " + this.types);
                    }
                }
                this.dirty = true;
            }
            catch (NoSuchElementException e) {
                throw new RuntimeException("NSEE @" + type.types, e);
            }
        }
        PhpType phpType = this;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    public int size() {
        return this.types != null ? this.types.size() : 0;
    }

    public boolean isUndefined() {
        if (this.types == null) {
            return true;
        }
        if (this.types.size() == 0) {
            return true;
        }
        return this.types.size() == 1 && (this.types.contains(_MIXED) || this.types.contains(_OBJECT_FQN));
    }

    @NotNull
    public Set<String> getTypes() {
        if (this.types != null) {
            Set<String> set = this.types;
            if (set == null) {
                PhpType.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            PhpType.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Set<String> getTypesSorted() {
        if (this.types != null) {
            this.sortIfNeeded();
            assert (this.types != null);
            Set<String> set = this.types;
            if (set == null) {
                PhpType.$$$reportNull$$$0(6);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            PhpType.$$$reportNull$$$0(7);
        }
        return set;
    }

    public String toString() {
        if (this.types == null) {
            return "";
        }
        if (!this.dirty && this.myString != null) {
            return this.myString;
        }
        StringBuilder builder = new StringBuilder();
        for (String type : this.getTypesSorted()) {
            if (type.startsWith("?")) continue;
            type = PhpType.toString(type);
            builder.append(type).append('|');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        if (!this.isComplete) {
            builder.append("|?");
        }
        this.myString = builder.toString();
        return this.myString;
    }

    public static String toString(String type) {
        return PhpType.isPrimitiveType(StringUtil.trimEnd((String)type, (String)"[]")) && type.startsWith("\\") ? type.substring(1) : type;
    }

    private void sortIfNeeded() {
        if (this.types != null && !(this.types instanceof SortedSet)) {
            TreeSet<String> sorted = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            sorted.addAll(this.types);
            this.types = sorted;
        }
    }

    public String toStringResolved() {
        if (!this.dirty && this.myStringResolved != null) {
            return this.myStringResolved;
        }
        this.myStringResolved = this.toStringRelativized(null);
        return this.myStringResolved;
    }

    public String toStringRelativized(@Nullable String currentNamespaceName) {
        if (this.types == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String type : this.getTypesSorted()) {
            if (type.startsWith("?")) continue;
            type = PhpType.toString(type);
            if (currentNamespaceName != null && type.startsWith(currentNamespaceName)) {
                type = type.substring(currentNamespaceName.length());
            }
            builder.append(type).append('|');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        if (!this.isComplete) {
            builder.append("|?");
        }
        return builder.toString();
    }

    public boolean isConvertibleFrom(@NotNull PhpType otherType, @NotNull PhpIndex index) {
        if (otherType == null) {
            PhpType.$$$reportNull$$$0(8);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(9);
        }
        if (this.isUndefined() || otherType.isUndefined()) {
            return true;
        }
        if (this.equals(NULL)) {
            return true;
        }
        Set<String> otherTypes = otherType.types;
        if (otherTypes == null) {
            return this.types == null;
        }
        for (String other : otherTypes) {
            if (this.types == null) continue;
            for (String my : this.types) {
                if (my.equalsIgnoreCase(other) || other.equalsIgnoreCase(_MIXED) || my.equalsIgnoreCase(_MIXED) || my.startsWith("?") || other.startsWith("?") || PhpType.isPluralType(my) && other.equalsIgnoreCase(_ARRAY) || PhpType.isPluralType(other) && (my.equalsIgnoreCase(_ARRAY) || my.equalsIgnoreCase(_ITERABLE)) || my.equalsIgnoreCase(_STRING) && !other.equalsIgnoreCase(_ARRAY) || other.equalsIgnoreCase(_STRING) && my.equalsIgnoreCase(_CALLABLE) || other.equalsIgnoreCase(_ARRAY) && my.equalsIgnoreCase(_CALLABLE) || other.equalsIgnoreCase(_STRING) && my.equalsIgnoreCase(_INT) || other.equalsIgnoreCase(_STRING) && my.equalsIgnoreCase(_FLOAT) || other.equalsIgnoreCase(_STRING) && my.equalsIgnoreCase(_BOOL) || my.equalsIgnoreCase(_ITERABLE) && other.equalsIgnoreCase(_ARRAY) || PhpType.isBidi(my, other, _TRUE, _BOOL) || PhpType.isBidi(my, other, _FALSE, _BOOL) || PhpType.isBidi(my, other, _INT, _FLOAT) || PhpType.isBidi(my, other, _BOOL, _INT) || PhpType.isBidi(my, other, _BOOL, _FLOAT) || PhpType.isBidi(my, other, _NUMBER, _FLOAT) || PhpType.isBidi(my, other, _NUMBER, _INT) || PhpType.isBidi(my, other, _OBJECT, "\\stdClass")) {
                    return true;
                }
                if (!my.equalsIgnoreCase(_CALLABLE) && !other.equalsIgnoreCase(_CALLABLE) && PhpType.isPrimitiveType(my) && PhpType.isPrimitiveType(other)) continue;
                if (PhpType.findSuper(my, other, index)) {
                    return true;
                }
                if (!PhpType.isPrimitiveType(other) && _OBJECT.equalsIgnoreCase(my)) {
                    return true;
                }
                if ((!my.equalsIgnoreCase(_CALLABLE) || !PhpType.checkInvoke(other, index)) && (!other.equalsIgnoreCase(_CALLABLE) || !PhpType.checkInvoke(my, index))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isBidi(String my, String other, String type1, String type2) {
        return my.equalsIgnoreCase(type1) && other.equalsIgnoreCase(type2) || other.equalsIgnoreCase(type1) && my.equalsIgnoreCase(type2);
    }

    @NotNull
    public PhpType filterUnknown() {
        PhpType phpType = this.filterOut(s -> s.startsWith("#") || s.startsWith("?"));
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterPrimitives() {
        PhpType phpType = this.filterOut(PhpType::isPrimitiveType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(11);
        }
        return phpType;
    }

    public boolean hasUnknown() {
        if (this.types == null) {
            return false;
        }
        for (String type : this.types) {
            if (!StringUtil.startsWith((CharSequence)type, (CharSequence)"?")) continue;
            return true;
        }
        return false;
    }

    public static boolean checkInvoke(@NotNull String some, @NotNull PhpIndex index) {
        if (some == null) {
            PhpType.$$$reportNull$$$0(12);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(13);
        }
        Collection<PhpClass> candidates = index.getAnyByFQN(some);
        for (PhpClass candidate : candidates) {
            if (candidate.findMethodByName("__invoke") == null) continue;
            return true;
        }
        return false;
    }

    public static boolean findSuper(@NotNull String my, @Nullable String other, @NotNull PhpIndex index) {
        if (my == null) {
            PhpType.$$$reportNull$$$0(14);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(15);
        }
        if (other == null) {
            return false;
        }
        if (my.endsWith("[]") != other.endsWith("[]")) {
            return false;
        }
        my = StringUtil.trimEnd((String)my, (String)"[]");
        other = StringUtil.trimEnd((String)other, (String)"[]");
        if (!my.startsWith("\\")) {
            my = "\\" + my;
        }
        if (!other.startsWith("\\")) {
            other = "\\" + other;
        }
        if (my.equalsIgnoreCase(other)) {
            return true;
        }
        Collection<PhpClass> mes = index.getAnyByFQN(my);
        Ref result = new Ref((Object)false);
        return index.getAnyByFQN(other).stream().anyMatch(phpClass -> {
            PhpClassHierarchyUtils.processSupers(phpClass, true, true, (Processor<? super PhpClass>)((Processor)aSuper -> {
                for (PhpClass me : mes) {
                    if (!PhpClassHierarchyUtils.classesEqual(me, aSuper)) continue;
                    result.set((Object)true);
                    break;
                }
                return (Boolean)result.get() == false;
            }));
            return (Boolean)result.get();
        });
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public PhpType globalLocationAware(@NotNull PsiElement context) {
        if (context == null) {
            PhpType.$$$reportNull$$$0(16);
        }
        try {
            return PhpIndex.getInstance(context.getProject()).completeThis(this, PhpType.get$ThisClassFQN(context), (Set<String>)new THashSet());
        }
        catch (StackOverflowError e) {
            throw new RuntimeException("SOE in PhpType.globalLocationAware at " + context.getParent().getText() + " in " + context.getContainingFile().getName() + " type=" + this.toString(), e);
        }
    }

    @Nullable
    private static String get$ThisClassFQN(@Nullable PsiElement context) {
        String result = null;
        if (context instanceof PhpClassMember) {
            PhpClass aClass = ((PhpClassMember)context).getContainingClass();
            if (aClass != null) {
                result = aClass.getFQN();
            }
        } else {
            PhpClass aClass = (PhpClass)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)context, PhpClass.class);
            if (aClass != null) {
                result = aClass.getFQN();
            }
        }
        return result;
    }

    public PhpType global(@NotNull Project p) {
        if (p == null) {
            PhpType.$$$reportNull$$$0(17);
        }
        return PhpIndex.getInstance(p).completeType(p, this, (Set<String>)new THashSet());
    }

    public boolean isEmpty() {
        return this.types == null || this.types.isEmpty();
    }

    @NotNull
    public PhpType elementType() {
        PhpType elementType = new PhpType();
        if (this.types != null) {
            for (String type : this.types) {
                if (type.charAt(0) == '#') {
                    if (PhpType.isPluralType(type)) {
                        elementType.add(type.substring(0, type.length() - 2));
                        continue;
                    }
                    elementType.add(PhpTypeSignatureKey.ARRAY_ELEMENT.sign(type));
                    continue;
                }
                if (type.equalsIgnoreCase(_ARRAY)) {
                    elementType.add(MIXED);
                    continue;
                }
                int i = type.lastIndexOf("[");
                if (i > 0) {
                    elementType.add(type.substring(0, i));
                    continue;
                }
                if (PhpType.isPrimitiveType(type)) continue;
                elementType.add(PhpTypeSignatureKey.ARRAY_ELEMENT.sign(PhpTypeSignatureKey.CLASS.sign(type)));
            }
        }
        PhpType phpType = elementType;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(18);
        }
        return phpType;
    }

    @NotNull
    public PhpType pluralise() {
        PhpType elementType = new PhpType();
        if (this.types != null) {
            for (String type : this.types) {
                elementType.add(type + "[]");
            }
        }
        PhpType phpType = elementType;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(19);
        }
        return phpType;
    }

    @NotNull
    public PhpType unpluralize() {
        if (ContainerUtil.isEmpty(this.types)) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(20);
            }
            return phpType;
        }
        PhpType unpluralized = new PhpType();
        for (String type : this.types) {
            unpluralized.add(_ARRAY.equalsIgnoreCase(type) ? _MIXED : StringUtil.trimEnd((String)type, (String)"[]"));
        }
        PhpType phpType = unpluralized;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(21);
        }
        return phpType;
    }

    public static boolean isPrimitiveType(@Nullable String type) {
        if (type == null) {
            return true;
        }
        if (type.length() < 3 || type.length() > 11) {
            return false;
        }
        if (type.charAt(0) == '#') {
            return false;
        }
        if (!type.startsWith("\\")) {
            type = "\\" + type;
        }
        return PhpType.isNotExtendablePrimitiveType(type) || PhpType.isArray(type) || _OBJECT.equalsIgnoreCase(type) || _CALLABLE.equalsIgnoreCase(type) || _CALLBACK.equalsIgnoreCase(type) || _ITERABLE.equalsIgnoreCase(type);
    }

    public boolean isNotExtendablePrimitiveType() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getTypes().stream().allMatch(PhpType::isNotExtendablePrimitiveType);
    }

    public static boolean isNotExtendablePrimitiveType(@Nullable String type) {
        if (type == null) {
            return true;
        }
        if (type.length() < 3 || type.length() > 11) {
            return false;
        }
        if (type.charAt(0) == '#') {
            return false;
        }
        if (!type.startsWith("\\")) {
            type = "\\" + type;
        }
        return _MIXED.equalsIgnoreCase(type) || _STRING.equalsIgnoreCase(type) || _INT.equalsIgnoreCase(type) || _INTEGER.equalsIgnoreCase(type) || _NUMBER.equalsIgnoreCase(type) || _BOOL.equalsIgnoreCase(type) || _BOOLEAN.equalsIgnoreCase(type) || _TRUE.equalsIgnoreCase(type) || _FALSE.equalsIgnoreCase(type) || _FLOAT.equalsIgnoreCase(type) || _NULL.equalsIgnoreCase(type) || _RESOURCE.equalsIgnoreCase(type) || _VOID.equalsIgnoreCase(type) || _DOUBLE.equalsIgnoreCase(type);
    }

    public static boolean isArray(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(22);
        }
        return _ARRAY.equals(type);
    }

    public static boolean isString(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(23);
        }
        return _STRING.equals(type);
    }

    public static boolean isObject(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(24);
        }
        return _OBJECT.equals(type);
    }

    public static boolean isMixedType(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(25);
        }
        return _MIXED.equals(type);
    }

    public static boolean isCallableType(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(26);
        }
        return _CALLABLE.equals(type);
    }

    public static boolean isPluralType(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(27);
        }
        return type.endsWith("[]");
    }

    public static boolean isPluralPrimitiveType(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(28);
        }
        return type.endsWith("[]") && PhpType.isPrimitiveType(type.substring(0, type.length() - 2));
    }

    public static boolean isAnonymousClass(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(29);
        }
        return StringUtil.startsWith((CharSequence)type, (CharSequence)"__anonymous@");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhpType)) {
            return false;
        }
        PhpType phpType = (PhpType)o;
        if (this.isComplete != phpType.isComplete) {
            return false;
        }
        return !(this.types != null ? !this.types.equals(phpType.types) : phpType.types != null);
    }

    public int hashCode() {
        int result = this.types != null ? PhpType.computeHashCode(this.types) : 0;
        result = 31 * result + (this.isComplete ? 1 : 0);
        return result;
    }

    private static int computeHashCode(@NotNull Set<String> types) {
        if (types == null) {
            PhpType.$$$reportNull$$$0(30);
        }
        int result = 0;
        for (String type : types) {
            result += CaseInsensitiveStringHashingStrategy.INSTANCE.computeHashCode(type);
        }
        return result;
    }

    public static boolean isUnresolved(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(31);
        }
        return type.indexOf(35) != -1;
    }

    public static boolean isNull(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(32);
        }
        return _NULL.equals(type);
    }

    public static boolean isScalar(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(33);
        }
        return _BOOL.equals(type) || _BOOLEAN.equals(type) || _FLOAT.equals(type) || _STRING.equals(type) || _INT.equals(type) || _INTEGER.equals(type);
    }

    public static boolean isScalar(@NotNull PhpType type, @NotNull Project project) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(34);
        }
        if (project == null) {
            PhpType.$$$reportNull$$$0(35);
        }
        PhpType completedType = type.global(project);
        Set<String> types = completedType.types;
        if (types == null) {
            return true;
        }
        for (String curType : types) {
            if (PhpType.isScalar(curType)) continue;
            return false;
        }
        return true;
    }

    public static boolean intersects(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(36);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(37);
        }
        Set<String> phpTypeSet1 = phpType1.types;
        Set<String> phpTypeSet2 = phpType2.types;
        if (phpTypeSet1 == null || phpTypeSet2 == null) {
            return phpTypeSet1 == phpTypeSet2;
        }
        for (String type1 : phpTypeSet1) {
            if (!phpTypeSet2.contains(type1)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubType(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        Set<String> typeSet1;
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(38);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(39);
        }
        if ((typeSet1 = phpType1.types) == null || typeSet1.size() == 0) {
            return false;
        }
        Set<String> typeSet2 = phpType2.types;
        if (typeSet2 == null || typeSet2.size() == 0) {
            return false;
        }
        for (String type1 : typeSet1) {
            if (typeSet2.contains(type1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static PhpType and(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(40);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(41);
        }
        Set<String> phpTypeSet1 = phpType1.types;
        Set<String> phpTypeSet2 = phpType2.types;
        if (phpTypeSet1 == null || phpTypeSet2 == null) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(42);
            }
            return phpType;
        }
        PhpType phpType = new PhpType();
        for (String type1 : phpTypeSet1) {
            if (!phpTypeSet2.contains(type1)) continue;
            phpType.add(type1);
        }
        PhpType phpType3 = phpType;
        if (phpType3 == null) {
            PhpType.$$$reportNull$$$0(43);
        }
        return phpType3;
    }

    @NotNull
    public static PhpType or(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(44);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(45);
        }
        PhpType phpType = new PhpType().add(phpType1).add(phpType2);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(46);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterNull() {
        PhpType phpType = this.filterOut(PhpType::isNull);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(47);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterMixed() {
        PhpType phpType = this.filterOut(PhpType::isMixedType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(48);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterPlurals() {
        PhpType phpType = this.filterOut(PhpType::isPluralType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(49);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterOut(@NotNull Predicate<String> typeExcludePredicate) {
        if (typeExcludePredicate == null) {
            PhpType.$$$reportNull$$$0(50);
        }
        if (this.types == null) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(51);
            }
            return phpType;
        }
        PhpType phpType = new PhpType();
        for (String type : this.types) {
            if (typeExcludePredicate.test(type)) continue;
            phpType.add(type);
        }
        PhpType phpType2 = phpType;
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(52);
        }
        return phpType2;
    }

    @NotNull
    public PhpType filter(@NotNull PhpType sieve) {
        if (sieve == null) {
            PhpType.$$$reportNull$$$0(53);
        }
        if (ContainerUtil.isEmpty(this.types)) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(54);
            }
            return phpType;
        }
        Set<String> sieveTypes = sieve.types;
        if (ContainerUtil.isEmpty(sieveTypes)) {
            PhpType phpType = new PhpType().add(this);
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(55);
            }
            return phpType;
        }
        PhpType phpType = new PhpType();
        if (sieveTypes.size() == 1) {
            String sieveType = (String)ContainerUtil.getFirstItem(sieveTypes);
            assert (sieveType != null);
            this.types.stream().filter((? super T type) -> !sieveType.equals(type)).forEach(phpType::add);
        } else {
            this.types.stream().filter((? super T type) -> !sieveTypes.contains(type)).forEach(phpType::add);
        }
        PhpType phpType2 = phpType;
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(56);
        }
        return phpType2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 50: 
            case 53: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 50: 
            case 53: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "some";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "my";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 36: 
            case 38: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType1";
                break;
            }
            case 37: 
            case 39: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType2";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExcludePredicate";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sieve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesSorted";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 50: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUnknown";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPrimitives";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "elementType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralise";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "unpluralize";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNull";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMixed";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPlurals";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOut";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleFrom";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkInvoke";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSuper";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "globalLocationAware";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "global";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isArray";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isString";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isObject";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isMixedType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isCallableType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isPluralType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isPluralPrimitiveType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousClass";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "computeHashCode";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolved";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isNull";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isScalar";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isSubType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "filterOut";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 50: 
            case 53: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpTypeBuilder {
        private final PhpType temp = new PhpType();

        @NotNull
        public PhpTypeBuilder add(@Nullable String aClass) {
            this.temp.add(aClass);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(0);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpTypeBuilder add(@Nullable PsiElement other) {
            this.temp.add(other);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(1);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpTypeBuilder add(@Nullable PhpType type) {
            this.temp.add(type);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(2);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpTypeBuilder merge(@NotNull PhpTypeBuilder builder) {
            if (builder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(3);
            }
            this.temp.add(builder.temp);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(4);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpType build() {
            ImmutablePhpType type = new ImmutablePhpType();
            if (this.temp.types != null) {
                switch (this.temp.types.size()) {
                    case 0: {
                        type.types = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        type.types = Collections.singleton(ContainerUtil.getFirstItem(this.temp.types));
                        break;
                    }
                    default: {
                        type.types = this.temp.types;
                        ((PhpType)type).dirty = this.temp.dirty;
                    }
                }
            }
            ((PhpType)type).isComplete = this.temp.isComplete;
            ImmutablePhpType immutablePhpType = type;
            if (immutablePhpType == null) {
                PhpTypeBuilder.$$$reportNull$$$0(5);
            }
            return immutablePhpType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$PhpTypeBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$PhpTypeBuilder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ImmutablePhpType
    extends PhpType {
        private ImmutablePhpType() {
        }

        @Override
        @NotNull
        public PhpType add(@Nullable String aClass) {
            throw ImmutablePhpType.getException();
        }

        @Override
        @NotNull
        public PhpType add(@Nullable PsiElement other) {
            throw ImmutablePhpType.getException();
        }

        @Override
        @NotNull
        public PhpType add(@Nullable PhpType type) {
            throw ImmutablePhpType.getException();
        }

        @NotNull
        private static RuntimeException getException() {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("This PHP type is immutable");
            if (unsupportedOperationException == null) {
                ImmutablePhpType.$$$reportNull$$$0(0);
            }
            return unsupportedOperationException;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ImmutablePhpType", "getException"));
        }
    }
}

