/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.ZonedValue;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.VersionComparatorUtil;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.OracleExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.OracleIntermediateFacade;

public class OraJdbcHelper
extends JdbcHelperImpl {
    private static final String ORA_TIMESTAMP_TZ = "timestamp with time zone";
    public static final String TIMESTAMPTZ_CLASS_NAME = "oracle.sql.TIMESTAMPTZ";
    private static final int MIN_OFFSET_INDEX = "0000-00-00".length() - 1;
    private final boolean myLtzTimestampInGmt;
    private final boolean myTimestampInGmt;
    private final TimeZone mySessionTimeZone;
    private static final Set<String> ORA_UNLIMITED_TYPES = ContainerUtilRt.newHashSet((Object[])new String[]{"binary_float", "binary_double", "date", "nclob", "bfile", "long", "rowid", "clob", "blob", "xmltype", "uritype", "dburitype", "xdburitype", "httpuritype", "anytype", "anydata", "anydataset"});

    public OraJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super(Oracle.RDBMS, version, connection);
        if (connection != null) {
            String driverVersion = OraJdbcHelper.getDriverVer(connection);
            this.myTimestampInGmt = OraJdbcHelper.isTimestampInGmt(connection, driverVersion);
            this.myLtzTimestampInGmt = VersionComparatorUtil.compare((String)driverVersion, (String)"11.2.0.2") >= 0;
            this.mySessionTimeZone = OraJdbcHelper.getSessionZone(connection);
        } else {
            this.myTimestampInGmt = false;
            this.myLtzTimestampInGmt = false;
            this.mySessionTimeZone = null;
        }
    }

    public OraJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return OraJdbcHelper.extractVersion(version);
    }

    @Override
    public int fixJdbcType(@Nullable String typeName, @Nullable String clazz, int type) {
        if (type == -101 || type == -102) {
            return 93;
        }
        if (type == 2007) {
            return 12;
        }
        return super.fixJdbcType(typeName, clazz, type);
    }

    @Override
    public Object convertValue(JdbcRemoteObject exporter, Object o) throws RemoteException, SQLException {
        Object value;
        Class<?> c = o.getClass();
        String className = c.getName();
        if (className.startsWith("oracle.") && (value = this.convertValue(exporter, className, o)) != null) {
            return value;
        }
        return super.convertValue(exporter, o);
    }

    @Override
    public Object[] getCurrentRow(@NotNull RemoteResultSet.DataRetrievingOptions options, @NotNull JdbcRemoteObject exporter, @NotNull ResultSet resultSet, @NotNull ResultSetMetaData metaData) throws SQLException {
        int i;
        if (options == null) {
            OraJdbcHelper.$$$reportNull$$$0(0);
        }
        if (exporter == null) {
            OraJdbcHelper.$$$reportNull$$$0(1);
        }
        if (resultSet == null) {
            OraJdbcHelper.$$$reportNull$$$0(2);
        }
        if (metaData == null) {
            OraJdbcHelper.$$$reportNull$$$0(3);
        }
        int columnCount = metaData.getColumnCount();
        Object[] objects = new Object[columnCount];
        for (i = 1; i <= columnCount; ++i) {
            if (metaData.getColumnType(i) != -1) continue;
            objects[i - 1] = this.getObject(options, exporter, resultSet, metaData, i);
        }
        for (i = 1; i <= columnCount; ++i) {
            if (metaData.getColumnType(i) == -1) continue;
            objects[i - 1] = this.getObject(options, exporter, resultSet, metaData, i);
        }
        return objects;
    }

    @Override
    @Nullable
    protected ZonedValue createZonedValue(@NotNull ResultSet resultSet, int index) throws SQLException {
        String timestamp;
        if (resultSet == null) {
            OraJdbcHelper.$$$reportNull$$$0(4);
        }
        return (timestamp = resultSet.getString(index)) != null ? new ZonedValue(this.normalizeTimestamp(timestamp, resultSet.getTimestamp(index))) : null;
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        int cb;
        if (e == null) {
            OraJdbcHelper.$$$reportNull$$$0(5);
        }
        if (e.typeName == null) {
            return;
        }
        String t = e.typeName.toLowerCase(Locale.ENGLISH);
        if (ORA_UNLIMITED_TYPES.contains(t)) {
            e.length = -1;
        } else if ("number".equals(t) && e.scale == -127) {
            e.length = -1;
            e.scale = 0;
        }
        int idx = t.indexOf(40);
        int n = cb = idx == -1 ? -1 : t.indexOf(41, idx);
        if (cb != -1) {
            e.typeSuffix = e.typeName.substring(cb + 1).trim();
            e.typeName = e.typeName.substring(0, idx).trim();
            if (!t.contains("interval")) {
                e.length = e.scale;
            }
            e.scale = 0;
        }
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull DataSource ds) {
        if (ds == null) {
            OraJdbcHelper.$$$reportNull$$$0(6);
        }
        OracleIntermediateFacade oracleIntermediateFacade = new OracleIntermediateFacade(ds, 1, false, (DBExceptionRecognizer)OracleExceptionRecognizer.INSTANCE);
        if (oracleIntermediateFacade == null) {
            OraJdbcHelper.$$$reportNull$$$0(7);
        }
        return oracleIntermediateFacade;
    }

    @Override
    protected void setTimestamp(@NotNull RemotePreparedStatement statement, int idx, Timestamp timestamp) throws Exception {
        Class<?> clazz;
        Constructor<?> constructor;
        if (statement == null) {
            OraJdbcHelper.$$$reportNull$$$0(8);
        }
        Constructor<?> constructor2 = constructor = (clazz = Class.forName("oracle.sql.TIMESTAMP")) == null ? null : clazz.getConstructor(Timestamp.class, Calendar.class);
        if (constructor != null) {
            Object o = constructor.newInstance(timestamp, JdbcNativeUtil.getUtcCalendar());
            statement.setObject(idx, o);
        } else {
            super.setTimestamp(statement, idx, timestamp);
        }
    }

    @Override
    public boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        if (typeName != null && ORA_TIMESTAMP_TZ.equalsIgnoreCase(typeName)) {
            return true;
        }
        return super.isZonedTimestampColumn(typeName, jdbcType);
    }

    private Object convertValue(JdbcRemoteObject exporter, String className, Object o) throws RemoteException, SQLException {
        Object opaqueTypeName;
        Object value;
        if (className.startsWith("oracle.xdb.XMLType") && (value = OraJdbcHelper.tryMethodWithConnection(o, "getString", null)) != null) {
            return value;
        }
        if (className.equals(TIMESTAMPTZ_CLASS_NAME)) {
            value = OraJdbcHelper.tryMethodWithConnection(o, "timestampValue", this.myConnection);
            if (value instanceof Timestamp) {
                Calendar calendar;
                TimeZone timeZone = OraJdbcHelper.extractTimeZone(o);
                if (this.myTimestampInGmt) {
                    calendar = Calendar.getInstance(timeZone);
                    calendar.setTime((Date)value);
                } else {
                    calendar = Calendar.getInstance();
                    calendar.setTime((Date)value);
                    if (timeZone != null) {
                        calendar.getTimeZone().setID(timeZone.getID());
                        calendar.getTimeZone().setRawOffset(timeZone.getRawOffset());
                    }
                }
                value = new Timestamp(calendar.getTimeInMillis());
            }
        } else if (className.equals("oracle.sql.TIMESTAMPLTZ")) {
            value = ReflectionHelper.tryInvokeMethod(null, o.getClass(), "toTimestamp", new Class[]{Connection.class, byte[].class}, new Object[]{this.myConnection, ReflectionHelper.tryInvokeMethod(o, "toBytes", null, null)});
            if (value instanceof Timestamp) {
                Calendar calendar = this.mySessionTimeZone != null ? Calendar.getInstance(this.mySessionTimeZone) : Calendar.getInstance();
                if (this.myLtzTimestampInGmt) {
                    calendar.setTimeInMillis(((Timestamp)value).getTime());
                } else {
                    Calendar localCalendar = Calendar.getInstance();
                    localCalendar.setTime((Date)value);
                    calendar.set(localCalendar.get(1), localCalendar.get(2), localCalendar.get(5), localCalendar.get(11), localCalendar.get(12), localCalendar.get(13));
                    calendar.set(14, ((Timestamp)value).getNanos() / 1000000);
                }
                value = new Timestamp(calendar.getTimeInMillis());
            }
        } else if (className.equals("oracle.sql.STRUCT")) {
            Object attributes = ReflectionHelper.tryInvokeMethod(o, o.getClass(), "getAttributes", new Class[0], new Object[0]);
            value = this.wrapIfNeeded(exporter, attributes);
        } else {
            value = OraJdbcHelper.tryMethodWithConnection(o, "toJdbc", null);
            if (value == null) {
                value = OraJdbcHelper.tryMethodWithConnection(o, "stringValue", null);
            }
        }
        if (value != null) {
            return value;
        }
        Object object = opaqueTypeName = className.equals("oracle.sql.OPAQUE") ? ReflectionHelper.tryInvokeMethod(ReflectionHelper.tryInvokeMethod(o, "getDescriptor", null, null), "getName", null, null) : null;
        if (opaqueTypeName instanceof String) {
            return "<failed to load> " + className + "\n" + ("SYS.XMLTYPE".equalsIgnoreCase((String)opaqueTypeName) ? "Oracle XML DB library" : className + " support library") + " is missing in the database driver";
        }
        return null;
    }

    private static Object tryMethodWithConnection(Object o, String methodName, @Nullable Connection connection) {
        Object[] objectArray;
        Class[] classArray;
        if (connection == null) {
            classArray = ArrayUtilRt.EMPTY_CLASS_ARRAY;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Connection.class;
        }
        if (connection == null) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = connection;
        }
        Object value = ReflectionHelper.tryInvokeMethod(o, methodName, classArray, objectArray);
        return value != null && value.getClass().getClassLoader() == null ? value : null;
    }

    private static TimeZone extractTimeZone(Object o) {
        String regionName;
        Object b = ReflectionHelper.tryInvokeMethod(o, "toBytes", null, null);
        if (!(b instanceof byte[])) {
            return null;
        }
        byte[] bytes = (byte[])b;
        if ((bytes[11] & 0xFFFFFF80) != 0) {
            int regionCode = (bytes[11] & 0x7F) << 6;
            regionName = (String)ReflectionHelper.tryInvokeMethod("oracle.sql.ZONEIDMAP", "getRegion", new Class[]{Integer.TYPE}, new Object[]{regionCode += (bytes[12] & 0xFC) >> 2});
        } else {
            int hourOffset = bytes[11] - 20;
            int minuteOffset = bytes[12] - 60;
            regionName = String.format("GMT%+03d:%02d", hourOffset, Math.abs(minuteOffset));
        }
        return TimeZone.getTimeZone(regionName);
    }

    @NotNull
    public String normalizeTimestamp(@NotNull String string, @NotNull Timestamp timestamp) {
        int zoneStart;
        if (string == null) {
            OraJdbcHelper.$$$reportNull$$$0(9);
        }
        if (timestamp == null) {
            OraJdbcHelper.$$$reportNull$$$0(10);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        int era = calendar.get(0);
        int plusIndex = string.lastIndexOf("+");
        int n = zoneStart = plusIndex == -1 ? string.lastIndexOf("-") : plusIndex;
        if (zoneStart == -1 || zoneStart <= MIN_OFFSET_INDEX) {
            String string2 = string + OraJdbcHelper.getEraString(era);
            if (string2 == null) {
                OraJdbcHelper.$$$reportNull$$$0(11);
            }
            return string2;
        }
        String withoutZone = string.substring(0, zoneStart);
        String zone = string.substring(zoneStart);
        String[] hoursMinutes = zone.split(":");
        if (hoursMinutes.length == 0) {
            String string3 = string + OraJdbcHelper.getEraString(era);
            if (string3 == null) {
                OraJdbcHelper.$$$reportNull$$$0(12);
            }
            return string3;
        }
        String minutes = hoursMinutes.length == 2 ? hoursMinutes[1] : null;
        String sign = hoursMinutes[0].length() > 1 ? hoursMinutes[0].substring(0, 1) : "+";
        String hours = hoursMinutes[0].substring(1);
        String normalizedHours = hours.length() == 1 ? "0" + hours : hours;
        String string4 = withoutZone + sign + normalizedHours + ":" + (minutes == null ? "" : minutes) + OraJdbcHelper.getEraString(era);
        if (string4 == null) {
            OraJdbcHelper.$$$reportNull$$$0(13);
        }
        return string4;
    }

    @NotNull
    private static String getEraString(int era) {
        String string = era == 1 ? "" : " BC";
        if (string == null) {
            OraJdbcHelper.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static String getDriverVer(@NotNull Connection connection) {
        String driverVersion;
        if (connection == null) {
            OraJdbcHelper.$$$reportNull$$$0(15);
        }
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            driverVersion = metaData.getDriverVersion();
        }
        catch (SQLException e) {
            driverVersion = "";
        }
        return driverVersion;
    }

    private static boolean isTimestampInGmt(@NotNull Connection connection, String driverVersion) {
        if (connection == null) {
            OraJdbcHelper.$$$reportNull$$$0(16);
        }
        if (VersionComparatorUtil.compare((String)driverVersion, (String)"11.1.0.7") < 0) {
            return false;
        }
        Object p = ReflectionHelper.tryInvokeMethod(connection, "getProperties", null, null);
        if (p instanceof Properties) {
            String timestampTzInGmtPropStr = ((Properties)p).getProperty("oracle.jdbc.timestampTzInGmt", "true");
            return timestampTzInGmtPropStr.equalsIgnoreCase("true");
        }
        return true;
    }

    @Nullable
    private static TimeZone getSessionZone(@NotNull Connection connection) {
        Object value;
        if (connection == null) {
            OraJdbcHelper.$$$reportNull$$$0(17);
        }
        return (value = ReflectionHelper.tryInvokeMethod(connection, "getSessionTimeZone", null, null)) instanceof String ? TimeZone.getTimeZone((String)value) : null;
    }

    @Nullable
    static JdbcHelperImpl detect(@NotNull Connection delegate, @Nullable String product) throws Exception {
        if (delegate == null) {
            OraJdbcHelper.$$$reportNull$$$0(18);
        }
        if (!JdbcNativeUtil.detectString(product, "oracle")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return OraJdbcHelper.create(delegate);
    }

    @NotNull
    protected static OraJdbcHelper create(@NotNull Connection delegate) throws Exception {
        DatabaseMetaData md;
        if (delegate == null) {
            OraJdbcHelper.$$$reportNull$$$0(19);
        }
        String versionStr = (md = delegate.getMetaData()) == null ? null : md.getDatabaseProductVersion();
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + versionStr);
        OraJdbcHelper oraJdbcHelper = new OraJdbcHelper(OraJdbcHelper.extractVersion(versionStr), delegate);
        if (oraJdbcHelper == null) {
            OraJdbcHelper.$$$reportNull$$$0(20);
        }
        return oraJdbcHelper;
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/OraJdbcHelper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/OraJdbcHelper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFacade";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeTimestamp";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEraString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createZonedValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "normalizeTimestamp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDriverVer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTimestampInGmt";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSessionZone";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

