/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssMediumList;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssUriImpl;
import com.intellij.psi.css.impl.stubs.CssImportStub;
import com.intellij.psi.css.impl.stubs.CssImportStubElementType;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.resolve.CssReferenceProviderUtil;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssImportImpl
extends CssStubElement<CssImportStub>
implements CssImport {
    public static final ArrayFactory<CssImport> ARRAY_FACTORY = count -> count == 0 ? CssImport.EMPTY_ARRAY : new CssImport[count];

    public CssImportImpl(@NotNull CssImportStub stub, @NotNull CssImportStubElementType nodeType) {
        if (stub == null) {
            CssImportImpl.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            CssImportImpl.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public CssImportImpl(@NotNull ASTNode node) {
        if (node == null) {
            CssImportImpl.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @NotNull
    public String[] getUriStrings() {
        CssImportStub stub = (CssImportStub)this.getStub();
        if (stub != null) {
            String[] stringArray = stub.getPaths();
            if (stringArray == null) {
                CssImportImpl.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        List result = ContainerUtil.newSmartList();
        for (PsiElement element : this.getUriElements()) {
            Pair<String, TextRange> data = CssReferenceProviderUtil.getFileReferenceData(element);
            if (data == null) continue;
            result.add(data.first);
        }
        String[] stringArray = ArrayUtil.toStringArray((Collection)result);
        if (stringArray == null) {
            CssImportImpl.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @NotNull
    public PsiElement[] getUriElements() {
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssString.class));
        List uris = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, CssUriImpl.class);
        for (CssUriImpl uri : uris) {
            PsiElement valueElement = uri.getValueElement();
            if (valueElement == null || valueElement instanceof PsiErrorElement) continue;
            result.add(valueElement);
        }
        PsiElement[] psiElementArray = !result.isEmpty() ? result.toArray(PsiElement.EMPTY_ARRAY) : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            CssImportImpl.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @Nullable
    public CssMediumList getMediumList() {
        return (CssMediumList)PsiTreeUtil.getChildOfType((PsiElement)this, CssMediumList.class);
    }

    public boolean isScreen() {
        return this.getMediaTypes().contains(CssMediaType.SCREEN);
    }

    @NotNull
    public Set<CssMediaType> getMediaTypes() {
        CssImportStub stub = (CssImportStub)this.getStub();
        if (stub != null) {
            Set<CssMediaType> set = stub.getMediaTypes();
            if (set == null) {
                CssImportImpl.$$$reportNull$$$0(6);
            }
            return set;
        }
        CssMediumList mediumList = this.getMediumList();
        Set<CssMediaType> set = mediumList != null ? mediumList.getTypes() : Collections.singleton(CssMediaType.SCREEN);
        if (set == null) {
            CssImportImpl.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Nullable
    public CssAtRule getSupports() {
        return (CssAtRule)ObjectUtils.tryCast((Object)this.findChildByType(CssElementTypes.CSS_SUPPORTS), CssAtRule.class);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssImportImpl.$$$reportNull$$$0(8);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssImport((CssImport)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiFile[] resolve() {
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement element : this.getUriElements()) {
            Collections.addAll(result, CssResolveManager.getInstance().resolveFiles(element));
        }
        PsiFile[] psiFileArray = !result.isEmpty() ? result.toArray(PsiFile.EMPTY_ARRAY) : PsiFile.EMPTY_ARRAY;
        if (psiFileArray == null) {
            CssImportImpl.$$$reportNull$$$0(9);
        }
        return psiFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssImportImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssImportImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUriStrings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUriElements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMediaTypes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

