/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom.predefined;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTarget;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.PropertiesProvider;
import com.jetbrains.php.phing.dom.PropertyFilesManager;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhingPredefinedPropertyTask
extends PhingPredefinedElement
implements PropertiesProvider {
    private volatile Map<String, String> myCachedProperties;

    public GenericAttributeValue<String> findName() {
        return this.findAttributeValue("name");
    }

    public GenericAttributeValue<String> findValue() {
        return this.findAttributeValue("value");
    }

    public GenericAttributeValue<PsiFileSystemItem> findFile() {
        return this.findAttributeValue("file");
    }

    public GenericAttributeValue<String> findPrefix() {
        return this.findAttributeValue("prefix");
    }

    public GenericAttributeValue<String> findEnvironment() {
        return this.findAttributeValue("environment");
    }

    @Override
    @NotNull
    public final Iterator<String> getNamesIterator() {
        final String prefix = this.getPropertyPrefixValue();
        final Iterator<String> delegate = this.buildProperties().keySet().iterator();
        if (prefix == null) {
            Iterator<String> iterator = delegate;
            if (iterator == null) {
                PhingPredefinedPropertyTask.$$$reportNull$$$0(0);
            }
            return iterator;
        }
        Iterator<String> iterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return delegate.hasNext();
            }

            @Override
            public String next() {
                return prefix + (String)delegate.next();
            }

            @Override
            public void remove() {
                delegate.remove();
            }
        };
        if (iterator == null) {
            PhingPredefinedPropertyTask.$$$reportNull$$$0(1);
        }
        return iterator;
    }

    @Override
    public PsiElement getNavigationElement(String propertyName) {
        PsiElement psi;
        GenericAttributeValue<String> environment;
        DomTarget domTarget = PhingUtils.getDomTarget(this);
        if (domTarget == null && (environment = this.findEnvironment()).getRawText() != null) {
            domTarget = PhingUtils.getDomTarget(this, environment);
        }
        if (domTarget != null && (psi = PomService.convertToPsi((PsiTarget)domTarget)) != null) {
            return psi;
        }
        PsiFileSystemItem psiFile = (PsiFileSystemItem)this.findFile().getValue();
        if (psiFile != null) {
            PropertyFilesManager[] managers;
            String prefix = this.getPropertyPrefixValue();
            String _propertyName = propertyName;
            if (prefix != null) {
                if (!propertyName.startsWith(prefix)) {
                    return null;
                }
                _propertyName = propertyName.substring(prefix.length());
            }
            if ((managers = (PropertyFilesManager[])PropertyFilesManager.EP.getExtensions()).length > 0) {
                return managers[0].findProperty(psiFile, _propertyName);
            }
            Properties properties = new Properties();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null) {
                try {
                    properties.load(virtualFile.getInputStream());
                    return properties.containsKey(_propertyName) ? psiFile : null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public final String getPropertyValue(String propertyName) {
        String environmentPrefix = (String)this.findEnvironment().getValue();
        if (environmentPrefix != null && propertyName.startsWith(environmentPrefix)) {
            return "";
        }
        String prefix = this.getPropertyPrefixValue();
        if (prefix != null) {
            if (!propertyName.startsWith(prefix)) {
                return null;
            }
            propertyName = propertyName.substring(prefix.length());
        }
        return this.buildProperties().get(propertyName);
    }

    private Map<String, String> buildProperties() {
        Map<String, String> result = this.myCachedProperties;
        if (result != null) {
            return result;
        }
        result = Collections.emptyMap();
        String propertyName = this.findName().getRawText();
        if (propertyName != null) {
            String propertyValue = this.findValue().getRawText();
            if (propertyValue != null) {
                result = Collections.singletonMap(propertyName, propertyValue);
            }
        } else {
            PsiFileSystemItem psiFile = (PsiFileSystemItem)this.findFile().getValue();
            if (psiFile != null) {
                PropertyFilesManager[] managers = (PropertyFilesManager[])PropertyFilesManager.EP.getExtensions();
                result = new HashMap<String, String>();
                if (managers.length > 0) {
                    managers[0].collectProperties(psiFile, result);
                } else {
                    Properties properties = new Properties();
                    VirtualFile virtualFile = psiFile.getVirtualFile();
                    if (virtualFile != null) {
                        try {
                            properties.load(virtualFile.getInputStream());
                            for (Map.Entry<Object, Object> property : properties.entrySet()) {
                                result.put((String)property.getKey(), (String)property.getValue());
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        this.myCachedProperties = result;
        return this.myCachedProperties;
    }

    @Nullable
    public String getPropertyPrefixValue() {
        boolean prefixIsApplicable;
        GenericAttributeValue<String> prefixValue = this.findPrefix();
        boolean bl = prefixIsApplicable = this.findName().getRawText() == null && this.findFile().getRawText() != null;
        if (!prefixIsApplicable) {
            return null;
        }
        String prefix = prefixValue.getRawText();
        if (prefix != null && !prefix.endsWith(".")) {
            return prefix + ".";
        }
        return prefix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/predefined/PhingPredefinedPropertyTask", "getNamesIterator"));
    }
}

