/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.StdLanguages;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateDataElementType;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ReflectionUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFileViewProvider
extends MultiplePsiFilesPerDocumentFileViewProvider
implements TemplateLanguageFileViewProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.lang.PhpFileViewProvider");
    private static final boolean DEBUG_TEMPLATE_TEXT = false;
    private final Language myTemplateDataLanguage;
    private static final Language PHP_LANGUAGE = Language.findInstance(PhpLanguage.class);
    private Set<Language> myLanguages;
    private static final TemplateDataElementType ourTemplateDataType = new TemplateDataElementType("TEMPLATE_DATA in PHP", PHP_LANGUAGE, PhpTokenTypes.HTML, PhpElementTypes.PHP_OUTER_TYPE){
        private static final int HTML = 0;
        private static final int PHP = 1;
        private static final int SINGLE_QUOTED = 2;
        private static final int DOUBLE_QUOTED = 3;
        private static final int BLOCK_COMMENT = 4;
        private static final int HEREDOC = 5;
        private static final int LINE_COMMENT = 6;
        private static final int HASH_COMMENT = 7;

        protected CharSequence createTemplateText(@NotNull CharSequence src, @NotNull Lexer baseLexer, @NotNull TemplateDataElementType.RangeCollector rangeCollector) {
            if (src == null) {
                1.$$$reportNull$$$0(0);
            }
            if (baseLexer == null) {
                1.$$$reportNull$$$0(1);
            }
            if (rangeCollector == null) {
                1.$$$reportNull$$$0(2);
            }
            StringBuilder result = new StringBuilder(src.length() / 2 + 16);
            int i = 0;
            int s = 0;
            CharSequence ndEnd = "";
            int php = 0;
            while (i < src.length()) {
                int backslashes;
                int n;
                int p = i > 1 ? (int)src.charAt(i - 1) : 65535;
                char c = src.charAt(i);
                int n2 = n = i < src.length() - 1 ? (int)src.charAt(i + 1) : 65535;
                if (s == 0) {
                    if (c == '<' && n == 63) {
                        php = i;
                        i += 2;
                        s = 1;
                        continue;
                    }
                    if (c != '\uffff') {
                        result.append(c);
                    }
                } else if (s == 1) {
                    if (c == '/' && n == 42) {
                        i += 2;
                        s = 4;
                        continue;
                    }
                    if (c == '/' && n == 47) {
                        i += 2;
                        s = 6;
                        continue;
                    }
                    if (c == '#') {
                        ++i;
                        s = 7;
                        continue;
                    }
                    if (p == 60 && c == '<' && n == 60) {
                        i += 2;
                        int q = (i += StringUtil.countChars((CharSequence)src, (char)' ', (int)i, (boolean)true)) < src.length() && (src.charAt(i) == '\'' || src.charAt(i) == '\"') ? 1 : 0;
                        int nl = StringUtil.indexOf((CharSequence)src, (char)'\n', (int)i);
                        int heredocNameStart = Math.min(src.length(), i + q);
                        int heredocNameEnd = Math.min(src.length(), nl - q);
                        if (nl > 0 && heredocNameStart <= heredocNameEnd && (q == 0 || q == 1 && src.charAt(nl - q) == src.charAt(i))) {
                            ndEnd = src.subSequence(heredocNameStart, heredocNameEnd);
                            i = nl + 1;
                            s = 5;
                            continue;
                        }
                    }
                    if (c == '\'') {
                        s = 2;
                    }
                    if (c == '\"') {
                        s = 3;
                    }
                } else if (s == 2) {
                    backslashes = this.countCharsBackwards(src, '\\', i - 1);
                    if (c == '\'' && backslashes % 2 == 0) {
                        s = 1;
                    }
                } else if (s == 3) {
                    backslashes = this.countCharsBackwards(src, '\\', i - 1);
                    if (c == '\"' && backslashes % 2 == 0) {
                        s = 1;
                    }
                } else if (s == 4) {
                    if (c == '*' && n == 47) {
                        i += 2;
                        s = 1;
                        continue;
                    }
                } else if (s == 5) {
                    int ndStart = i - ndEnd.length();
                    CharSequence q = src.subSequence(ndStart, i);
                    if ((c == ';' && n == 10 || c == '\n') && StringUtil.equals((CharSequence)q, (CharSequence)ndEnd) && src.charAt(ndStart - 1) == '\n') {
                        i += c == '\n' ? 1 : 2;
                        s = 1;
                        continue;
                    }
                } else if ((s == 6 || s == 7) && c == '\n') {
                    ++i;
                    s = 1;
                    continue;
                }
                if ((s == 6 || s == 7 || s == 1) && (c == '?' && n == 62 || p == 95 && c == '_' && (n == 104 || n == 72) && i + 17 < src.length() && StringUtil.equalsIgnoreCase((CharSequence)"__halt_compiler();", (CharSequence)src.subSequence(i - 1, i + 17)))) {
                    rangeCollector.addOuterRange(new TextRange(php, i += c == '_' ? 17 : 2));
                    s = 0;
                    continue;
                }
                ++i;
            }
            if (s != 0) {
                rangeCollector.addOuterRange(new TextRange(php, src.length()));
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                StringBuilder message = new StringBuilder();
                TemplateDataElementType.RangeCollector superRangesCollector = new TemplateDataElementType.RangeCollector(){};
                CharSequence superText = super.createTemplateText(src, baseLexer, superRangesCollector);
                if (!StringUtil.equals((CharSequence)result, (CharSequence)superText)) {
                    message.append("Template texts don't match.\n");
                    message.append("fast: ").append((CharSequence)result).append('\n');
                    message.append("slow: ").append(superText).append('\n');
                }
                List<TextRange> ranges = this.getRanges(rangeCollector);
                List<TextRange> superRanges = this.getRanges(superRangesCollector);
                if (ranges != null && !ranges.equals(superRanges)) {
                    message.append("Range collectors don't match.\n");
                    message.append("fast: ").append(ranges).append('\n');
                    message.append("slow: ").append(superRanges).append('\n');
                }
                if (message.length() > 0) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.error((Object)message);
                    } else {
                        System.err.println(message);
                    }
                }
            }
            return result;
        }

        int countCharsBackwards(@NotNull CharSequence text, char c, int start) {
            if (text == null) {
                1.$$$reportNull$$$0(3);
            }
            int count = 0;
            for (int i = start; i >= 0 && text.charAt(i) == c; --i) {
                ++count;
            }
            return count;
        }

        private List<TextRange> getRanges(TemplateDataElementType.RangeCollector collector) {
            return (List)ReflectionUtil.getField(TemplateDataElementType.RangeCollector.class, (Object)collector, List.class, (String)"myRanges");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "src";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseLexer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeCollector";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/PhpFileViewProvider$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTemplateText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countCharsBackwards";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public PhpFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical) {
        super(manager, virtualFile, physical);
        Language language = PhpFileViewProvider.getTemplateDataLanguage(virtualFile, manager.getProject());
        this.myTemplateDataLanguage = language instanceof TemplateLanguage ? PlainTextLanguage.INSTANCE : LanguageSubstitutors.INSTANCE.substituteLanguage(language, virtualFile, manager.getProject());
    }

    public PhpFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical, Language templateDataLanguage) {
        super(manager, virtualFile, physical);
        this.myTemplateDataLanguage = templateDataLanguage;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = PHP_LANGUAGE;
        if (language == null) {
            PhpFileViewProvider.$$$reportNull$$$0(0);
        }
        return language;
    }

    @NotNull
    public Set<Language> getLanguages() {
        if (this.myLanguages != null) {
            Set<Language> set = this.myLanguages;
            if (set == null) {
                PhpFileViewProvider.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<Language> set = this.myLanguages = new LinkedHashSet<Language>(Arrays.asList(PHP_LANGUAGE, this.getTemplateDataLanguage()));
        if (set == null) {
            PhpFileViewProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Language getTemplateDataLanguage() {
        Language language = this.myTemplateDataLanguage;
        if (language == null) {
            PhpFileViewProvider.$$$reportNull$$$0(3);
        }
        return language;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        ParserDefinition parser;
        if (lang == null) {
            PhpFileViewProvider.$$$reportNull$$$0(4);
        }
        if ((parser = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang)) == null) {
            return null;
        }
        if (lang == this.getTemplateDataLanguage()) {
            PsiFileImpl file = (PsiFileImpl)parser.createFile((FileViewProvider)this);
            file.setContentElementType((IElementType)ourTemplateDataType);
            return file;
        }
        if (lang == this.getBaseLanguage()) {
            return parser.createFile((FileViewProvider)this);
        }
        return null;
    }

    @NotNull
    protected PhpFileViewProvider cloneInner(@NotNull VirtualFile copy) {
        if (copy == null) {
            PhpFileViewProvider.$$$reportNull$$$0(5);
        }
        PhpFileViewProvider phpFileViewProvider = new PhpFileViewProvider((PsiManager)this.getManager(), copy, false, this.myTemplateDataLanguage);
        if (phpFileViewProvider == null) {
            PhpFileViewProvider.$$$reportNull$$$0(6);
        }
        return phpFileViewProvider;
    }

    @NotNull
    public static Language getTemplateDataLanguage(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Language language;
        if (virtualFile == null) {
            PhpFileViewProvider.$$$reportNull$$$0(7);
        }
        if (project == null) {
            PhpFileViewProvider.$$$reportNull$$$0(8);
        }
        Language language2 = (language = TemplateDataLanguageMappings.getInstance((Project)project).getMapping(virtualFile)) == null ? PhpFileViewProvider.getTemplateDataLanguageByExtension(virtualFile) : language;
        if (language2 == null) {
            PhpFileViewProvider.$$$reportNull$$$0(9);
        }
        return language2;
    }

    @NotNull
    private static Language getTemplateDataLanguageByExtension(VirtualFile virtualFile) {
        String simpleName;
        Language language;
        String name = virtualFile.getName();
        int index2 = name.lastIndexOf(46);
        if (index2 < 3) {
            Language language2 = StdLanguages.HTML;
            if (language2 == null) {
                PhpFileViewProvider.$$$reportNull$$$0(10);
            }
            return language2;
        }
        int index1 = 1 + name.lastIndexOf(46, index2 - 1);
        if (index1 < 1) {
            Language language3 = StdLanguages.HTML;
            if (language3 == null) {
                PhpFileViewProvider.$$$reportNull$$$0(11);
            }
            return language3;
        }
        String dataLanguageFileExtension = name.substring(index1, index2);
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(dataLanguageFileExtension);
        if (fileType instanceof LanguageFileType && !((language = ((LanguageFileType)fileType).getLanguage()) instanceof TemplateLanguage) && ((simpleName = language.getClass().getSimpleName()).equals("JSLanguageDialect") || simpleName.equals("JavascriptLanguage") || simpleName.equals("CSSLanguage") || simpleName.equals("XMLLanguage"))) {
            Language language4 = language;
            if (language4 == null) {
                PhpFileViewProvider.$$$reportNull$$$0(12);
            }
            return language4;
        }
        Language language5 = StdLanguages.HTML;
        if (language5 == null) {
            PhpFileViewProvider.$$$reportNull$$$0(13);
        }
        return language5;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpFileViewProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 3: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguage";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpFileViewProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneInner";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateDataLanguageByExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "cloneInner";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateDataLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

