/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpFunctionDocCommentUpdater;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor");
    private static final int MAXIMUM_RECURSION_DEPTH = 200;

    public UsageInfo[] findUsages(ChangeInfo info) {
        if (info instanceof PhpChangeInfo) {
            return new PhpChangeSignatureUsageSearcher((PhpChangeInfo)info).findUsages();
        }
        return UsageInfo.EMPTY_ARRAY;
    }

    @Nullable
    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        if (info instanceof PhpChangeInfo) {
            PhpChangeInfo phpChangeInfo = (PhpChangeInfo)info;
            Function function = phpChangeInfo.getMethod();
            if (function instanceof Method) {
                PhpClass clazz;
                Method method = (Method)function;
                if (info.isNameChanged() && (clazz = method.getContainingClass()) != null && clazz.findMethodByName((CharSequence)info.getNewName()) != null) {
                    conflicts.putValue((Object)method, (Object)RefactoringBundle.message((String)"method.0.is.already.defined.in.the.1", (Object[])new Object[]{info.getNewName(), "class " + clazz.getFQN()}));
                }
                if (phpChangeInfo.isVisibilityChanged()) {
                    PhpChangeSignatureUsageProcessor.checkVisibilityConflicts((Method)function, phpChangeInfo, (UsageInfo[])refUsages.get(), (MultiMap<PsiElement, String>)conflicts);
                }
            }
            PhpChangeSignatureUsageProcessor.checkParamsToRemove(function, (PhpChangeInfo)info, (MultiMap<PsiElement, String>)conflicts);
        }
        PhpChangeSignatureUsageProcessor.checkParamsUsageAsFunctionCalls(info, refUsages, (MultiMap<PsiElement, String>)conflicts);
        return conflicts;
    }

    private static void checkParamsToRemove(Function function, PhpChangeInfo info, MultiMap<PsiElement, String> conflictDescriptions) {
        Parameter[] parameters = function.getParameters();
        boolean[] toRemove = info.toRemoveParams();
        GroupStatement methodBody = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)function, GroupStatement.class);
        if (methodBody == null) {
            return;
        }
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)methodBody);
        for (int i = 0; i < toRemove.length; ++i) {
            if (!toRemove[i] || ReferencesSearch.search((PsiElement)parameters[i], (SearchScope)searchScope).findFirst() == null) continue;
            conflictDescriptions.putValue((Object)parameters[i], (Object)(StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)parameters[i], (boolean)true)) + " is used in method body"));
        }
    }

    private static void checkVisibilityConflicts(@NotNull Method method, @NotNull PhpChangeInfo info, @NotNull UsageInfo[] usages, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (method == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(0);
        }
        if (info == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(2);
        }
        if (conflicts == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(3);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof FunctionCallUsageInfo)) continue;
            Function function = ((FunctionCallUsageInfo)usage).getParentFunction();
            PhpClass targetClass = function instanceof Method ? ((Method)function).getContainingClass() : null;
            PsiFile containingFile = usage.getFile();
            if (targetClass == null && containingFile == null || PhpChangeSignatureUsageProcessor.isAccessibleFromClass(method, info.getNewVisibility(), targetClass)) continue;
            conflicts.putValue((Object)usage.getElement(), (Object)PhpBundle.message("change.signature.visibility.not.accessible", RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true), info.getNewVisibility(), PhpChangeSignatureUsageProcessor.getNoAccessibleFrom(function, targetClass, containingFile)));
        }
    }

    private static String getNoAccessibleFrom(@Nullable Function function, @Nullable PhpClass targetClass, @Nullable PsiFile containingFile) {
        if (function == null) {
            return containingFile != null ? containingFile.getName() : "";
        }
        return function instanceof Method && targetClass != null ? PhpHierarchyChecksInspection.buildSuperName((Method)function, targetClass) : PhpPresentationUtil.formatFunction(function);
    }

    private static boolean isAccessibleFromClass(@NotNull Method method, @NotNull String visibility, @Nullable PhpClass targetClass) {
        PhpModifier.Access access;
        if (method == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(4);
        }
        if (visibility == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(5);
        }
        if ((access = PhpChangeSignatureUsageProcessor.accessFromString(visibility)).isPublic()) {
            return true;
        }
        if (targetClass == null) {
            return false;
        }
        if (targetClass.isTrait()) {
            return false;
        }
        PhpClass containingClass = method.getContainingClass();
        if (access.isPrivate()) {
            return containingClass == targetClass;
        }
        return containingClass != null && PhpClassHierarchyUtils.isSuperClass((PhpClass)containingClass, (PhpClass)targetClass, (boolean)false);
    }

    @NotNull
    private static PhpModifier.Access accessFromString(@NotNull String visibility) {
        if (visibility == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(6);
        }
        if (visibility.equals("private")) {
            PhpModifier.Access access = PhpModifier.Access.PRIVATE;
            if (access == null) {
                PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(7);
            }
            return access;
        }
        if (visibility.equals("protected")) {
            PhpModifier.Access access = PhpModifier.Access.PROTECTED;
            if (access == null) {
                PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(8);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(9);
        }
        return access;
    }

    private static void checkParamsUsageAsFunctionCalls(@NotNull ChangeInfo info, @NotNull Ref<UsageInfo[]> refUsages, @NotNull MultiMap<PsiElement, String> conflicts) {
        UsageInfo[] usages;
        if (info == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(10);
        }
        if (refUsages == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(11);
        }
        if (conflicts == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(12);
        }
        block0: for (UsageInfo usage : usages = (UsageInfo[])refUsages.get()) {
            ParameterListOwner owner;
            if (!(usage instanceof FunctionCallUsageInfo) || (owner = (ParameterListOwner)ObjectUtils.tryCast((Object)usage.getElement(), ParameterListOwner.class)) == null || !(info instanceof PhpChangeInfo)) continue;
            PhpChangeInfo phpChangeInfo = (PhpChangeInfo)info;
            boolean[] remainingParameters = phpChangeInfo.getRemainingParameters();
            PsiElement[] args = owner.getParameters();
            for (int i = 0; i < remainingParameters.length; ++i) {
                if (remainingParameters[i] || i >= args.length) continue;
                if (phpChangeInfo.getOldParameterVariadic(i)) {
                    for (int j = i; j < args.length; ++j) {
                        PhpChangeSignatureUsageProcessor.checkParameter(conflicts, usage, args, j, phpChangeInfo.getOldParameterNames(i));
                    }
                    continue block0;
                }
                PhpChangeSignatureUsageProcessor.checkParameter(conflicts, usage, args, i, phpChangeInfo.getOldParameterNames(i));
            }
        }
    }

    private static void checkParameter(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull UsageInfo usage, PsiElement[] args, int index, @NotNull String parameterName) {
        if (conflicts == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(13);
        }
        if (usage == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(14);
        }
        if (parameterName == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(15);
        }
        if (PhpChangeSignatureUsageProcessor.mayHaveSideEffect(args[index], 0)) {
            conflicts.putValue((Object)args[index], (Object)PhpBundle.message("change.signature.parameter.may.have.side.effect", args[index].getText(), parameterName));
        }
    }

    private static boolean mayHaveSideEffect(@Nullable PsiElement argument, int recursionDepth) {
        if (++recursionDepth > 200) {
            return false;
        }
        if (argument instanceof FunctionReference) {
            return true;
        }
        if (argument instanceof NewExpression) {
            return true;
        }
        if (argument instanceof AssignmentExpression) {
            return true;
        }
        if (argument instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)argument;
            return PhpPsiUtil.isOfType(unaryExpression.getOperation(), PhpTokenTypes.opDECREMENT, PhpTokenTypes.opINCREMENT) || PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)unaryExpression.getValue(), recursionDepth);
        }
        if (argument instanceof ParenthesizedExpression) {
            PhpPsiElement underlyingExpression = ((ParenthesizedExpression)argument).unparenthesize();
            return !(underlyingExpression instanceof ParenthesizedExpression) && PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)underlyingExpression, recursionDepth);
        }
        if (argument instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)argument;
            return PhpChangeSignatureUsageProcessor.mayHaveSideEffect(binaryExpression.getLeftOperand(), recursionDepth) || PhpChangeSignatureUsageProcessor.mayHaveSideEffect(binaryExpression.getRightOperand(), recursionDepth);
        }
        if (argument instanceof TernaryExpression) {
            TernaryExpression ternary = (TernaryExpression)argument;
            return PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)ternary.getCondition(), recursionDepth) || PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)ternary.getTrueVariant(), recursionDepth) || PhpChangeSignatureUsageProcessor.mayHaveSideEffect((PsiElement)ternary.getFalseVariant(), recursionDepth);
        }
        return false;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages) {
        if (usageInfo instanceof PhpChangeSignatureUsageInfo && changeInfo instanceof PhpChangeInfo) {
            ((PhpChangeSignatureUsageInfo)usageInfo).process((PhpChangeInfo)changeInfo, beforeMethodChange);
        }
        return false;
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        if (changeInfo instanceof PhpChangeInfo && changeInfo.getLanguage().is((Language)PhpLanguage.INSTANCE)) {
            PhpChangeInfo phpChangeInfo = (PhpChangeInfo)changeInfo;
            PhpChangeSignatureUsageProcessor.processFunctionDeclaration(phpChangeInfo, phpChangeInfo.getMethod());
            return true;
        }
        return false;
    }

    private static void processFunctionDeclaration(@NotNull PhpChangeInfo changeInfo, @NotNull Function function) {
        if (changeInfo == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(16);
        }
        if (function == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(17);
        }
        if (changeInfo.isNameChanged()) {
            PhpChangeSignatureUsageProcessor.updateIdentifier(function.getProject(), function.getNameIdentifier(), changeInfo.getNewName());
        }
        boolean shouldFixPhpDoc = false;
        if (changeInfo.isReturnTypeChanged()) {
            PhpChangeSignatureUsageProcessor.updateReturnType(function.getProject(), function, changeInfo.getNewReturnTypeText());
            shouldFixPhpDoc = true;
        }
        if (changeInfo.isVisibilityChanged() && function instanceof Method) {
            PhpChangeSignatureUsageProcessor.updateMethodVisibility(changeInfo, (Method)function);
        }
        if (changeInfo.isParameterSetOrOrderChanged()) {
            PhpChangeSignatureUsageProcessor.updateParameterList(changeInfo, function);
            shouldFixPhpDoc = true;
        } else if (changeInfo.isParametersChanged()) {
            PhpParameterInfo[] newParameters = changeInfo.getNewParameters();
            Parameter[] oldParameters = function.getParameters();
            if (oldParameters.length == newParameters.length) {
                for (int i = 0; i < newParameters.length; ++i) {
                    PhpParameterInfo newParameter = newParameters[i];
                    Parameter oldParameter = oldParameters[i];
                    if (!PhpChangeSignatureUsageProcessor.isParameterChanged(changeInfo, newParameter)) continue;
                    PhpChangeSignatureUsageProcessor.updateParameter(newParameter, oldParameter);
                }
            } else {
                LOG.warn("Function parameter list was modified externally, length: " + oldParameters.length + ", expected length: " + newParameters.length);
            }
            shouldFixPhpDoc = true;
        }
        if (shouldFixPhpDoc) {
            PhpChangeSignatureUsageProcessor.fixPhpDoc(function, changeInfo.getMethod() == function);
        }
    }

    public static void fixPhpDoc(@NotNull Function function, boolean isMainMethod) {
        PhpDocComment original2;
        if (function == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(18);
        }
        if ((original2 = function.getDocComment()) == null || !isMainMethod && original2.hasInheritDocTag()) {
            return;
        }
        PhpDocComment newComment = new PhpFunctionDocCommentUpdater(function.getProject(), original2, false).constructUpdatedComment();
        if (newComment != null) {
            original2.replace((PsiElement)newComment);
        }
    }

    private static void updateMethodVisibility(PhpChangeInfo info, Method method) {
        PhpModifierList newModifierList;
        PhpModifier modifier = method.getModifier();
        String newModifiers = modifier.toString().replace(method.getAccess().toString(), info.getNewVisibility());
        PhpPsiElement modifierList = method.getFirstPsiChild();
        if (modifierList instanceof PhpModifierList && (newModifierList = PhpPsiElementFactory.createFromText(method.getProject(), PhpModifierList.class, "class A {\n" + newModifiers + " function f() {}}")) != null) {
            modifierList.replace((PsiElement)newModifierList);
        }
    }

    private static boolean isParameterChanged(@NotNull PhpChangeInfo changeInfo, @NotNull PhpParameterInfo newParameter) {
        String oldType;
        String oldName;
        int oldIndex;
        if (changeInfo == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(19);
        }
        if (newParameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(20);
        }
        if ((oldIndex = newParameter.getOldIndex()) == -1) {
            return true;
        }
        if (newParameter.isPassByRef() != changeInfo.getOldParameterPassByRef(oldIndex)) {
            return true;
        }
        if (newParameter.isVariadic() != changeInfo.getOldParameterVariadic(oldIndex)) {
            return true;
        }
        String newName = newParameter.getName();
        if (!StringUtil.equals((CharSequence)newName, (CharSequence)(oldName = changeInfo.getOldParameterNames(oldIndex)))) {
            return true;
        }
        String newType = newParameter.getTypeText();
        if (!StringUtil.equals((CharSequence)newType, (CharSequence)(oldType = changeInfo.getOldParameterTypes(oldIndex)))) {
            return true;
        }
        String newInitializer = newParameter.getInitializer();
        String oldInitializer = changeInfo.getOldParameterInitializers(oldIndex);
        return !StringUtil.equals((CharSequence)oldInitializer, (CharSequence)newInitializer);
    }

    private static void updateIdentifier(@NotNull Project project, @Nullable PsiElement oldIdentifier, @Nullable String newName) {
        if (project == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(21);
        }
        if (oldIdentifier == null || StringUtil.isEmpty((String)newName)) {
            return;
        }
        PsiElement newIdentifier = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, newName);
        if (newIdentifier != null) {
            oldIdentifier.replace(newIdentifier);
        }
    }

    private static void updateReturnType(@NotNull Project project, @NotNull Function function, @Nullable String newReturnType) {
        PhpReturnType oldReturnType;
        if (project == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(22);
        }
        if (function == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(23);
        }
        if ((oldReturnType = function.getReturnType()) == null) {
            if (newReturnType != null && !newReturnType.isEmpty()) {
                PhpChangeSignatureProcessor.addReturnType(function, newReturnType);
            }
        } else if (newReturnType == null || newReturnType.isEmpty()) {
            function.deleteChildRange(PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.opCOLON), PhpPsiUtil.getChildOfType((PsiElement)function, PhpElementTypes.RETURN_TYPE));
        } else {
            PsiElement newType = PhpPsiElementFactory.createFromText(project, PhpElementTypes.RETURN_TYPE, "function f():" + newReturnType);
            if (newType != null) {
                function.getReturnType().replace(newType);
            }
        }
    }

    private static Parameter createParameter(@NotNull Project project, @NotNull PhpParameterInfo newParameter) {
        if (project == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(24);
        }
        if (newParameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(25);
        }
        String newParameterText = PhpFunctionCodeGenerator.generateParameter(newParameter);
        return PhpPsiElementFactory.createComplexParameter(project, newParameterText);
    }

    private static void updateParameter(@NotNull PhpParameterInfo newParameter, @NotNull Parameter oldParameter) {
        if (newParameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(26);
        }
        if (oldParameter == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(27);
        }
        Parameter newParameterElement = PhpChangeSignatureUsageProcessor.createParameter(oldParameter.getProject(), newParameter);
        oldParameter.replace((PsiElement)newParameterElement);
    }

    private static void updateParameterList(PhpChangeInfo changeInfo, Function baseMethod) {
        PsiElement parameterList = PhpPsiUtil.getChildOfType((PsiElement)baseMethod, PhpElementTypes.PARAMETER_LIST);
        if (parameterList != null) {
            String function = PhpFunctionCodeGenerator.DECLARATION.generate("foo", Arrays.asList(changeInfo.getNewParameters()), "");
            PhpChangeSignatureUsageProcessor.updateParameterList(function, parameterList);
        }
    }

    private static void updateParameterList(String parameterText, @NotNull PsiElement elementToReplace) {
        if (elementToReplace == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(28);
        }
        ParameterList newParameterList = PhpPsiElementFactory.createPhpPsiFromText(elementToReplace.getProject(), ParameterList.class, parameterText);
        elementToReplace.replace((PsiElement)newParameterList);
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        return true;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            PhpChangeSignatureUsageProcessor.$$$reportNull$$$0(29);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibility";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 17: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 20: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameter";
                break;
            }
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParameter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReplace";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveSnapshotProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "accessFromString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkVisibilityConflicts";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleFromClass";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accessFromString";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkParamsUsageAsFunctionCalls";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkParameter";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionDeclaration";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fixPhpDoc";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isParameterChanged";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateIdentifier";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateReturnType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateParameter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterList";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "registerConflictResolvers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class PhpChangeSignatureUsageInfo
    extends UsageInfo {
        protected PhpChangeSignatureUsageInfo(@NotNull PhpPsiElement element) {
            if (element == null) {
                PhpChangeSignatureUsageInfo.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        public void process(PhpChangeInfo changeInfo, boolean beforeMethodChange) {
            if (beforeMethodChange) {
                this.firstStepProcess(changeInfo);
            } else {
                this.secondStepProcess(changeInfo);
            }
        }

        protected abstract void firstStepProcess(PhpChangeInfo var1);

        protected abstract void secondStepProcess(PhpChangeInfo var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$PhpChangeSignatureUsageInfo", "<init>"));
        }
    }

    public static class FunctionCallUsageInfo
    extends PhpChangeSignatureUsageInfo {
        private final boolean isCalledFromPropagatedMethod;
        private final boolean isCalledFromGoalMethod;
        private final int myNewParametersCount;

        public FunctionCallUsageInfo(@NotNull ParameterListOwner parameterOwner, @NotNull PhpChangeInfo changeInfo) {
            if (parameterOwner == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(0);
            }
            if (changeInfo == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(1);
            }
            super((PhpPsiElement)parameterOwner);
            Function parent = this.getParentFunction();
            this.isCalledFromPropagatedMethod = parent != null && changeInfo.isFunctionToPropagation(parent);
            this.isCalledFromGoalMethod = PhpChangeSignatureUsageSearcher.isReferenceFromGoalMethod(parent, changeInfo.getMethod());
            this.myNewParametersCount = changeInfo.getNewParametersCount();
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
        }

        @Override
        protected void secondStepProcess(PhpChangeInfo changeInfo) {
            PsiElement element = this.getElement();
            assert (element instanceof ParameterListOwner);
            this.processUsages(changeInfo, (ParameterListOwner)element);
        }

        private void processUsages(PhpChangeInfo changeInfo, ParameterListOwner function) {
            ParameterList parameterList;
            if (changeInfo.isNameChanged()) {
                PhpChangeSignatureUsageProcessor.updateIdentifier(function.getProject(), PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.IDENTIFIER), changeInfo.getNewName());
            }
            if ((parameterList = function.getParameterList()) == null) {
                return;
            }
            if (changeInfo.isParameterSetOrOrderChanged() || changeInfo.isParameterInitializerChanged()) {
                boolean isVariadic;
                StringBuilder builder = new StringBuilder("foo(");
                PhpParameterInfo[] newParameters = changeInfo.getNewParameters();
                PsiElement[] oldParameters = parameterList.getParameters();
                Parameter[] parentParameters = this.getParentParameterList();
                int newParameterIndex = 0;
                for (int i = 0; i < newParameters.length; ++i) {
                    String parameterContent;
                    PhpParameterInfo newParameter = newParameters[i];
                    int oldIndex = newParameter.getOldIndex();
                    if (oldIndex == -1) {
                        parameterContent = this.getNewParameterContent(newParameter, parentParameters, newParameterIndex);
                        ++newParameterIndex;
                    } else {
                        parameterContent = FunctionCallUsageInfo.getOldParameterContent(newParameter, oldParameters, oldIndex);
                    }
                    if (StringUtil.isEmpty((String)parameterContent) && StringUtil.isEmpty((String)newParameter.getInitializer())) {
                        parameterContent = " ";
                    }
                    FunctionCallUsageInfo.appendParameterContent(parameterContent, i, builder);
                }
                boolean wasVariadic = changeInfo.getOldParametersCount() > 0 && changeInfo.getOldParameterVariadic(changeInfo.getOldParametersCount() - 1);
                boolean bl = isVariadic = newParameters.length > 0 && newParameters[newParameters.length - 1].isVariadic();
                if (!wasVariadic || isVariadic) {
                    for (int i = changeInfo.getOldParametersCount(); i < oldParameters.length; ++i) {
                        FunctionCallUsageInfo.appendParameterContent(oldParameters[i].getText(), i + newParameters.length, builder);
                    }
                }
                builder.append(");");
                PhpChangeSignatureUsageProcessor.updateParameterList(builder.toString(), (PsiElement)parameterList);
            }
        }

        public static void appendParameterContent(@Nullable String parameterContent, int index, StringBuilder builder) {
            if (StringUtil.isNotEmpty((String)parameterContent)) {
                if (index > 0) {
                    builder.append(", ");
                }
                builder.append(parameterContent);
            }
        }

        @Nullable
        protected static String getOldParameterContent(@NotNull PhpParameterInfo newParameter, @NotNull PsiElement[] oldParameters, int oldIndex) {
            if (newParameter == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(2);
            }
            if (oldParameters == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(3);
            }
            if (oldIndex < oldParameters.length) {
                return oldParameters[oldIndex].getText();
            }
            return StringUtil.isNotEmpty((String)newParameter.getInitializer()) ? "" : newParameter.getDefaultValue();
        }

        @Nullable
        protected String getNewParameterContent(@NotNull PhpParameterInfo newParameter, @Nullable Parameter[] parentParameters, int newParameterIndex) {
            if (newParameter == null) {
                FunctionCallUsageInfo.$$$reportNull$$$0(4);
            }
            if (this.isCalledFromGoalMethod) {
                return "$" + newParameter.getName();
            }
            if (this.isCalledFromPropagatedMethod && parentParameters != null) {
                int index = parentParameters.length + newParameterIndex - this.myNewParametersCount;
                return index < 0 || index >= parentParameters.length ? newParameter.getDefaultValue() : "$" + parentParameters[index].getName();
            }
            return newParameter.getDefaultValue();
        }

        @Nullable
        private Function getParentFunction() {
            PsiElement element = this.getElement();
            Object parent = element == null ? null : PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)Function.INSTANCEOF);
            return parent instanceof Function ? (Function)parent : null;
        }

        @Nullable
        protected Parameter[] getParentParameterList() {
            Function function = this.getParentFunction();
            return function == null ? null : function.getParameters();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterOwner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeInfo";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParameter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParameters";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionCallUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOldParameterContent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNewParameterContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FunctionBodyUsageInfo
    extends FunctionDeclarationUsageInfo {
        private final String[] newNames;

        public FunctionBodyUsageInfo(@NotNull Function function, @NotNull PhpChangeInfo changeInfo) {
            if (function == null) {
                FunctionBodyUsageInfo.$$$reportNull$$$0(0);
            }
            if (changeInfo == null) {
                FunctionBodyUsageInfo.$$$reportNull$$$0(1);
            }
            super(function);
            PhpParameterInfo[] newParameters = changeInfo.getNewParameters();
            int oldParametersCount = function.getParameters().length;
            this.newNames = new String[oldParametersCount];
            Arrays.fill(this.newNames, "");
            for (PhpParameterInfo parameterInfo : newParameters) {
                int index = parameterInfo.getOldIndex();
                if (index == -1 || index >= oldParametersCount) continue;
                this.newNames[index] = parameterInfo.getName();
            }
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
            PsiElement element = this.getElement();
            if (!(element instanceof Function)) {
                return;
            }
            Parameter[] parameters = ((Function)element).getParameters();
            assert (parameters.length == this.newNames.length);
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                if (StringUtil.isEmpty((String)this.newNames[i])) continue;
                ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
                for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).findAll()) {
                    if (reference.getElement() == parameter) continue;
                    list.add(new UsageInfo(reference));
                }
                FunctionBodyUsageInfo.renameParameter(parameter, this.newNames[i], list.toArray(UsageInfo.EMPTY_ARRAY));
            }
            super.firstStepProcess(changeInfo);
        }

        private static void renameParameter(Parameter parameter, String newName, UsageInfo[] infos) {
            RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)parameter);
            processor.renameElement((PsiElement)parameter, newName, infos, RefactoringElementListener.DEAF);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "function";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changeInfo";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionBodyUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FunctionDeclarationUsageInfo
    extends PhpChangeSignatureUsageInfo {
        public FunctionDeclarationUsageInfo(@NotNull Function function) {
            if (function == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(0);
            }
            super((PhpPsiElement)function);
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
            PsiElement element = this.getElement();
            assert (element instanceof Function) : "Expected to get function, get " + (element == null ? "null" : element.getClass()) + " instead";
            PhpChangeSignatureUsageProcessor.processFunctionDeclaration(changeInfo, (Function)element);
        }

        @Override
        protected void secondStepProcess(PhpChangeInfo changeInfo) {
            if (changeInfo.isInitializeProperties()) {
                PsiElement element = this.getElement();
                assert (element instanceof Method);
                PhpClass clazz = ((Method)element).getContainingClass();
                if (clazz != null) {
                    Parameter[] parameters = ((Method)element).getParameters();
                    PhpParameterInfo[] newParameters = changeInfo.getNewParameters();
                    ArrayList<Parameter> toInitialize = new ArrayList<Parameter>();
                    for (int i = 0; i < newParameters.length; ++i) {
                        if (newParameters[i].getOldIndex() != -1) continue;
                        toInitialize.add(parameters[i]);
                    }
                    PsiFile file = clazz.getContainingFile();
                    PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
                    String visibilityModifier = phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY.toString();
                    PhpRefactoringUtil.initializeFieldsByParameters(clazz, toInitialize, visibilityModifier);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionDeclarationUsageInfo", "<init>"));
        }
    }

    public static class FunctionPropagationDeclarationUsageInfo
    extends PhpChangeSignatureUsageInfo {
        protected FunctionPropagationDeclarationUsageInfo(@NotNull Function function) {
            if (function == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(0);
            }
            super((PhpPsiElement)function);
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
            PsiElement element = this.getElement();
            assert (element instanceof Function);
            boolean parameterWasAdded = false;
            PsiElement parameterList = PhpPsiUtil.getChildOfType(element, PhpElementTypes.PARAMETER_LIST);
            Set<String> parameterNames = FunctionPropagationDeclarationUsageInfo.fillParameterNames((Function)element);
            for (PhpParameterInfo parameterInfo : changeInfo.getNewParameters()) {
                if (parameterInfo.getOldIndex() != -1) continue;
                Parameter parameter = FunctionPropagationDeclarationUsageInfo.createParameterWithNameConflictResolve(this.getProject(), parameterNames, parameterInfo);
                PhpChangeSignatureProcessor.addParameter(parameterList, parameter);
                parameterWasAdded = true;
            }
            if (parameterWasAdded) {
                PhpChangeSignatureUsageProcessor.fixPhpDoc((Function)element, false);
            }
        }

        private static Set<String> fillParameterNames(Function function) {
            Parameter[] parameters;
            THashSet parameterNames = new THashSet();
            for (Parameter parameter : parameters = function.getParameters()) {
                parameterNames.add(parameter.getName());
            }
            return parameterNames;
        }

        public static Parameter createParameterWithNameConflictResolve(@NotNull Project project, @NotNull Set<String> parameterNames, @NotNull PhpParameterInfo parameterInfo) {
            if (project == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(1);
            }
            if (parameterNames == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(2);
            }
            if (parameterInfo == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(3);
            }
            if (!parameterNames.contains(parameterInfo.getName())) {
                return PhpChangeSignatureUsageProcessor.createParameter(project, parameterInfo);
            }
            PhpParameterInfo newParameter = FunctionPropagationDeclarationUsageInfo.getSuggestedNames(parameterInfo, parameterNames);
            parameterNames.add(newParameter.getName());
            return PhpChangeSignatureUsageProcessor.createParameter(project, newParameter);
        }

        private static PhpParameterInfo getSuggestedNames(@NotNull PhpParameterInfo oldParameter, @NotNull Set<String> parameterNames) {
            if (oldParameter == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(4);
            }
            if (parameterNames == null) {
                FunctionPropagationDeclarationUsageInfo.$$$reportNull$$$0(5);
            }
            int addSuffix = 1;
            String oldName = oldParameter.getName();
            String newName = oldName + addSuffix;
            while (parameterNames.contains(newName)) {
                newName = oldName + ++addSuffix;
            }
            return new PhpParameterInfo(oldParameter.getOldIndex(), newName, oldParameter.getTypeText(), oldParameter.getDefaultValue(), oldParameter.getInitializer(), oldParameter.isPassByRef(), oldParameter.isVariadic());
        }

        @Override
        protected void secondStepProcess(PhpChangeInfo changeInfo) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterNames";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldParameter";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionPropagationDeclarationUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createParameterWithNameConflictResolve";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSuggestedNames";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FunctionPropagationCallUsageInfo
    extends FunctionCallUsageInfo {
        public FunctionPropagationCallUsageInfo(@NotNull ParameterListOwner parameterOwner, @NotNull PhpChangeInfo changeInfo) {
            if (parameterOwner == null) {
                FunctionPropagationCallUsageInfo.$$$reportNull$$$0(0);
            }
            if (changeInfo == null) {
                FunctionPropagationCallUsageInfo.$$$reportNull$$$0(1);
            }
            super(parameterOwner, changeInfo);
        }

        @Override
        protected void firstStepProcess(PhpChangeInfo changeInfo) {
        }

        @Override
        protected void secondStepProcess(PhpChangeInfo changeInfo) {
            PhpParameterInfo[] parameters1;
            PsiElement element = this.getElement();
            assert (element instanceof ParameterListOwner);
            ParameterList parameterList = ((ParameterListOwner)element).getParameterList();
            if (parameterList == null) {
                return;
            }
            StringBuilder builder = new StringBuilder("foo(");
            PsiElement[] parameters = parameterList.getParameters();
            int oldParametersLength = parameters.length;
            for (int i = 0; i < oldParametersLength; ++i) {
                PsiElement parameter = parameters[i];
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(parameter.getText());
            }
            int curIndex = 0;
            Parameter[] parentParameters = this.getParentParameterList();
            for (PhpParameterInfo parameterInfo : parameters1 = changeInfo.getNewParameters()) {
                String parameterContent;
                if (parameterInfo.getOldIndex() != -1 || !StringUtil.isNotEmpty((String)(parameterContent = this.getNewParameterContent(parameterInfo, parentParameters, curIndex)))) continue;
                if (curIndex + oldParametersLength > 0) {
                    builder.append(",");
                }
                builder.append(parameterContent);
                ++curIndex;
            }
            builder.append(");");
            PhpChangeSignatureUsageProcessor.updateParameterList(builder.toString(), (PsiElement)parameterList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameterOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changeInfo";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageProcessor$FunctionPropagationCallUsageInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

