/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.messDetector;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.tools.quality.QualityToolAnnotator;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.QualityToolValidationException;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorBlackList;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorMessageProcessor;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorProjectConfiguration;
import com.jetbrains.php.tools.quality.messDetector.MessDetectorValidationInspection;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessDetectorAnnotator
extends QualityToolAnnotator {
    private static final Logger LOG = Logger.getInstance(MessDetectorAnnotator.class);
    private static final String TEMP_DIRECTORY = "phpmd_temp.tmp";
    static final MessDetectorAnnotator INSTANCE = new MessDetectorAnnotator();

    @Override
    @Nullable
    protected QualityToolConfiguration getConfiguration(@NotNull Project project, @NotNull LocalInspectionTool inspection) {
        if (project == null) {
            MessDetectorAnnotator.$$$reportNull$$$0(0);
        }
        if (inspection == null) {
            MessDetectorAnnotator.$$$reportNull$$$0(1);
        }
        try {
            return MessDetectorProjectConfiguration.getInstance(project).findSelectedConfiguration(project);
        }
        catch (QualityToolValidationException e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    @Override
    @NotNull
    protected String getTemporaryFilesFolder() {
        if (TEMP_DIRECTORY == null) {
            MessDetectorAnnotator.$$$reportNull$$$0(2);
        }
        return TEMP_DIRECTORY;
    }

    @Override
    @NotNull
    protected String getInspectionId() {
        String string = new MessDetectorValidationInspection().getID();
        if (string == null) {
            MessDetectorAnnotator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected void runTool(@NotNull QualityToolMessageProcessor messageProcessor, @NotNull QualityToolAnnotatorInfo annotatorInfo, @NotNull PhpSdkFileTransfer transfer) throws ExecutionException {
        if (messageProcessor == null) {
            MessDetectorAnnotator.$$$reportNull$$$0(4);
        }
        if (annotatorInfo == null) {
            MessDetectorAnnotator.$$$reportNull$$$0(5);
        }
        if (transfer == null) {
            MessDetectorAnnotator.$$$reportNull$$$0(6);
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(annotatorInfo.getFilePath());
        params.add("xml");
        MessDetectorValidationInspection inspection = (MessDetectorValidationInspection)annotatorInfo.getInspection();
        String enabledOptions = inspection.getRuleSetsOption(MessDetectorAnnotator.isRemote(annotatorInfo.getProject(), annotatorInfo.getInterpreterId()));
        if (enabledOptions.isEmpty()) {
            return;
        }
        params.add(enabledOptions);
        MessDetectorBlackList blackList = MessDetectorBlackList.getInstance(annotatorInfo.getProject());
        QualityToolProcessCreator.runToolProcess(annotatorInfo, blackList, messageProcessor, null, transfer, params);
        if (messageProcessor.getInternalErrorMessage() != null) {
            if (annotatorInfo.isOnTheFly()) {
                String message = messageProcessor.getInternalErrorMessage().getMessageText();
                MessDetectorAnnotator.showProcessErrorMessage(annotatorInfo, blackList, message);
            }
            messageProcessor.setFatalError();
        }
    }

    private static boolean isRemote(@Nullable Project project, @Nullable String interpreterId) {
        if (StringUtil.isNotEmpty((String)interpreterId)) {
            PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
            return interpreter != null && interpreter.isRemote();
        }
        return false;
    }

    @Override
    protected QualityToolMessageProcessor createMessageProcessor(@NotNull QualityToolAnnotatorInfo collectedInfo) {
        if (collectedInfo == null) {
            MessDetectorAnnotator.$$$reportNull$$$0(7);
        }
        return new MessDetectorMessageProcessor(collectedInfo.getMaxMessagesPerFile(), collectedInfo);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorAnnotator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatorInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transfer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/messDetector/MessDetectorAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemporaryFilesFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runTool";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMessageProcessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

