/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.incrementalMerge.ui.EditorPlace;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class FontSizeSynchronizer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.FontSizeSynchronizer");
    private final Collection<Editor> myEditors = new HashSet<Editor>();
    private final MyFontSizeListener myFontSizeListener = new MyFontSizeListener();
    private int myLastFontSize = -1;

    public void synchronize(EditorEx editor) {
        LOG.assertTrue(!this.myEditors.contains(editor));
        editor.addPropertyChangeListener(this.myFontSizeListener);
        this.myEditors.add(editor);
        if (this.myLastFontSize != -1) {
            this.myFontSizeListener.updateEditor(editor);
        }
    }

    public void stopSynchronize(EditorEx editor) {
        LOG.assertTrue(this.myEditors.contains(editor));
        editor.removePropertyChangeListener(this.myFontSizeListener);
        this.myEditors.remove(editor);
    }

    public static void attachTo(ArrayList<? extends EditorPlace> editorPlaces) {
        final FontSizeSynchronizer synchronizer = new FontSizeSynchronizer();
        for (EditorPlace editorPlace : editorPlaces) {
            editorPlace.addListener(new EditorPlace.EditorListener(){

                @Override
                public void onEditorCreated(@NotNull EditorPlace place) {
                    if (place == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    synchronizer.synchronize((EditorEx)place.getEditor());
                }

                @Override
                public void onEditorReleased(@NotNull Editor releasedEditor) {
                    if (releasedEditor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    synchronizer.stopSynchronize((EditorEx)releasedEditor);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "place";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "releasedEditor";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/openapi/diff/impl/util/FontSizeSynchronizer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onEditorCreated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onEditorReleased";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            EditorEx editor = (EditorEx)editorPlace.getEditor();
            if (editor == null) continue;
            synchronizer.synchronize(editor);
        }
    }

    private class MyFontSizeListener
    implements PropertyChangeListener {
        private boolean myDuringUpdate = false;

        private MyFontSizeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate) {
                return;
            }
            if (!"fontSize".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            FontSizeSynchronizer.this.myLastFontSize = (Integer)evt.getNewValue();
            for (Editor editor : FontSizeSynchronizer.this.myEditors) {
                if (editor == null || editor == evt.getSource()) continue;
                this.updateEditor((EditorEx)editor);
            }
        }

        public void updateEditor(EditorEx editor) {
            try {
                this.myDuringUpdate = true;
                editor.setFontSize(FontSizeSynchronizer.this.myLastFontSize);
            }
            finally {
                this.myDuringUpdate = false;
            }
        }
    }
}

