/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SdkListCellRenderer
extends ColoredListCellRenderer<Sdk> {
    private final String myNullText;
    private final boolean myShowHomePath;

    public SdkListCellRenderer(@NotNull String nullText) {
        if (nullText == null) {
            SdkListCellRenderer.$$$reportNull$$$0(0);
        }
        this(nullText, false);
    }

    public SdkListCellRenderer(@NotNull String nullText, boolean showHomePath) {
        if (nullText == null) {
            SdkListCellRenderer.$$$reportNull$$$0(1);
        }
        this.myNullText = nullText;
        this.myShowHomePath = showHomePath;
    }

    protected void customizeCellRenderer(@NotNull JList<? extends Sdk> list2, Sdk sdk, int index, boolean selected, boolean hasFocus) {
        if (list2 == null) {
            SdkListCellRenderer.$$$reportNull$$$0(2);
        }
        if (sdk != null) {
            this.setIcon(this.getSdkIcon(sdk));
            this.append(sdk.getName());
            if (this.myShowHomePath) {
                this.append(" (" + FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)sdk.getHomePath())) + ")", selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else {
            this.append(this.myNullText);
        }
    }

    protected Icon getSdkIcon(Sdk sdk) {
        return ((SdkType)sdk.getSdkType()).getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/projectRoots/impl/SdkListCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

