/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import a.b.lb;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLineMarkerRenderer;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.history.FileRevisionTimestampComparator;
import com.intellij.history.LocalHistory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntIntHashMap;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SrcFileAnnotator
implements Disposable {
    private static final Logger b;
    public static final Key<List<RangeHighlighter>> COVERAGE_HIGHLIGHTERS;
    private static final Key<DocumentListener> c;
    public static final Key<Map<FileEditor, EditorNotificationPanel>> NOTIFICATION_PANELS;
    private PsiFile i;
    private Editor g;
    private Document e;
    private final Project h;
    private SoftReference<TIntIntHashMap> d;
    private SoftReference<TIntIntHashMap> f;
    private SoftReference<byte[]> k;
    private static final Object a;
    private final Alarm j = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private static final long l;

    public SrcFileAnnotator(PsiFile file, Editor editor) {
        this.i = file;
        this.g = editor;
        this.h = file.getProject();
        this.e = this.g.getDocument();
    }

    public void hideCoverageData() {
        RangeHighlighter rangeHighlighter;
        Object object;
        Editor editor = this.g;
        PsiFile psiFile = this.i;
        Document document = this.e;
        if (editor == null || editor.isDisposed() || psiFile == null || document == null) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.h);
        List list2 = (List)editor.getUserData(COVERAGE_HIGHLIGHTERS);
        if (list2 != null) {
            object = list2.iterator();
            while (object.hasNext()) {
                rangeHighlighter = (RangeHighlighter)object.next();
                ApplicationManager.getApplication().invokeLater(() -> rangeHighlighter.dispose());
            }
            editor.putUserData(COVERAGE_HIGHLIGHTERS, null);
        }
        if ((object = (Map)psiFile.getCopyableUserData(NOTIFICATION_PANELS)) != null) {
            rangeHighlighter = SrcFileAnnotator.a(psiFile);
            boolean bl2 = !fileEditorManager.isFileOpen((VirtualFile)rangeHighlighter);
            psiFile.putCopyableUserData(NOTIFICATION_PANELS, null);
            for (FileEditor fileEditor : object.keySet()) {
                if (!bl2 && !this.a(fileEditor)) continue;
                fileEditorManager.removeTopComponent(fileEditor, (JComponent)object.get(fileEditor));
            }
        }
        if ((rangeHighlighter = (DocumentListener)editor.getUserData(c)) != null) {
            document.removeDocumentListener((DocumentListener)rangeHighlighter);
            editor.putUserData(c, null);
        }
    }

    @NotNull
    private static String[] a(@NotNull byte[] byArray, VirtualFile virtualFile) {
        if (byArray == null) {
            SrcFileAnnotator.a(0);
        }
        String string = LoadTextUtil.getTextByBinaryPresentation((byte[])byArray, (VirtualFile)virtualFile, (boolean)false, (boolean)false).toString();
        String[] stringArray = LineTokenizer.tokenize((CharSequence)string, (boolean)false);
        if (stringArray == null) {
            SrcFileAnnotator.a(1);
        }
        return stringArray;
    }

    @NotNull
    private static String[] a(Document document) {
        Ref ref = new Ref();
        Runnable runnable = () -> {
            int n2 = document.getLineCount();
            String[] stringArray = new String[n2];
            CharSequence charSequence = document.getCharsSequence();
            for (int i10 = 0; i10 < n2; ++i10) {
                stringArray[i10] = charSequence.subSequence(document.getLineStartOffset(i10), document.getLineEndOffset(i10)).toString();
            }
            ref.set((Object)stringArray);
        };
        ApplicationManager.getApplication().runReadAction(runnable);
        String[] stringArray = (String[])ref.get();
        if (stringArray == null) {
            SrcFileAnnotator.a(2);
        }
        return stringArray;
    }

    private static TIntIntHashMap a(Diff.Change change, int n2) {
        int n3;
        TIntIntHashMap tIntIntHashMap = new TIntIntHashMap();
        int n4 = 0;
        int n5 = 0;
        while (change != null) {
            for (n3 = 0; n3 < change.line0 - n4; ++n3) {
                tIntIntHashMap.put(n4 + n3, n5 + n3);
            }
            n4 = change.line0 + change.deleted;
            n5 = change.line1 + change.inserted;
            change = change.link;
        }
        for (n3 = n4; n3 < n2; ++n3) {
            tIntIntHashMap.put(n3, n5 + n3 - n4);
        }
        return tIntIntHashMap;
    }

    @Nullable
    private TIntIntHashMap b(long l3, MyEditorBean myEditorBean) {
        if (this.f == null) {
            this.f = this.a(l3, true, myEditorBean);
            if (this.f == null) {
                return null;
            }
        }
        return (TIntIntHashMap)this.f.get();
    }

    @Nullable
    private TIntIntHashMap a(long l3, MyEditorBean myEditorBean) {
        if (this.d == null) {
            this.d = this.a(l3, false, myEditorBean);
            if (this.d == null) {
                return null;
            }
        }
        return (TIntIntHashMap)this.d.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private SoftReference<TIntIntHashMap> a(final long l3, boolean bl2, MyEditorBean myEditorBean) {
        VirtualFile virtualFile = myEditorBean.getVFile();
        if (this.k == null && ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        String[] stringArray = a;
        synchronized (a) {
            Diff.Change change;
            Object[] objectArray;
            LocalHistory localHistory;
            if (this.k == null) {
                localHistory = LocalHistory.getInstance();
                objectArray = localHistory.getByteContent(virtualFile, new FileRevisionTimestampComparator(){

                    public boolean isSuitable(long revisionTimestamp) {
                        return revisionTimestamp < l3;
                    }
                });
                if (objectArray == null && virtualFile.getTimeStamp() > l3) {
                    objectArray = this.a(l3, virtualFile);
                }
                this.k = new SoftReference((Object)objectArray);
            }
            byte[] byArray = (byte[])this.k.get();
            // ** MonitorExit[var7_5] (shouldn't be in output)
            if (byArray == null) {
                return null;
            }
            stringArray = SrcFileAnnotator.a(byArray, virtualFile);
            localHistory = myEditorBean.getDocument();
            if (localHistory == null) {
                return null;
            }
            objectArray = SrcFileAnnotator.a((Document)localHistory);
            Object[] objectArray2 = bl2 ? stringArray : (Object[])objectArray;
            Object[] objectArray3 = bl2 ? objectArray : (byte[])stringArray;
            try {
                change = Diff.buildChanges((Object[])objectArray2, (Object[])objectArray3);
            }
            catch (FilesTooBigForDiffException filesTooBigForDiffException) {
                b.info((Throwable)filesTooBigForDiffException);
                return null;
            }
            return new SoftReference((Object)SrcFileAnnotator.a(change, objectArray2.length));
        }
    }

    @Nullable
    private byte[] a(long l3, VirtualFile virtualFile) {
        try {
            AbstractVcs abstractVcs = VcsUtil.getVcsFor((Project)this.h, (VirtualFile)virtualFile);
            if (abstractVcs == null) {
                return null;
            }
            VcsHistoryProvider vcsHistoryProvider = abstractVcs.getVcsHistoryProvider();
            if (vcsHistoryProvider == null) {
                return null;
            }
            FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(virtualFile);
            VcsHistorySession vcsHistorySession = vcsHistoryProvider.createSessionFor(filePath);
            if (vcsHistorySession == null) {
                return null;
            }
            List list2 = vcsHistorySession.getRevisionList();
            if (list2 != null) {
                for (VcsFileRevision vcsFileRevision : list2) {
                    Date date = vcsFileRevision.getRevisionDate();
                    if (date == null) {
                        return null;
                    }
                    if (date.getTime() >= l3) continue;
                    return vcsFileRevision.loadContent();
                }
            }
        }
        catch (Exception exception) {
            b.info((Throwable)exception);
            return null;
        }
        return null;
    }

    public void showCoverageInformation(final CoverageSuitesBundle suite) {
        TIntIntHashMap tIntIntHashMap;
        long l3 = l ^ 0x3AC0C8CDED5FL;
        final PsiFile psiFile = this.i;
        final Editor editor = this.g;
        final Document document = this.e;
        if (editor == null || psiFile == null || document == null) {
            return;
        }
        VirtualFile virtualFile = SrcFileAnnotator.a(psiFile);
        if (virtualFile == null || !virtualFile.isValid()) {
            return;
        }
        final MyEditorBean myEditorBean = new MyEditorBean(editor, virtualFile, document);
        final MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document, (Project)this.h, (boolean)true);
        final ArrayList arrayList = new ArrayList();
        final ProjectData projectData = suite.getCoverageData();
        if (projectData == null) {
            this.a(suite);
            return;
        }
        final CoverageEngine coverageEngine = suite.getCoverageEngine();
        Set<String> set = coverageEngine.getQualifiedNames(psiFile);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.h).getFileIndex();
        long l4 = virtualFile.getTimeStamp();
        long l5 = suite.getLastCoverageTimeStamp();
        if (coverageEngine.isInLibraryClasses(this.h, virtualFile)) {
            return;
        }
        if (projectFileIndex.isInLibrarySource(virtualFile)) {
            if (l4 > l5) {
                this.a(CodeInsightBundle.message((String)"coverage.data.outdated", (Object[])new Object[0]));
                return;
            }
            tIntIntHashMap = null;
        } else {
            tIntIntHashMap = this.b(l5, myEditorBean);
            if (tIntIntHashMap == null && l4 > l5 && SrcFileAnnotator.a(projectData, set)) {
                this.a(CodeInsightBundle.message((String)"coverage.data.outdated", (Object[])new Object[0]));
                return;
            }
        }
        if (editor.getUserData(COVERAGE_HIGHLIGHTERS) != null) {
            return;
        }
        Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile));
        if (module != null && coverageEngine.recompileProjectAndRerunAction(module, suite, () -> CoverageDataManager.getInstance(this.h).chooseSuitesBundle(suite))) {
            return;
        }
        Set<File> set2 = coverageEngine.getCorrespondingOutputFiles(psiFile, module, suite);
        final boolean bl2 = CoverageDataManager.getInstance(this.h).isSubCoverageActive();
        final boolean bl3 = suite.isCoverageByTestApplicable() && (!bl2 || !suite.isCoverageByTestEnabled());
        final TreeMap treeMap = new TreeMap();
        final TreeMap treeMap2 = new TreeMap();
        final TreeMap treeMap3 = new TreeMap();
        class HighlightersCollector {
            HighlightersCollector() {
            }

            private void a(File file, String string) {
                ClassData classData = projectData.getClassData(string);
                if (classData != null) {
                    Object[] objectArray = classData.getLines();
                    if (objectArray != null) {
                        Object[] objectArray2;
                        for (Object object : objectArray2 = coverageEngine.postProcessExecutableLines(objectArray, editor)) {
                            int n2;
                            if (!(object instanceof LineData)) continue;
                            int n3 = ((LineData)object).getLineNumber() - 1;
                            if (tIntIntHashMap != null) {
                                if (!tIntIntHashMap.contains(n3)) continue;
                                n2 = tIntIntHashMap.get(n3);
                            } else {
                                n2 = n3;
                            }
                            if (coverageEngine.isGeneratedCode(SrcFileAnnotator.this.h, string, object)) continue;
                            treeMap.put(n3, (LineData)object);
                            treeMap2.put(n3, objectArray2);
                            treeMap3.put(n3, string);
                            ApplicationManager.getApplication().invokeLater(() -> {
                                if (n2 >= document.getLineCount()) {
                                    return;
                                }
                                if (myEditorBean.isDisposed()) {
                                    return;
                                }
                                RangeHighlighter rangeHighlighter = SrcFileAnnotator.this.a(suite.getLastCoverageTimeStamp(), markupModel, bl3, treeMap, string, n3, n2, suite, objectArray2, myEditorBean);
                                arrayList.add(rangeHighlighter);
                            });
                        }
                    }
                } else if (file != null && !bl2 && coverageEngine.includeUntouchedFileInCoverage(string, file, psiFile, suite)) {
                    SrcFileAnnotator.this.a(file, arrayList, markupModel, treeMap, bl3, myEditorBean);
                }
            }
        }
        HighlightersCollector highlightersCollector = new HighlightersCollector();
        if (!set2.isEmpty()) {
            for (File file : set2) {
                String string = coverageEngine.getQualifiedName(file, psiFile);
                if (string == null) continue;
                highlightersCollector.a(file, string);
            }
        } else {
            for (String string : set) {
                highlightersCollector.a(null, string);
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!myEditorBean.isDisposed() && arrayList.size() > 0) {
                editor.putUserData(COVERAGE_HIGHLIGHTERS, (Object)arrayList);
            }
        });
        DocumentListener documentListener = new DocumentListener(){
            private static final long a = lb.a(6856556075352793609L, 5971072926040893059L, MethodHandles.lookup().lookupClass()).a(125924807381440L);

            public void documentChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                SrcFileAnnotator.this.d = null;
                SrcFileAnnotator.this.f = null;
                ArrayList arrayList = (ArrayList)editor.getUserData(COVERAGE_HIGHLIGHTERS);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                int n2 = e10.getOffset();
                int n3 = document.getLineNumber(n2);
                int n4 = document.getLineNumber(n2 + e10.getNewLength());
                TextRange textRange = new TextRange(document.getLineStartOffset(n3), document.getLineEndOffset(n4));
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    RangeHighlighter rangeHighlighter = (RangeHighlighter)object.next();
                    if (rangeHighlighter.isValid() && !TextRange.create((Segment)rangeHighlighter).intersects(textRange)) continue;
                    rangeHighlighter.dispose();
                    object.remove();
                }
                object = arrayList;
                SrcFileAnnotator.this.j.cancelAllRequests();
                if (!SrcFileAnnotator.this.j.isDisposed()) {
                    SrcFileAnnotator.this.j.addRequest(() -> this.a(suite, myEditorBean, n3, n4, treeMap, markupModel, bl3, treeMap3, treeMap2, (List)object, editor), 100);
                }
            }

            private /* synthetic */ void a(CoverageSuitesBundle coverageSuitesBundle, MyEditorBean myEditorBean2, int n2, int n3, TreeMap treeMap4, MarkupModel markupModel2, boolean bl2, TreeMap treeMap22, TreeMap treeMap32, List list2, Editor editor2) {
                TIntIntHashMap tIntIntHashMap = SrcFileAnnotator.this.a(coverageSuitesBundle.getLastCoverageTimeStamp(), myEditorBean2);
                if (tIntIntHashMap != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (myEditorBean2.isDisposed()) {
                            return;
                        }
                        for (int i10 = n2; i10 <= n3; ++i10) {
                            int n4 = tIntIntHashMap.get(i10);
                            LineData lineData = (LineData)treeMap4.get(n4);
                            if (lineData == null) continue;
                            RangeHighlighter rangeHighlighter = SrcFileAnnotator.this.a(coverageSuitesBundle.getLastCoverageTimeStamp(), markupModel2, bl2, treeMap4, (String)treeMap22.get(n4), n4, i10, coverageSuitesBundle, (Object[])treeMap32.get(n4), myEditorBean2);
                            list2.add(rangeHighlighter);
                        }
                        editor2.putUserData(COVERAGE_HIGHLIGHTERS, (Object)(list2.size() > 0 ? list2 : null));
                    });
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l3 = a ^ 0x5DB3E0C89B27L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/SrcFileAnnotator$2", "documentChanged"));
            }
        };
        document.addDocumentListener(documentListener);
        editor.putUserData(c, (Object)documentListener);
    }

    private static boolean a(ProjectData projectData, Set<String> set) {
        for (String string : set) {
            if (projectData.getClassData(string) == null) continue;
            return true;
        }
        return false;
    }

    private RangeHighlighter a(long l3, MarkupModel markupModel, boolean bl2, TreeMap<Integer, LineData> treeMap, @Nullable String string, int n3, int n4, @NotNull CoverageSuitesBundle coverageSuitesBundle, Object[] objectArray, @NotNull MyEditorBean myEditorBean) {
        LineData lineData;
        if (coverageSuitesBundle == null) {
            SrcFileAnnotator.a(3);
        }
        if (myEditorBean == null) {
            SrcFileAnnotator.a(4);
        }
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes textAttributes = editorColorsScheme.getAttributes(CoverageLineMarkerRenderer.getAttributesKey(n3, treeMap));
        TextAttributes textAttributes2 = null;
        if (textAttributes.getBackgroundColor() != null) {
            textAttributes2 = textAttributes;
        }
        Document document = myEditorBean.getDocument();
        Editor editor = myEditorBean.getEditor();
        int n5 = document.getLineStartOffset(n4);
        int n6 = document.getLineEndOffset(n4);
        RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(n5, n6, 5999, textAttributes2, HighlighterTargetArea.LINES_IN_RANGE);
        Function function = n2 -> {
            if (myEditorBean == null) {
                SrcFileAnnotator.a(9);
            }
            if (editor == null) {
                return -1;
            }
            TIntIntHashMap tIntIntHashMap = this.a(l3, myEditorBean);
            return tIntIntHashMap != null ? tIntIntHashMap.get(n2.intValue()) : n2.intValue();
        };
        Function function2 = n2 -> {
            if (myEditorBean == null) {
                SrcFileAnnotator.a(8);
            }
            if (editor == null) {
                return -1;
            }
            TIntIntHashMap tIntIntHashMap = this.b(l3, myEditorBean);
            return tIntIntHashMap != null ? tIntIntHashMap.get(n2.intValue()) : n2.intValue();
        };
        LineMarkerRendererWithErrorStripe lineMarkerRendererWithErrorStripe = coverageSuitesBundle.getLineMarkerRenderer(n3, string, treeMap, bl2, coverageSuitesBundle, (Function<Integer, Integer>)function, (Function<Integer, Integer>)function2, CoverageDataManager.getInstance(this.h).isSubCoverageActive());
        rangeHighlighter.setLineMarkerRenderer((LineMarkerRenderer)lineMarkerRendererWithErrorStripe);
        LineData lineData2 = lineData = string != null ? (LineData)objectArray[n3 + 1] : null;
        if (lineData != null && lineData.getStatus() == 0) {
            rangeHighlighter.setErrorStripeMarkColor(lineMarkerRendererWithErrorStripe.getErrorStripeColor(editor));
            rangeHighlighter.setThinErrorStripeMark(true);
            rangeHighlighter.setGreedyToLeft(true);
            rangeHighlighter.setGreedyToRight(true);
        }
        return rangeHighlighter;
    }

    private void a(final String string) {
        Editor editor = this.g;
        PsiFile psiFile = this.i;
        ApplicationManager.getApplication().invokeLater(() -> {
            FileEditor[] fileEditorArray;
            long l3 = l ^ 0x143D29358B4EL;
            if (editor == null || editor.isDisposed() || psiFile == null) {
                return;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.h);
            VirtualFile virtualFile = psiFile.getVirtualFile();
            assert (virtualFile != null);
            HashMap<FileEditor, 3> hashMap = (HashMap<FileEditor, 3>)psiFile.getCopyableUserData(NOTIFICATION_PANELS);
            if (hashMap == null) {
                hashMap = new HashMap<FileEditor, 3>();
                psiFile.putCopyableUserData(NOTIFICATION_PANELS, hashMap);
            }
            for (FileEditor fileEditor : fileEditorArray = fileEditorManager.getAllEditors(virtualFile)) {
                if (!this.a(fileEditor)) continue;
                EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel(){
                    {
                        this.myLabel.setIcon(AllIcons.General.ExclMark);
                        this.myLabel.setText(string);
                    }
                };
                editorNotificationPanel.createActionLabel("Close", () -> fileEditorManager.removeTopComponent(fileEditor, (JComponent)editorNotificationPanel));
                hashMap.put(fileEditor, editorNotificationPanel);
                fileEditorManager.addTopComponent(fileEditor, (JComponent)editorNotificationPanel);
                break;
            }
        });
    }

    private boolean a(FileEditor fileEditor) {
        return fileEditor instanceof TextEditor && ((TextEditor)fileEditor).getEditor() == this.g;
    }

    private void a(File file, List<RangeHighlighter> list2, MarkupModel markupModel, TreeMap<Integer, LineData> treeMap, boolean bl2, @NotNull MyEditorBean myEditorBean) {
        TIntIntHashMap tIntIntHashMap;
        CoverageSuitesBundle coverageSuitesBundle;
        if (myEditorBean == null) {
            SrcFileAnnotator.a(5);
        }
        if ((coverageSuitesBundle = CoverageDataManager.getInstance(this.h).getCurrentSuitesBundle()) == null) {
            return;
        }
        Document document = myEditorBean.getDocument();
        VirtualFile virtualFile = myEditorBean.getVFile();
        if (file.lastModified() < virtualFile.getTimeStamp()) {
            tIntIntHashMap = this.b(file.lastModified(), myEditorBean);
            if (tIntIntHashMap == null) {
                return;
            }
        } else {
            tIntIntHashMap = null;
        }
        List<Integer> list3 = coverageSuitesBundle.getCoverageEngine().collectSrcLinesForUntouchedFile(file, coverageSuitesBundle);
        int n2 = document.getLineCount();
        if (list3 == null) {
            for (int i10 = 0; i10 < n2; ++i10) {
                this.a(file, list2, markupModel, treeMap, bl2, coverageSuitesBundle, i10, i10, myEditorBean);
            }
        } else {
            for (int n3 : list3) {
                if (n3 >= n2) continue;
                int n4 = tIntIntHashMap != null ? tIntIntHashMap.get(n3) : n3;
                this.a(file, list2, markupModel, treeMap, bl2, coverageSuitesBundle, n3, n4, myEditorBean);
            }
        }
    }

    private void a(File file, List<RangeHighlighter> list2, MarkupModel markupModel, TreeMap<Integer, LineData> treeMap, boolean bl2, CoverageSuitesBundle coverageSuitesBundle, int n2, int n3, @NotNull MyEditorBean myEditorBean) {
        if (myEditorBean == null) {
            SrcFileAnnotator.a(6);
        }
        treeMap.put(n3, null);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (myEditorBean == null) {
                SrcFileAnnotator.a(7);
            }
            if (myEditorBean.isDisposed()) {
                return;
            }
            RangeHighlighter rangeHighlighter = this.a(file.lastModified(), markupModel, bl2, treeMap, null, n2, n3, coverageSuitesBundle, null, myEditorBean);
            list2.add(rangeHighlighter);
        });
    }

    private static VirtualFile a(PsiFile psiFile) {
        VirtualFile virtualFile = psiFile.getVirtualFile();
        b.assertTrue(virtualFile != null);
        return virtualFile;
    }

    private void a(CoverageSuitesBundle coverageSuitesBundle) {
        long l3 = l ^ 0x662B3E5A0F24L;
        this.a(CodeInsightBundle.message((String)"coverage.data.not.found", (Object[])new Object[0]));
        for (CoverageSuite coverageSuite : coverageSuitesBundle.getSuites()) {
            CoverageDataManager.getInstance(this.h).removeCoverageSuite(coverageSuite);
        }
    }

    public void dispose() {
        this.hideCoverageData();
        this.g = null;
        this.e = null;
        this.i = null;
    }

    static {
        l = lb.a(5363342825806230749L, -1412859419326085135L, MethodHandles.lookup().lookupClass()).a(278099562410132L);
        long l3 = l ^ 0x48E065312F0CL;
        b = Logger.getInstance((String)"#com.intellij.coverage.SrcFileAnnotator");
        COVERAGE_HIGHLIGHTERS = Key.create((String)"COVERAGE_HIGHLIGHTERS");
        c = Key.create((String)"COVERAGE_DOCUMENT_LISTENER");
        NOTIFICATION_PANELS = Key.create((String)"NOTIFICATION_PANELS");
        a = new Object();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l3 = l ^ 0x4375B3E12515L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldContent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/SrcFileAnnotator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageSuite";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorBean";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/SrcFileAnnotator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoveredLines";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpToDateLines";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCoveredLines";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRangeHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectNonCoveredFileInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addHighlighter$9";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRangeHighlighter$6";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRangeHighlighter$5";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyEditorBean {
        private final Editor c;
        private final VirtualFile b;
        private final Document a;

        MyEditorBean(Editor editor, VirtualFile VFile, Document document) {
            this.c = editor;
            this.b = VFile;
            this.a = document;
        }

        public boolean isDisposed() {
            return this.c == null || this.c.isDisposed() || this.b == null || this.a == null;
        }

        public Document getDocument() {
            return this.a;
        }

        public Editor getEditor() {
            return this.c;
        }

        public VirtualFile getVFile() {
            return this.b;
        }
    }
}

