/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.util;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u0004\u0018\u0001H\u0004\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00040\fH\u0007\u00a2\u0006\u0002\u0010\rJ:\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000f\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000f\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\nH\u0007JF\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00040\n2\u0018\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u000f\u0012\u0004\u0012\u00020\u00130\u0015H\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader;", "", "()V", "find", "T", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "pagesRequest", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "predicate", "Ljava/util/function/Predicate;", "(Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lcom/intellij/openapi/progress/ProgressIndicator;Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;Ljava/util/function/Predicate;)Ljava/lang/Object;", "load", "", "maximum", "", "loadAll", "", "pageItemsConsumer", "Lkotlin/Function1;", "Request", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubApiPagesLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiPagesLoader.kt\norg/jetbrains/plugins/github/api/util/GithubApiPagesLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class GithubApiPagesLoader {
    @NotNull
    public static final GithubApiPagesLoader INSTANCE = new GithubApiPagesLoader();

    private GithubApiPagesLoader() {
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> loadAll(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull Request<T> pagesRequest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(pagesRequest, (String)"pagesRequest");
        List result = new ArrayList();
        GithubApiPagesLoader.loadAll(executor, indicator, pagesRequest, (Function1)new Function1<List<? extends T>, Unit>(result){
            final /* synthetic */ List<T> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull List<? extends T> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$result.addAll((Collection)it);
            }
        });
        return result;
    }

    @JvmStatic
    public static final <T> void loadAll(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull Request<T> pagesRequest, @NotNull Function1<? super List<? extends T>, Unit> pageItemsConsumer2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(pagesRequest, (String)"pagesRequest");
        Intrinsics.checkNotNullParameter(pageItemsConsumer2, (String)"pageItemsConsumer");
        GithubApiRequest<GithubResponsePage<T>> request = pagesRequest.getInitialRequest();
        while (request != null) {
            String string;
            GithubResponsePage<T> page = executor.execute(indicator, request);
            pageItemsConsumer2.invoke(page.getItems());
            request = page.getNextLink() != null ? (GithubApiRequest)pagesRequest.getUrlRequestProvider().invoke((Object)string) : null;
        }
    }

    @JvmStatic
    @Nullable
    public static final <T> T find(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull Request<T> pagesRequest, @NotNull Predicate<T> predicate) throws IOException {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(pagesRequest, (String)"pagesRequest");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        GithubApiRequest<GithubResponsePage<T>> request = pagesRequest.getInitialRequest();
        while (request != null) {
            String string;
            T t;
            GithubResponsePage<T> page;
            block3: {
                T t2;
                page = executor.execute(indicator, request);
                Iterable iterable = page.getItems();
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object t3;
                    Object it = t3 = iterator.next();
                    boolean bl = false;
                    if (!predicate.test(it)) continue;
                    t2 = t3;
                    break block3;
                }
                t2 = t = null;
            }
            if (t != null) {
                T it = t;
                boolean bl = false;
                return it;
            }
            request = page.getNextLink() != null ? (GithubApiRequest)pagesRequest.getUrlRequestProvider().invoke((Object)string) : null;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final <T> List<T> load(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull Request<T> pagesRequest, int maximum) throws IOException {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(pagesRequest, (String)"pagesRequest");
        List result = new ArrayList();
        GithubApiRequest<GithubResponsePage<T>> request = pagesRequest.getInitialRequest();
        while (request != null) {
            String string;
            GithubResponsePage<T> page = executor.execute(indicator, request);
            for (T item : page.getItems()) {
                result.add(item);
                if (result.size() != maximum) continue;
                return result;
            }
            request = page.getNextLink() != null ? (GithubApiRequest)pagesRequest.getUrlRequestProvider().invoke((Object)string) : null;
        }
        return result;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B9\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00040\u0007\u00a2\u0006\u0002\u0010\tR\u001d\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR)\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "T", "", "initialRequest", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "urlRequestProvider", "Lkotlin/Function1;", "", "(Lorg/jetbrains/plugins/github/api/GithubApiRequest;Lkotlin/jvm/functions/Function1;)V", "getInitialRequest", "()Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "getUrlRequestProvider", "()Lkotlin/jvm/functions/Function1;", "intellij.vcs.github"})
    public static final class Request<T> {
        @NotNull
        private final GithubApiRequest<GithubResponsePage<T>> initialRequest;
        @NotNull
        private final Function1<String, GithubApiRequest<GithubResponsePage<T>>> urlRequestProvider;

        public Request(@NotNull GithubApiRequest<GithubResponsePage<T>> initialRequest, @NotNull Function1<? super String, ? extends GithubApiRequest<GithubResponsePage<T>>> urlRequestProvider) {
            Intrinsics.checkNotNullParameter(initialRequest, (String)"initialRequest");
            Intrinsics.checkNotNullParameter(urlRequestProvider, (String)"urlRequestProvider");
            this.initialRequest = initialRequest;
            this.urlRequestProvider = urlRequestProvider;
        }

        @NotNull
        public final GithubApiRequest<GithubResponsePage<T>> getInitialRequest() {
            return this.initialRequest;
        }

        @NotNull
        public final Function1<String, GithubApiRequest<GithubResponsePage<T>>> getUrlRequestProvider() {
            return this.urlRequestProvider;
        }
    }
}

