/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import git4idea.log.GitRefManager;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/BranchTooltipDescriptor;", "", "name", "", "color", "Ljava/awt/Color;", "(Ljava/lang/String;Ljava/awt/Color;)V", "getColor", "()Ljava/awt/Color;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.vcs.github"})
public final class BranchTooltipDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Color color;
    @NotNull
    private static final JBColor PR_BRANCH_COLOR = new JBColor(new Color(0xF6E6E6E), new Color(263172531));

    public BranchTooltipDescriptor(@NlsSafe @NotNull String name, @NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        this.name = name;
        this.color = color2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Color component2() {
        return this.color;
    }

    @NotNull
    public final BranchTooltipDescriptor copy(@NlsSafe @NotNull String name, @NotNull Color color2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        return new BranchTooltipDescriptor(name, color2);
    }

    public static /* synthetic */ BranchTooltipDescriptor copy$default(BranchTooltipDescriptor branchTooltipDescriptor, String string, Color color2, int n, Object object) {
        if ((n & 1) != 0) {
            string = branchTooltipDescriptor.name;
        }
        if ((n & 2) != 0) {
            color2 = branchTooltipDescriptor.color;
        }
        return branchTooltipDescriptor.copy(string, color2);
    }

    @NotNull
    public String toString() {
        return "BranchTooltipDescriptor(name=" + this.name + ", color=" + this.color + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.color.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BranchTooltipDescriptor)) {
            return false;
        }
        BranchTooltipDescriptor branchTooltipDescriptor = (BranchTooltipDescriptor)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)branchTooltipDescriptor.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.color, (Object)branchTooltipDescriptor.color);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/BranchTooltipDescriptor$Companion;", "", "()V", "PR_BRANCH_COLOR", "Lcom/intellij/ui/JBColor;", "head", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/BranchTooltipDescriptor;", "localBranch", "branchName", "", "prBranch", "remoteBranch", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BranchTooltipDescriptor head() {
            Color color2 = GitRefManager.HEAD.getBackgroundColor();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"HEAD.backgroundColor");
            return new BranchTooltipDescriptor("HEAD", color2);
        }

        @NotNull
        public final BranchTooltipDescriptor localBranch(@NotNull String branchName) {
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            Color color2 = GitRefManager.LOCAL_BRANCH.getBackgroundColor();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"LOCAL_BRANCH.backgroundColor");
            return new BranchTooltipDescriptor(branchName, color2);
        }

        @NotNull
        public final BranchTooltipDescriptor remoteBranch(@NotNull String branchName) {
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            Color color2 = GitRefManager.REMOTE_BRANCH.getBackgroundColor();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"REMOTE_BRANCH.backgroundColor");
            return new BranchTooltipDescriptor(branchName, color2);
        }

        @NotNull
        public final BranchTooltipDescriptor prBranch(@NotNull String branchName) {
            Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
            return new BranchTooltipDescriptor(branchName, (Color)PR_BRANCH_COLOR);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

