/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.util.ProgressIndicatorsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0005Rn\u0010\u0003\u001ab\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\b \u0006*\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u0007 \u0006*0\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010\b \u0006*\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader;", "Lcom/intellij/openapi/Disposable;", "()V", "avatarCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CompletableFuture;", "Ljava/awt/Image;", "indicatorProvider", "Lcom/intellij/collaboration/util/ProgressIndicatorsProvider;", "dispose", "", "loadAndDownscale", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "url", "maximumSize", "", "requestAvatar", "Companion", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nCachingGHUserAvatarLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingGHUserAvatarLoader.kt\norg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n10#2:72\n*S KotlinDebug\n*F\n+ 1 CachingGHUserAvatarLoader.kt\norg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader\n*L\n61#1:72\n*E\n"})
public final class CachingGHUserAvatarLoader
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressIndicatorsProvider indicatorProvider;
    private final Cache<String, CompletableFuture<Image>> avatarCache;
    @NotNull
    private static final Logger LOG;
    private static final int MAXIMUM_ICON_SIZE = 40;
    private static final int STORED_IMAGE_SIZE = 240;

    /*
     * WARNING - void declaration
     */
    public CachingGHUserAvatarLoader() {
        void it;
        ProgressIndicatorsProvider progressIndicatorsProvider;
        ProgressIndicatorsProvider progressIndicatorsProvider2 = progressIndicatorsProvider = new ProgressIndicatorsProvider();
        CachingGHUserAvatarLoader cachingGHUserAvatarLoader = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        cachingGHUserAvatarLoader.indicatorProvider = progressIndicatorsProvider;
        this.avatarCache = Caffeine.newBuilder().expireAfterAccess(Duration.of(5L, ChronoUnit.MINUTES)).build();
        LowMemoryWatcher.register(() -> CachingGHUserAvatarLoader._init_$lambda$1(this), (Disposable)this);
    }

    @NotNull
    public final CompletableFuture<Image> requestAvatar(@NotNull GithubApiRequestExecutor requestExecutor, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = this.avatarCache.get((Object)url, arg_0 -> CachingGHUserAvatarLoader.requestAvatar$lambda$2((Function1)new Function1<String, CompletableFuture<Image>>(this, requestExecutor, url){
            final /* synthetic */ CachingGHUserAvatarLoader this$0;
            final /* synthetic */ GithubApiRequestExecutor $requestExecutor;
            final /* synthetic */ String $url;
            {
                this.this$0 = $receiver;
                this.$requestExecutor = $requestExecutor;
                this.$url = $url;
                super(1);
            }

            public final CompletableFuture<Image> invoke(String it) {
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance()");
                return CompletableFutureUtil.INSTANCE.submitIOTask(progressManager, CachingGHUserAvatarLoader.access$getIndicatorProvider$p(this.this$0), (Function1)new Function1<ProgressIndicator, Image>(this.this$0, this.$requestExecutor, this.$url){
                    final /* synthetic */ CachingGHUserAvatarLoader this$0;
                    final /* synthetic */ GithubApiRequestExecutor $requestExecutor;
                    final /* synthetic */ String $url;
                    {
                        this.this$0 = $receiver;
                        this.$requestExecutor = $requestExecutor;
                        this.$url = $url;
                        super(1);
                    }

                    @Nullable
                    public final Image invoke(@NotNull ProgressIndicator it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return CachingGHUserAvatarLoader.access$loadAndDownscale(this.this$0, this.$requestExecutor, it, this.$url, 240);
                    }
                });
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fun requestAvatar(reques\u2026 STORED_IMAGE_SIZE) }\n  }");
        return (CompletableFuture)object;
    }

    private final Image loadAndDownscale(GithubApiRequestExecutor requestExecutor, ProgressIndicator indicator, String url, int maximumSize) {
        try {
            Image image;
            BufferedImage loadedImage = requestExecutor.execute(indicator, GithubApiRequests.CurrentUser.getAvatar(url));
            if (loadedImage.getWidth() <= maximumSize && loadedImage.getHeight() <= maximumSize) {
                image = loadedImage;
            } else {
                Image image2 = ImageLoader.scaleImage((Image)loadedImage, (int)maximumSize);
                Intrinsics.checkNotNull((Object)image2, (String)"null cannot be cast to non-null type java.awt.image.BufferedImage");
                image = (BufferedImage)image2;
            }
            return image;
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        catch (Exception e) {
            LOG.debug("Error loading image from " + url, (Throwable)e);
            return null;
        }
    }

    public void dispose() {
    }

    private static final void _init_$lambda$1(CachingGHUserAvatarLoader this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.avatarCache.invalidateAll();
    }

    private static final CompletableFuture requestAvatar$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletableFuture)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final CachingGHUserAvatarLoader getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ ProgressIndicatorsProvider access$getIndicatorProvider$p(CachingGHUserAvatarLoader $this) {
        return $this.indicatorProvider;
    }

    public static final /* synthetic */ Image access$loadAndDownscale(CachingGHUserAvatarLoader $this, GithubApiRequestExecutor requestExecutor, ProgressIndicator indicator, String url, int maximumSize) {
        return $this.loadAndDownscale(requestExecutor, indicator, url, maximumSize);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CachingGHUserAvatarLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAXIMUM_ICON_SIZE", "", "STORED_IMAGE_SIZE", "getInstance", "Lorg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader;", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nCachingGHUserAvatarLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CachingGHUserAvatarLoader.kt\norg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,71:1\n43#2,3:72\n*S KotlinDebug\n*F\n+ 1 CachingGHUserAvatarLoader.kt\norg/jetbrains/plugins/github/util/CachingGHUserAvatarLoader$Companion\n*L\n64#1:72,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CachingGHUserAvatarLoader getInstance() {
            boolean $i$f$service = false;
            Class<CachingGHUserAvatarLoader> serviceClass$iv = CachingGHUserAvatarLoader.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (CachingGHUserAvatarLoader)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

