/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorCachingWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public class TextMateScopeComparator<T>
implements Comparator<T> {
    @NotNull
    private static final TextMateSelectorWeigher myWeigher = new TextMateSelectorCachingWeigher(new TextMateSelectorWeigherImpl());
    @NotNull
    private final TextMateScope myScope;
    @NotNull
    private final Function<? super T, ? extends CharSequence> myScopeSupplier;

    public TextMateScopeComparator(@NotNull TextMateScope scope, @NotNull Function<? super T, ? extends CharSequence> scopeSupplier) {
        if (scope == null) {
            TextMateScopeComparator.$$$reportNull$$$0(0);
        }
        if (scopeSupplier == null) {
            TextMateScopeComparator.$$$reportNull$$$0(1);
        }
        this.myScope = scope;
        this.myScopeSupplier = scopeSupplier;
    }

    @Override
    public int compare(T first, T second) {
        return myWeigher.weigh(this.myScopeSupplier.apply(first), this.myScope).compareTo(myWeigher.weigh(this.myScopeSupplier.apply(second), this.myScope));
    }

    @NotNull
    public List<T> sortAndFilter(@NotNull Collection<? extends T> objects) {
        if (objects == null) {
            TextMateScopeComparator.$$$reportNull$$$0(2);
        }
        List<? extends T> list = this.sortAndFilter(objects.stream());
        if (list == null) {
            TextMateScopeComparator.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<T> sortAndFilter(Stream<? extends T> stream) {
        List list = stream.filter(t -> TextMateScopeComparator.myWeigher.weigh((CharSequence)this.myScopeSupplier.apply(t), (TextMateScope)this.myScope).weigh > 0).sorted(Collections.reverseOrder(this)).collect(Collectors.toList());
        if (list == null) {
            TextMateScopeComparator.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public T max(Collection<T> objects) {
        TextMateWeigh max = TextMateWeigh.ZERO;
        T result = null;
        for (T object : objects) {
            TextMateWeigh weigh = myWeigher.weigh(this.myScopeSupplier.apply(object), this.myScope);
            if (weigh.weigh <= 0 || weigh.compareTo(max) <= 0) continue;
            max = weigh;
            result = object;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeSupplier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/TextMateScopeComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/TextMateScopeComparator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sortAndFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "sortAndFilter";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

