/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class PreferencesRegistryImpl
implements PreferencesRegistry {
    @NotNull
    private final Set<Preferences> myPreferences = new HashSet<Preferences>();
    @NotNull
    private final IntSet myLeftHighlightingBraces = new IntOpenHashSet();
    @NotNull
    private final IntSet myRightHighlightingBraces = new IntOpenHashSet();
    @NotNull
    private final IntSet myLeftSmartTypingBraces = new IntOpenHashSet();
    @NotNull
    private final IntSet myRightSmartTypingBraces = new IntOpenHashSet();

    public PreferencesRegistryImpl() {
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    public void addPreferences(Preferences preferences) {
        this.fillHighlightingBraces(preferences.getHighlightingPairs());
        this.fillSmartTypingBraces(preferences.getSmartTypingPairs());
        this.myPreferences.add(preferences);
    }

    @Deprecated(forRemoval=true)
    public void fillFromPList(@NotNull CharSequence scopeName, @NotNull Plist plist2) {
        if (scopeName == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(0);
        }
        if (plist2 == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(1);
        }
        Set<TextMateBracePair> highlightingPairs = PreferencesReadUtil.readPairs(plist2.getPlistValue("highlightingPairs"));
        Set<TextMateBracePair> smartTypingPairs = PreferencesReadUtil.readPairs(plist2.getPlistValue("smartTypingPairs"));
        IndentationRules indentationRules = PreferencesReadUtil.loadIndentationRules(plist2);
        this.fillHighlightingBraces(highlightingPairs);
        this.fillSmartTypingBraces(smartTypingPairs);
        if (highlightingPairs != null || smartTypingPairs != null || !indentationRules.isEmpty().booleanValue()) {
            this.myPreferences.add(new Preferences(scopeName, highlightingPairs, smartTypingPairs, indentationRules));
        }
    }

    private void fillHighlightingBraces(Collection<TextMateBracePair> highlightingPairs) {
        if (highlightingPairs != null) {
            for (TextMateBracePair pair : highlightingPairs) {
                this.myLeftHighlightingBraces.add((int)pair.leftChar);
                this.myRightHighlightingBraces.add((int)pair.rightChar);
            }
        }
    }

    private void fillSmartTypingBraces(Collection<TextMateBracePair> smartTypingPairs) {
        if (smartTypingPairs != null) {
            for (TextMateBracePair pair : smartTypingPairs) {
                this.myLeftSmartTypingBraces.add((int)pair.leftChar);
                this.myRightSmartTypingBraces.add((int)pair.rightChar);
            }
        }
    }

    @Override
    public boolean isPossibleLeftHighlightingBrace(char c) {
        return this.myLeftHighlightingBraces.contains((int)c) || c != ' ' && this.myLeftSmartTypingBraces.contains((int)c);
    }

    @Override
    public boolean isPossibleRightHighlightingBrace(char c) {
        return this.myRightHighlightingBraces.contains((int)c) || c != ' ' && this.myRightSmartTypingBraces.contains((int)c);
    }

    @Override
    public boolean isPossibleLeftSmartTypingBrace(char c) {
        return this.myLeftSmartTypingBraces.contains((int)c);
    }

    @Override
    public boolean isPossibleRightSmartTypingBrace(char c) {
        return this.myRightSmartTypingBraces.contains((int)c);
    }

    @Override
    @NotNull
    public List<Preferences> getPreferences(@NotNull TextMateScope scope) {
        if (scope == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(2);
        }
        List<Preferences> list = new TextMateScopeComparator<Preferences>(scope, Preferences::getScopeSelector).sortAndFilter(this.myPreferences);
        if (list == null) {
            PreferencesRegistryImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void clear() {
        this.myPreferences.clear();
        this.myLeftHighlightingBraces.clear();
        this.myRightHighlightingBraces.clear();
        this.fillHighlightingBraces(Constants.DEFAULT_HIGHLIGHTING_BRACE_PAIRS);
        this.myLeftSmartTypingBraces.clear();
        this.myRightSmartTypingBraces.clear();
        this.fillSmartTypingBraces(Constants.DEFAULT_SMART_TYPING_BRACE_PAIRS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillFromPList";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPreferences";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

