/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public class SnippetsRegistryImpl
implements SnippetsRegistry {
    @NotNull
    private final Map<String, Collection<TextMateSnippet>> mySnippets = new ConcurrentHashMap<String, Collection<TextMateSnippet>>();

    public void register(@NotNull TextMateSnippet snippet) {
        if (snippet == null) {
            SnippetsRegistryImpl.$$$reportNull$$$0(0);
        }
        this.mySnippets.computeIfAbsent(snippet.getKey(), key -> Collections.synchronizedList(new ArrayList())).add(snippet);
    }

    @Override
    @NotNull
    public Collection<TextMateSnippet> findSnippet(@NotNull String key, @Nullable TextMateScope scope) {
        if (key == null) {
            SnippetsRegistryImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            List<TextMateSnippet> list = Collections.emptyList();
            if (list == null) {
                SnippetsRegistryImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        Collection<TextMateSnippet> snippets = this.mySnippets.get(key);
        if (snippets == null) {
            List<TextMateSnippet> list = Collections.emptyList();
            if (list == null) {
                SnippetsRegistryImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<TextMateSnippet> list = new TextMateScopeComparator<TextMateSnippet>(scope, TextMateSnippet::getScopeSelector).sortAndFilter(snippets);
        if (list == null) {
            SnippetsRegistryImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<TextMateSnippet> getAvailableSnippets(@Nullable TextMateScope scopeSelector) {
        if (scopeSelector == null) {
            List<TextMateSnippet> list = Collections.emptyList();
            if (list == null) {
                SnippetsRegistryImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<TextMateSnippet> list = new TextMateScopeComparator<TextMateSnippet>(scopeSelector, TextMateSnippet::getScopeSelector).sortAndFilter(this.mySnippets.values().stream().flatMap(values -> values.stream()));
        if (list == null) {
            SnippetsRegistryImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    public void clear() {
        this.mySnippets.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snippet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/preferences/SnippetsRegistryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/preferences/SnippetsRegistryImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findSnippet";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableSnippets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSnippet";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

