/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.impl;

import com.intellij.platform.runtime.repository.impl.ResourceRoot;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;

class JarResourceRoot
extends ResourceRoot {
    private final Path myJarFile;

    JarResourceRoot(Path jarFile) {
        this.myJarFile = jarFile;
    }

    @Override
    public InputStream openFile(@NotNull String relativePath) throws IOException {
        if (relativePath == null) {
            JarResourceRoot.$$$reportNull$$$0(0);
        }
        final ZipFile jarFile = new ZipFile(this.myJarFile.toFile());
        try {
            ZipEntry entry = jarFile.getEntry(relativePath);
            if (entry != null) {
                return new FilterInputStream(jarFile.getInputStream(entry)){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        jarFile.close();
                    }
                };
            }
            return null;
        }
        catch (IOException e) {
            jarFile.close();
            throw e;
        }
    }

    @Override
    @NotNull
    public Path getRootPath() {
        Path path = this.myJarFile;
        if (path == null) {
            JarResourceRoot.$$$reportNull$$$0(1);
        }
        return path;
    }

    public String toString() {
        return "JarResourceRoot{jarFile=" + this.myJarFile + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/impl/JarResourceRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/impl/JarResourceRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

