/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.jps;

import com.intellij.ide.highlighter.ModuleFileType;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.PackageUtilKt;
import org.jetbrains.security.api.PackageDeclaration;
import org.jetbrains.security.extension.BuildFileProviderBase;
import org.jetbrains.security.model.ModuleModel;
import org.jetbrains.security.model.ProjectDependenciesModel;
import org.jetbrains.security.model.impl.IntellijModuleProjectDependenciesModel;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00112\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/security/extension/jps/JpsBuildFileProvider;", "Lorg/jetbrains/security/extension/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "collectPackages", "", "Lorg/jetbrains/security/package/Package;", "module", "Lcom/intellij/openapi/module/Module;", "declaredPackages", "Lorg/jetbrains/security/api/PackageDeclaration;", "file", "Lcom/intellij/psi/PsiFile;", "findModuleForFile", "getModule", "getRoots", "", "pkgs", "importedPackages", "moduleScript", "supports", "", "supportsFixes", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nJpsBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsBuildFileProvider.kt\norg/jetbrains/security/extension/jps/JpsBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n1747#2,3:84\n1271#2,2:87\n1285#2,4:89\n*S KotlinDebug\n*F\n+ 1 JpsBuildFileProvider.kt\norg/jetbrains/security/extension/jps/JpsBuildFileProvider\n*L\n33#1:80\n33#1:81,3\n45#1:84,3\n58#1:87,2\n58#1:89,4\n*E\n"})
public final class JpsBuildFileProvider
extends BuildFileProviderBase {
    public JpsBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    public Module getModule(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = this.findModuleForFile(file2);
        if (module == null) {
            throw new IllegalStateException(("Cannot find appropriate module for provided file: " + file2.getName()).toString());
        }
        return module;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = module.getModuleFile();
        if (virtualFile != null) {
            VirtualFile moduleFile = virtualFile;
            boolean bl = false;
            if (this.getProject().isDisposed() || !moduleFile.isValid()) {
                return null;
            }
            psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(moduleFile);
        } else {
            psiFile = null;
        }
        return psiFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<PackageDeclaration> declaredPackages(@Nullable PsiFile file2, @NotNull Module module) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (file2 == null) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = this.collectPackages(module);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Package package_ = (Package)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new PackageDeclaration((Package)it, (PsiElement)file2, null, 4, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = this.findModuleForFile(file2);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        return this.collectPackages(module2);
    }

    @Override
    public boolean supports(@NotNull PsiFile file2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (!Intrinsics.areEqual((Object)file2.getFileType(), (Object)ModuleFileType.INSTANCE)) {
                return false;
            }
            Iterable $this$any$iv = (Iterable)((IntellijModuleProjectDependenciesModel)ProjectDependenciesModel.Companion.getEP_NAME().findExtensionOrFail(IntellijModuleProjectDependenciesModel.class, (AreaInstance)this.getProject())).getModules().getValue();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ModuleModel it = (ModuleModel)element$iv;
                    boolean bl2 = false;
                    ProgressManager.checkCanceled();
                    if (!(it.getBuildFile() != null && Intrinsics.areEqual((Object)it.getBuildFile(), (Object)file2.getVirtualFile()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ((IntellijModuleProjectDependenciesModel)ProjectDependenciesModel.Companion.getEP_NAME().findExtensionOrFail(IntellijModuleProjectDependenciesModel.class, (AreaInstance)this.getProject())).shouldProcess(module);
    }

    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file2, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        Module module = ModuleUtil.findModuleForFile((PsiFile)file2);
        if (module == null) {
            return MapsKt.emptyMap();
        }
        Module module2 = module;
        Iterable $this$associateWith$iv = this.collectPackages(module2);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Package package_ = (Package)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            map2.put(t, list);
        }
        return result$iv;
    }

    @Override
    public boolean supportsFixes() {
        return false;
    }

    private final Module findModuleForFile(PsiFile file2) {
        return ModuleUtil.findModuleForFile((PsiFile)file2);
    }

    private final List<Package> collectPackages(Module module) {
        List packages = new ArrayList();
        if (module.isDisposed()) {
            return packages;
        }
        ModuleRootManager.getInstance((Module)module).orderEntries().forEachLibrary(arg_0 -> JpsBuildFileProvider.collectPackages$lambda$4((Function1)new Function1<Library, Boolean>((List<Package>)packages){
            final /* synthetic */ List<Package> $packages;
            {
                this.$packages = $packages;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Library it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Package pkg = PackageUtilKt.createPackage(it);
                if (pkg != null) {
                    this.$packages.add(pkg);
                }
                return true;
            }
        }, arg_0));
        return packages;
    }

    private static final boolean collectPackages$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

