/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.extension.python;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.extensions.python.VirtualFileExtKt;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.extension.python.PythonBuildFileProvider;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/security/extension/python/RequirementsTxtBuildFileProvider;", "Lorg/jetbrains/security/extension/python/PythonBuildFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getRequirementsFromFile", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "file", "Lcom/intellij/psi/PsiFile;", "moduleScript", "module", "Lcom/intellij/openapi/module/Module;", "supports", "", "intellij.packageChecker"})
public final class RequirementsTxtBuildFileProvider
extends PythonBuildFileProvider {
    public RequirementsTxtBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        VirtualFile virtualFile = PyPackageUtil.findRequirementsTxt((Module)module);
        return (PsiFile)(virtualFile != null ? VirtualFileExtKt.toPsi((VirtualFile)virtualFile, (Project)this.getProject()) : null);
    }

    @Override
    @NotNull
    public List<PyRequirement> getRequirementsFromFile(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file2);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module moduleByFile = module;
        List list = PyPackageUtil.getRequirementsFromTxt((Module)moduleByFile);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public boolean supports(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return Intrinsics.areEqual((Object)file2.getName(), (Object)"requirements.txt");
    }
}

