/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.inspection.fix;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.PackageCheckerBundle;
import org.jetbrains.security.fus.PackageCheckerUsageStat;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/security/inspection/fix/ChangeVersionQuickfix;", "Lcom/intellij/codeInspection/QuickFix;", "Lcom/intellij/codeInspection/ModuleProblemDescriptor;", "targetVersion", "", "currentPackage", "Lorg/jetbrains/security/package/Package;", "(Ljava/lang/String;Lorg/jetbrains/security/package/Package;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "getFamilyName", "intellij.packageChecker"})
public final class ChangeVersionQuickfix
implements QuickFix<ModuleProblemDescriptor> {
    @NotNull
    private final String targetVersion;
    @NotNull
    private final Package currentPackage;

    public ChangeVersionQuickfix(@NotNull String targetVersion, @NotNull Package currentPackage) {
        Intrinsics.checkNotNullParameter((Object)targetVersion, (String)"targetVersion");
        Intrinsics.checkNotNullParameter((Object)currentPackage, (String)"currentPackage");
        this.targetVersion = targetVersion;
        this.currentPackage = currentPackage;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.currentPackage.getHumanReadableCoordinates(), this.targetVersion};
        String string = PackageCheckerBundle.message("change.version.quickfix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"change.version.\u2026ordinates, targetVersion)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ModuleProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PackageCheckerUsageStat.fixGlobal.log(project);
        DependencyModifierService instance = DependencyModifierService.Companion.getInstance(project);
        Module module = descriptor.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"descriptor.module");
        Module module2 = module;
        instance.updateDependency(module2, new UnifiedDependency(this.currentPackage.getNamespace(), this.currentPackage.getName(), this.currentPackage.getVersion().getValue(), null, 8, null), new UnifiedDependency(this.currentPackage.getNamespace(), this.currentPackage.getName(), this.targetVersion, null, 8, null));
    }
}

