/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.toolwindow.preview;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLabelDecorator;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.PackageCheckerBundle;
import org.jetbrains.security.PackageUtilKt;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.problems.vulnerabilities.Severity;
import org.jetbrains.security.problems.vulnerabilities.Vulnerability;
import org.jetbrains.security.service.PackageChecker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u0012\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u0013\u001a\u00020\u0004H\u0003J\"\u0010\u0014\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0003R\u001a\u0010\n\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\f0\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/security/toolwindow/preview/VulnerabilityPanels;", "Lcom/intellij/ui/components/JBPanel;", "vulnerabilities", "", "Lorg/jetbrains/security/problems/vulnerabilities/Vulnerability;", "pkg", "Lorg/jetbrains/security/package/Package;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/util/List;Lorg/jetbrains/security/package/Package;Lcom/intellij/openapi/project/Project;)V", "falsePositiveTitle", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "readMoreMessage", "reportFalsePositiveMessage", "getVulnerabilities", "()Ljava/util/List;", "getCveLabelText", "vulnerability", "getFalsePositiveContent", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nVulnerabilityPanels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerabilityPanels.kt\norg/jetbrains/security/toolwindow/preview/VulnerabilityPanels\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1855#2,2:98\n*S KotlinDebug\n*F\n+ 1 VulnerabilityPanels.kt\norg/jetbrains/security/toolwindow/preview/VulnerabilityPanels\n*L\n47#1:98,2\n*E\n"})
public final class VulnerabilityPanels
extends JBPanel<VulnerabilityPanels> {
    @NotNull
    private final List<Vulnerability> vulnerabilities;
    @NlsSafe
    @NotNull
    private final String readMoreMessage;
    @NlsSafe
    @NotNull
    private final String falsePositiveTitle;
    @NlsSafe
    @NotNull
    private final String reportFalsePositiveMessage;

    /*
     * WARNING - void declaration
     */
    public VulnerabilityPanels(@NotNull List<Vulnerability> vulnerabilities, @NotNull Package pkg, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((LayoutManager)new GridBagLayout());
        this.vulnerabilities = vulnerabilities;
        String string = PackageCheckerBundle.message("action.link.read.more", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"action.link.read.more\")");
        this.readMoreMessage = string;
        String string2 = PackageCheckerBundle.message("message.false.positive.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"message.false.positive.title\")");
        this.falsePositiveTitle = string2;
        String string3 = PackageCheckerBundle.message("action.link.report.false.positive", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"action.link.report.false.positive\")");
        this.reportFalsePositiveMessage = string3;
        GridBag gridBag = new GridBag().setDefaultAnchor(0, 17).setDefaultAnchor(1, 13).setDefaultInsets(0, 20, 16, 20).setDefaultFill(1);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"GridBag()\n      .setDefa\u2026(GridBagConstraints.BOTH)");
        GridBag gridBag2 = gridBag;
        Iterable $this$forEach$iv = this.vulnerabilities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void jbLabel;
            JBLabel jBLabel;
            JBLabelDecorator jBLabelDecorator;
            Vulnerability vulnerability = (Vulnerability)element$iv;
            boolean bl = false;
            JBLabelDecorator cveLabel = jBLabelDecorator = JBLabelDecorator.createJBLabelDecorator((String)this.getCveLabelText(vulnerability));
            boolean bl2 = false;
            cveLabel.setFont((Font)JBFont.label().asBold());
            cveLabel.setFontColor(UIUtil.FontColor.NORMAL);
            cveLabel.setFocusable(true);
            cveLabel.setIcon(PackageUtilKt.severityIcon(Severity.Companion.fromScore(vulnerability.getCvssScore())));
            cveLabel.setIconTextGap(6);
            this.add((Component)cveLabel, gridBag2.nextLine().next().insetTop(12));
            String vulnerabilityDescription = vulnerability.getDescription();
            JComponent jComponent = ComponentsKt.htmlComponent$default((String)vulnerabilityDescription, null, null, null, (boolean)false, null, (int)46, null);
            JEditorPane textLabel = jComponent;
            boolean bl3 = false;
            textLabel.setFocusable(true);
            this.add(textLabel, gridBag2.nextLine().coverLine().weighty(1.0).weightx(1.0).insetBottom(0));
            JComponent linkPanel = jComponent = new JPanel(new FlowLayout(0, 0, 0));
            boolean bl4 = false;
            ActionLink reportFPActionLink2 = new ActionLink(this.reportFalsePositiveMessage, (Function1)new Function1<ActionEvent, Unit>(project, pkg, vulnerability, this){
                final /* synthetic */ Project $project;
                final /* synthetic */ Package $pkg;
                final /* synthetic */ Vulnerability $vulnerability;
                final /* synthetic */ VulnerabilityPanels this$0;
                {
                    this.$project = $project;
                    this.$pkg = $pkg;
                    this.$vulnerability = $vulnerability;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    PackageChecker.Companion.getInstance(this.$project).reportFP(this.$pkg, this.$vulnerability);
                    Messages.showInfoMessage((String)VulnerabilityPanels.access$getFalsePositiveContent(this.this$0, this.$vulnerability, this.$pkg), (String)VulnerabilityPanels.access$getFalsePositiveTitle$p(this.this$0));
                }
            });
            ActionLink browseLink2 = new ActionLink(this.readMoreMessage, (Function1)new Function1<ActionEvent, Unit>(vulnerability){
                final /* synthetic */ Vulnerability $vulnerability;
                {
                    this.$vulnerability = $vulnerability;
                    super(1);
                }

                public final void invoke(@NotNull ActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    BrowserUtil.browse((String)PackageUtilKt.getReference(this.$vulnerability));
                }
            });
            linkPanel.add((Component)reportFPActionLink2);
            linkPanel.add(new JSeparator(1));
            JBLabel jBLabel2 = jBLabel = new JBLabel("|");
            JComponent jComponent2 = linkPanel;
            boolean bl5 = false;
            jbLabel.setBorder((Border)JBUI.Borders.empty((int)0, (int)12));
            jbLabel.setForeground(JBUI.CurrentTheme.Link.Foreground.ENABLED);
            jComponent2.add((Component)jBLabel);
            linkPanel.add(new JSeparator(1));
            linkPanel.add((Component)browseLink2);
            this.add(linkPanel, gridBag2.nextLine().insetTop(12));
        }
    }

    @NotNull
    public final List<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    @NlsSafe
    private final String getCveLabelText(Vulnerability vulnerability) {
        Object[] objectArray = new Object[]{vulnerability.getCve(), Float.valueOf(vulnerability.getCvssScore())};
        String string = PackageCheckerBundle.message("cve.label.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"cve.label.text\"\u2026 vulnerability.cvssScore)");
        return string;
    }

    @NlsSafe
    private final String getFalsePositiveContent(Vulnerability vulnerability, Package pkg) {
        Object[] objectArray = new Object[]{vulnerability.getCve(), pkg.getHumanReadableCoordinates()};
        String string = PackageCheckerBundle.message("message.false.positive.content", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"message.false.p\u2026humanReadableCoordinates)");
        return string;
    }

    public static final /* synthetic */ String access$getFalsePositiveContent(VulnerabilityPanels $this, Vulnerability vulnerability, Package pkg) {
        return $this.getFalsePositiveContent(vulnerability, pkg);
    }

    public static final /* synthetic */ String access$getFalsePositiveTitle$p(VulnerabilityPanels $this) {
        return $this.falsePositiveTitle;
    }
}

