/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.ProgressManagerQueue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.BranchesLoader;
import org.jetbrains.idea.svn.branchConfig.DefaultBranchConfig;
import org.jetbrains.idea.svn.branchConfig.InfoReliability;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.NewRootBunchKt;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\tJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\tJ&\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\nJ\u001e\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ*\u0010!\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00192\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0\u0010J$\u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010'\u001a\u00020\u001dR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/idea/svn/branchConfig/NewRootBunch;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myBranchesLoader", "Lcom/intellij/vcs/ProgressManagerQueue;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/ProgressManagerQueue;)V", "mapCopy", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationNew;", "getMapCopy", "()Ljava/util/Map;", "myLock", "myMap", "", "Lorg/jetbrains/idea/svn/branchConfig/InfoStorage;", "applyDefaultConfig", "", "root", "config", "getConfig", "getConfigOrNull", "reloadBranches", "branchLocation", "Lorg/jetbrains/idea/svn/api/Url;", "reliability", "Lorg/jetbrains/idea/svn/branchConfig/InfoReliability;", "passive", "", "prev", "next", "reloadBranchesAsync", "updateBranches", "branchesParent", "items", "", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchItem;", "updateForRoot", "reload", "intellij.vcs.svn"})
@SourceDebugExtension(value={"SMAP\nNewRootBunch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewRootBunch.kt\norg/jetbrains/idea/svn/branchConfig/NewRootBunch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1#2:98\n442#3:99\n392#3:100\n1238#4,4:101\n*S KotlinDebug\n*F\n+ 1 NewRootBunch.kt\norg/jetbrains/idea/svn/branchConfig/NewRootBunch\n*L\n19#1:99\n19#1:100\n19#1:101,4\n*E\n"})
public final class NewRootBunch {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProgressManagerQueue myBranchesLoader;
    @NotNull
    private final Object myLock;
    @NotNull
    private final Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> myMap;

    public NewRootBunch(@NotNull Project myProject, @NotNull ProgressManagerQueue myBranchesLoader) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myBranchesLoader, (String)"myBranchesLoader");
        this.myProject = myProject;
        this.myBranchesLoader = myBranchesLoader;
        this.myLock = new Object();
        this.myMap = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<VirtualFile, SvnBranchConfigurationNew> getMapCopy() {
        Map map;
        Object object = this.myLock;
        synchronized (object) {
            void $this$mapValuesTo$iv$iv;
            boolean bl = false;
            Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> $this$mapValues$iv = this.myMap;
            boolean $i$f$mapValues = false;
            Map<VirtualFile, InfoStorage<SvnBranchConfigurationNew>> map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl3 = false;
                SvnBranchConfigurationNew svnBranchConfigurationNew = (SvnBranchConfigurationNew)((InfoStorage)it.getValue()).getValue();
                map4.put(k, svnBranchConfigurationNew);
            }
            map = destination$iv$iv;
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateForRoot(@NotNull VirtualFile root, @NotNull InfoStorage<SvnBranchConfigurationNew> config, boolean reload) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            SvnBranchConfigurationNew previous = null;
            boolean override = false;
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                previous = null;
                override = true;
                this.myMap.put(root, config);
            } else {
                previous = existing.getValue();
                override = existing.accept(config);
            }
            if (reload && override) {
                this.myBranchesLoader.run(() -> NewRootBunch.updateForRoot$lambda$3$lambda$2(this, root, previous, config));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateBranches(@NotNull VirtualFile root, @NotNull Url branchesParent, @NotNull InfoStorage<List<SvnBranchItem>> items) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)branchesParent, (String)"branchesParent");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            InfoStorage<SvnBranchConfigurationNew> existing = this.myMap.get(root);
            if (existing == null) {
                NewRootBunchKt.access$getLOG$p().info("cannot update branches, branches parent not found: " + branchesParent.toDecodedString());
            } else {
                existing.getValue().updateBranch(branchesParent, items);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final SvnBranchConfigurationNew getConfigOrNull(@NotNull VirtualFile root) {
        SvnBranchConfigurationNew svnBranchConfigurationNew;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            InfoStorage<SvnBranchConfigurationNew> infoStorage = this.myMap.get(root);
            svnBranchConfigurationNew = infoStorage != null ? infoStorage.getValue() : null;
        }
        return svnBranchConfigurationNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SvnBranchConfigurationNew getConfig(@NotNull VirtualFile root) {
        SvnBranchConfigurationNew svnBranchConfigurationNew;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            InfoStorage<SvnBranchConfigurationNew> value = this.myMap.get(root);
            SvnBranchConfigurationNew result = null;
            if (value == null) {
                result = new SvnBranchConfigurationNew();
                this.myMap.put(root, new InfoStorage<SvnBranchConfigurationNew>(result, InfoReliability.empty));
                this.myBranchesLoader.run(() -> NewRootBunch.getConfig$lambda$7$lambda$6(this, root));
            } else {
                result = value.getValue();
            }
            svnBranchConfigurationNew = result;
        }
        return svnBranchConfigurationNew;
    }

    private final void applyDefaultConfig(VirtualFile root, SvnBranchConfigurationNew config) {
        for (Url url : config.getBranchLocations()) {
            this.reloadBranchesAsync(root, url, InfoReliability.defaultValues);
        }
        this.updateForRoot(root, new InfoStorage<SvnBranchConfigurationNew>(config, InfoReliability.defaultValues), false);
    }

    public final void reloadBranchesAsync(@NotNull VirtualFile root, @NotNull Url branchLocation, @NotNull InfoReliability reliability) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)branchLocation, (String)"branchLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)reliability), (String)"reliability");
        ApplicationManager.getApplication().executeOnPooledThread(() -> NewRootBunch.reloadBranchesAsync$lambda$8(this, root, branchLocation, reliability));
    }

    public final void reloadBranches(@NotNull VirtualFile root, @Nullable SvnBranchConfigurationNew prev, @NotNull SvnBranchConfigurationNew next) {
        SvnVcs vcs;
        Object oldUrls;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        Object object = prev;
        if (object == null || (object = ((SvnBranchConfigurationNew)object).getBranchLocations()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = oldUrls = SetsKt.emptySet();
        }
        if (!(vcs = SvnVcs.getInstance(this.myProject)).isVcsBackgroundOperationsAllowed(root)) {
            return;
        }
        for (Url newBranchUrl : next.getBranchLocations()) {
            if (!vcs.isVcsBackgroundOperationsAllowed(root)) {
                return;
            }
            if (oldUrls.contains(newBranchUrl)) continue;
            this.reloadBranches(root, newBranchUrl, InfoReliability.defaultValues, true);
        }
    }

    public final void reloadBranches(@NotNull VirtualFile root, @NotNull Url branchLocation, @NotNull InfoReliability reliability, boolean passive) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)branchLocation, (String)"branchLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)reliability), (String)"reliability");
        new BranchesLoader(this.myProject, this, branchLocation, reliability, root, passive).run();
    }

    private static final void updateForRoot$lambda$3$lambda$2(NewRootBunch this$0, VirtualFile $root, SvnBranchConfigurationNew $previous, InfoStorage $config) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        this$0.reloadBranches($root, $previous, (SvnBranchConfigurationNew)$config.getValue());
    }

    private static final void getConfig$lambda$7$lambda$6(NewRootBunch this$0, VirtualFile $root) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        SvnBranchConfigurationNew defaultConfig = DefaultBranchConfig.detect(this$0.myProject, $root);
        if (defaultConfig != null) {
            this$0.applyDefaultConfig($root, defaultConfig);
        }
    }

    private static final void reloadBranchesAsync$lambda$8(NewRootBunch this$0, VirtualFile $root, Url $branchLocation, InfoReliability $reliability) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)$branchLocation, (String)"$branchLocation");
        Intrinsics.checkNotNullParameter((Object)((Object)$reliability), (String)"$reliability");
        this$0.reloadBranches($root, $branchLocation, $reliability, true);
    }
}

