/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.data;

import javax.swing.JTable;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTableCellReader;
import org.assertj.swing.data.TableCell;
import org.assertj.swing.data.TableCellFinder;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.exception.ActionFailedException;

public class TableCellInSelectedRow
implements TableCellFinder {
    private final int column;

    @Nonnull
    public static TableCellBuilder selectedRow() {
        return new TableCellBuilder();
    }

    protected TableCellInSelectedRow(int column) {
        this.column = column;
    }

    @Override
    @Nonnull
    public TableCell findCell(@Nonnull JTable table, @Nonnull JTableCellReader cellReader) {
        int selectedRow = TableCellInSelectedRow.selectedRowOf(table);
        if (selectedRow == -1) {
            throw ActionFailedException.actionFailure("The given JTable does not have any selection");
        }
        return new TableCell(selectedRow, this.column);
    }

    @RunsInEDT
    private static int selectedRowOf(JTable table) {
        Integer result2 = GuiActionRunner.execute(() -> table.getSelectedRow());
        return Preconditions.checkNotNull(result2);
    }

    public String toString() {
        return String.format("%s[column=%d]", this.getClass().getName(), this.column);
    }

    public static class TableCellBuilder {
        @Nonnull
        public TableCellInSelectedRow column(int column) {
            return new TableCellInSelectedRow(column);
        }
    }
}

