/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.parameterInfo.ParameterFlag;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.codeInsight.parameterInfo.ParameterHints;
import com.jetbrains.python.codeInsight.parameterInfo.PyParameterInfoUtils;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.types.PyCallableType;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyParameterInfoHandler
implements ParameterInfoHandler<PyArgumentList, Pair<PyCallExpression, PyCallableType>> {
    private static final int MY_PARAM_LENGTH_LIMIT = 50;
    private static final EnumMap<ParameterFlag, ParameterInfoUIContextEx.Flag> PARAM_FLAG_TO_UI_FLAG = new EnumMap<ParameterFlag, ParameterInfoUIContextEx.Flag>(Map.of(ParameterFlag.HIGHLIGHT, ParameterInfoUIContextEx.Flag.HIGHLIGHT, ParameterFlag.DISABLE, ParameterInfoUIContextEx.Flag.DISABLE, ParameterFlag.STRIKEOUT, ParameterInfoUIContextEx.Flag.STRIKEOUT));

    @Nullable
    public PyArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        int offset;
        PsiFile file;
        PyArgumentList argumentList;
        List<Pair<PyCallExpression, PyCallableType>> parameterInfos;
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((parameterInfos = PyParameterInfoUtils.findCallCandidates(argumentList = PyParameterInfoUtils.findArgumentList(file = context.getFile(), offset = context.getOffset(), -1))) != null) {
            Object[] infoArr = parameterInfos.toArray();
            context.setItemsToShow(infoArr);
            return argumentList;
        }
        return null;
    }

    public void showParameterInfo(@NotNull PyArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    @Nullable
    public PyArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return PyParameterInfoUtils.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart());
    }

    public void updateParameterInfo(@NotNull PyArgumentList argumentList, @NotNull UpdateParameterInfoContext context) {
        if (argumentList == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int allegedCursorOffset = context.getOffset();
        if (!argumentList.getTextRange().contains(allegedCursorOffset) && argumentList.getText().endsWith(")")) {
            context.removeHint();
            return;
        }
        PsiFile file = context.getFile();
        int offset = PyParameterInfoUtils.findCurrentParameter(argumentList, allegedCursorOffset, file);
        context.setCurrentParameter(offset);
    }

    public void updateUI(@NotNull Pair<PyCallExpression, PyCallableType> callAndCallee, @NotNull ParameterInfoUIContext context) {
        int currentParamOffset;
        ParameterHints parameterHints;
        if (callAndCallee == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if ((parameterHints = PyParameterInfoUtils.buildParameterHints(callAndCallee, currentParamOffset = context.getCurrentParameterIndex())) == null) {
            return;
        }
        String[] hints = ArrayUtilRt.toStringArray(parameterHints.getHints());
        String[] annotations = ArrayUtilRt.toStringArray(parameterHints.getAnnotations());
        if (context instanceof ParameterInfoUIContextEx) {
            EnumSet[] flags = new EnumSet[parameterHints.getFlags().size()];
            for (int i = 0; i < flags.length; ++i) {
                String annotation;
                EnumSet<ParameterFlag> curFlags = parameterHints.getFlags().get(i);
                if (!curFlags.contains(ParameterFlag.HIGHLIGHT) && i < hints.length && hints[i].length() > 50 && i < annotations.length && !(annotation = annotations[i]).isEmpty() && annotation.length() < hints[i].length()) {
                    hints[i] = annotation;
                }
                flags[i] = (EnumSet)StreamEx.of((Collection)parameterHints.getFlags().get(i)).map(PARAM_FLAG_TO_UI_FLAG::get).collect(MoreCollectors.toEnumSet(ParameterInfoUIContextEx.Flag.class));
            }
            if (hints.length == 0) {
                hints = new String[]{PyParameterInfoHandler.getNoParamsMsg()};
                flags = new EnumSet[]{EnumSet.of(ParameterInfoUIContextEx.Flag.DISABLE)};
            }
            ((ParameterInfoUIContextEx)context).setupUIComponentPresentation(hints, flags, context.getDefaultParameterColor());
        } else {
            StringBuilder signatureBuilder = new StringBuilder();
            if (hints.length == 0) {
                signatureBuilder.append(PyParameterInfoHandler.getNoParamsMsg());
            } else {
                for (String s : hints) {
                    signatureBuilder.append(s);
                }
            }
            context.setupUIComponentPresentation(signatureBuilder.toString(), -1, 0, false, false, false, context.getDefaultParameterColor());
        }
    }

    private static String getNoParamsMsg() {
        return CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callAndCallee";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/PyParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

