/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingLexer;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;

public class PyTokenSeparatorGenerator
implements TokenSeparatorGenerator {
    public ASTNode generateWhitespaceBetweenTokens(ASTNode left, ASTNode right) {
        PsiManager manager = right.getTreeParent().getPsi().getManager();
        if (left.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT) {
            return PyTokenSeparatorGenerator.createLineBreak(manager);
        }
        if (left.getPsi().isValid() && right.getPsi().isValid()) {
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)left.getPsi(), (PsiElement)right.getPsi());
            if (commonParent == null) {
                return null;
            }
            PsiElement leftPrevAncestor = PsiTreeUtil.findPrevParent((PsiElement)commonParent, (PsiElement)left.getPsi());
            PsiElement rightPrevAncestor = PsiTreeUtil.findPrevParent((PsiElement)commonParent, (PsiElement)right.getPsi());
            if (PyTokenSeparatorGenerator.isStatementOrFunction(leftPrevAncestor) && PyTokenSeparatorGenerator.isStatementOrFunction(rightPrevAncestor)) {
                int leftIndent = PyPsiUtils.getElementIndentation(leftPrevAncestor);
                int rightIndent = PyPsiUtils.getElementIndentation(rightPrevAncestor);
                int maxIndent = Math.max(leftIndent, rightIndent);
                return PyTokenSeparatorGenerator.createWhitespace(manager, "\n" + StringUtil.repeatSymbol((char)' ', (int)maxIndent));
            }
        }
        if (right.getElementType() == PyTokenTypes.DEF_KEYWORD || right.getElementType() == PyTokenTypes.CLASS_KEYWORD) {
            return PyTokenSeparatorGenerator.createLineBreak(manager);
        }
        if (left.getElementType() == TokenType.WHITE_SPACE || right.getElementType() == TokenType.WHITE_SPACE) {
            return null;
        }
        PyStatement leftStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)left.getPsi(), PyStatement.class);
        if (leftStatement != null && !PsiTreeUtil.isAncestor((PsiElement)leftStatement, (PsiElement)right.getPsi(), (boolean)false)) {
            return PyTokenSeparatorGenerator.createLineBreak(manager);
        }
        PythonIndentingLexer lexer = new PythonIndentingLexer();
        if (LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer) == ParserDefinition.SpaceRequirements.MUST) {
            return PyTokenSeparatorGenerator.createSpace(manager);
        }
        return null;
    }

    private static boolean isStatementOrFunction(PsiElement element) {
        return element instanceof PyStatement;
    }

    private static ASTNode createSpace(PsiManager manager) {
        return PyTokenSeparatorGenerator.createWhitespace(manager, " ");
    }

    private static ASTNode createLineBreak(PsiManager manager) {
        return PyTokenSeparatorGenerator.createWhitespace(manager, "\n");
    }

    private static ASTNode createWhitespace(PsiManager manager, String text) {
        return Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)text, (int)0, (int)text.length(), null, (PsiManager)manager);
    }
}

