/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.console.PyConsoleOptions;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PydevConsoleRunnerUtil;
import com.jetbrains.python.console.PydevDocumentationProvider;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.completion.PydevConsoleReference;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.documentation.PyRuntimeDocstringFormatter;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonRuntimeServiceImpl
extends PythonRuntimeService {
    @Override
    public boolean isInPydevConsole(@NotNull PsiElement file) {
        if (file == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(0);
        }
        return PydevConsoleRunnerUtil.isInPydevConsole(file);
    }

    @Override
    public boolean isInScratchFile(@NotNull PsiElement element) {
        if (element == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(1);
        }
        return ScratchUtil.isScratch((VirtualFile)PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    @Override
    @Nullable
    public Sdk getConsoleSdk(@NotNull PsiElement foothold) {
        if (foothold == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(2);
        }
        return PydevConsoleRunnerUtil.getConsoleSdk(foothold);
    }

    @Override
    public String createPydevDoc(PsiElement element, PsiElement originalElement) {
        return PydevDocumentationProvider.createDoc(element, originalElement);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk2) {
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk2);
        if (languageLevel == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(3);
        }
        return languageLevel;
    }

    @Override
    public PsiPolyVariantReference getPydevConsoleReference(@NotNull PyReferenceExpression element, @NotNull PyResolveContext context) {
        PsiFile file;
        if (element == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(5);
        }
        if ((file = element.getContainingFile()) != null) {
            ConsoleCommunication communication = (ConsoleCommunication)file.getCopyableUserData(PydevConsoleRunner.CONSOLE_COMMUNICATION_KEY);
            if (communication != null && PyConsoleOptions.getInstance(element.getProject()).isAutoCompletionEnabled()) {
                PyExpression qualifier = element.getQualifier();
                String prefix = qualifier == null ? "" : qualifier.getText() + ".";
                return new PydevConsoleReference(element, communication, prefix, context.allowRemote());
            }
            if (communication instanceof PythonDebugConsoleCommunication) {
                PythonDebugConsoleCommunication comm = (PythonDebugConsoleCommunication)communication;
                comm.setContext();
            }
        }
        return null;
    }

    @Override
    public PythonConsoleData getPythonConsoleData(@Nullable ASTNode node) {
        return PydevConsoleRunnerUtil.getPythonConsoleData(node);
    }

    @Override
    public String formatDocstring(@NotNull Module module, @NotNull DocStringFormat format, @NotNull String input, @NotNull List<String> formatterFlags) {
        if (module == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(6);
        }
        if (format == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(7);
        }
        if (input == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(8);
        }
        if (formatterFlags == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(9);
        }
        return PyRuntimeDocstringFormatter.runExternalTool(module, format, input, formatterFlags);
    }

    @Override
    public String mapToRemote(@NotNull String localRoot, @NotNull Sdk sdk2) {
        RemoteSdkAdditionalData remoteSdkData;
        if (localRoot == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(10);
        }
        if (sdk2 == null) {
            PythonRuntimeServiceImpl.$$$reportNull$$$0(11);
        }
        if ((remoteSdkData = PyUtil.as(sdk2.getSdkAdditionalData(), RemoteSdkAdditionalData.class)) != null) {
            return remoteSdkData.getPathMappings().convertToRemote(localRoot);
        }
        return localRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foothold";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/PythonRuntimeServiceImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterFlags";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRoot";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/PythonRuntimeServiceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInPydevConsole";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInScratchFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleSdk";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPydevConsoleReference";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatDocstring";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mapToRemote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

