/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console.transport;

import com.jetbrains.python.console.transport.DirectedMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/console/transport/DirectedMessageHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lcom/jetbrains/python/console/transport/DirectedMessage;", "responseStream", "Ljava/io/OutputStream;", "requestStream", "(Ljava/io/OutputStream;Ljava/io/OutputStream;)V", "channel", "Lio/netty/channel/Channel;", "assureChannelPresent", "channelRead0", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "channelRegistered", "sendRequest", "byteBuf", "Lio/netty/buffer/ByteBuf;", "intellij.python.community.impl"})
public final class DirectedMessageHandler
extends SimpleChannelInboundHandler<DirectedMessage> {
    @NotNull
    private final OutputStream responseStream;
    @NotNull
    private final OutputStream requestStream;
    @Nullable
    private Channel channel;

    public DirectedMessageHandler(@NotNull OutputStream responseStream, @NotNull OutputStream requestStream) {
        Intrinsics.checkNotNullParameter((Object)responseStream, (String)"responseStream");
        Intrinsics.checkNotNullParameter((Object)requestStream, (String)"requestStream");
        this.responseStream = responseStream;
        this.requestStream = requestStream;
    }

    private final Channel assureChannelPresent() {
        Channel channel = this.channel;
        if (channel == null) {
            throw new IllegalStateException("`channel` must not be `null`");
        }
        return channel;
    }

    public final void sendRequest(@NotNull ByteBuf byteBuf) {
        Intrinsics.checkNotNullParameter((Object)byteBuf, (String)"byteBuf");
        Channel channel = this.assureChannelPresent();
        byte[] content2 = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(content2);
        channel.writeAndFlush((Object)new DirectedMessage(DirectedMessage.MessageDirection.REQUEST, content2));
    }

    public void channelRegistered(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.channel = ctx.channel();
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull DirectedMessage msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        OutputStream it = switch (WhenMappings.$EnumSwitchMapping$0[msg.getDirection().ordinal()]) {
            case 1 -> this.responseStream;
            case 2 -> this.requestStream;
            default -> throw new NoWhenBranchMatchedException();
        };
        boolean bl = false;
        it.write(msg.getContent());
        it.flush();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DirectedMessage.MessageDirection.values().length];
            try {
                nArray[DirectedMessage.MessageDirection.RESPONSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DirectedMessage.MessageDirection.REQUEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

