/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.impl.PyExpressionCodeFragmentImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    @NotNull
    public FileType getFileType() {
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        if (pythonFileType == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(0);
        }
        return pythonFileType;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(1);
        }
        if (text == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(3);
        }
        text = text.trim();
        PyExpressionCodeFragmentImpl fragment2 = new PyExpressionCodeFragmentImpl(project, "fragment.py", text, true);
        PsiElement element = PyDebuggerEditorsProvider.getContextElement(project, sourcePosition);
        fragment2.setContext(element);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment2);
        if (document == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(4);
        }
        return document;
    }

    @VisibleForTesting
    @Nullable
    public static PsiElement getContextElement(Project project, XSourcePosition sourcePosition) {
        if (sourcePosition != null) {
            int offset;
            Document document = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
            if (document == null) {
                return null;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null && (offset = sourcePosition.getOffset()) >= 0 && offset < document.getTextLength()) {
                PsiElement element;
                int lineEndOffset = document.getLineEndOffset(document.getLineNumber(offset));
                do {
                    if ((element = psiFile.findElementAt(offset)) != null && !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                        return PyPsiUtils.getStatement(element);
                    }
                    if (element != null) continue;
                    return null;
                } while ((offset = element.getTextRange().getEndOffset()) < lineEndOffset);
            }
        }
        return null;
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        PyInlineDebuggerHelper pyInlineDebuggerHelper = PyInlineDebuggerHelper.INSTANCE;
        if (pyInlineDebuggerHelper == null) {
            PyDebuggerEditorsProvider.$$$reportNull$$$0(5);
        }
        return pyInlineDebuggerHelper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyDebuggerEditorsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyDebuggerEditorsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineDebuggerHelper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class PyInlineDebuggerHelper
    extends InlineDebuggerHelper {
        private static final PyInlineDebuggerHelper INSTANCE = new PyInlineDebuggerHelper();

        private PyInlineDebuggerHelper() {
        }

        public boolean shouldEvaluateChildrenByDefault(XNamedTreeNode node) {
            return false;
        }
    }
}

