/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.xdebugger.frame.XExecutionStack;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PyThreadInfo;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecutionStack
extends XExecutionStack {
    private final PyDebugProcess myDebugProcess;
    private final PyThreadInfo myThreadInfo;
    private PyStackFrame myTopFrame;

    public PyExecutionStack(@NotNull PyDebugProcess debugProcess, @NotNull PyThreadInfo threadInfo) {
        if (debugProcess == null) {
            PyExecutionStack.$$$reportNull$$$0(0);
        }
        if (threadInfo == null) {
            PyExecutionStack.$$$reportNull$$$0(1);
        }
        super(threadInfo.getName());
        this.myDebugProcess = debugProcess;
        this.myThreadInfo = threadInfo;
    }

    public PyExecutionStack(@NotNull PyDebugProcess debugProcess, @NotNull PyThreadInfo threadInfo, @Nullable Icon icon) {
        if (debugProcess == null) {
            PyExecutionStack.$$$reportNull$$$0(2);
        }
        if (threadInfo == null) {
            PyExecutionStack.$$$reportNull$$$0(3);
        }
        super(threadInfo.getName(), icon);
        this.myDebugProcess = debugProcess;
        this.myThreadInfo = threadInfo;
    }

    public PyStackFrame getTopFrame() {
        List<PyStackFrameInfo> frames;
        if (this.myTopFrame == null && (frames = this.myThreadInfo.getFrames()) != null) {
            this.myTopFrame = PyExecutionStack.convert(this.myDebugProcess, frames.get(0));
        }
        return this.myTopFrame;
    }

    public void computeStackFrames(int firstFrameIndex, XExecutionStack.XStackFrameContainer container) {
        if (this.myThreadInfo.getState() != PyThreadInfo.State.SUSPENDED) {
            container.errorOccurred(PyBundle.message("debugger.stack.frames.not.available.in.non.suspended.state", new Object[0]));
            return;
        }
        List<PyStackFrameInfo> frames = this.myThreadInfo.getFrames();
        if (frames != null && firstFrameIndex <= frames.size()) {
            LinkedList<PyStackFrame> xFrames = new LinkedList<PyStackFrame>();
            for (int i = firstFrameIndex; i < frames.size(); ++i) {
                xFrames.add(PyExecutionStack.convert(this.myDebugProcess, frames.get(i)));
            }
            container.addStackFrames(xFrames, true);
        } else {
            container.addStackFrames(Collections.emptyList(), true);
        }
    }

    @NotNull
    PyThreadInfo getThreadInfo() {
        PyThreadInfo pyThreadInfo = this.myThreadInfo;
        if (pyThreadInfo == null) {
            PyExecutionStack.$$$reportNull$$$0(4);
        }
        return pyThreadInfo;
    }

    private static PyStackFrame convert(PyDebugProcess debugProcess, PyStackFrameInfo frameInfo) {
        return debugProcess.createStackFrame(frameInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PyExecutionStack that = (PyExecutionStack)((Object)o);
        return !(this.myThreadInfo != null ? !this.myThreadInfo.equals(that.myThreadInfo) : that.myThreadInfo != null);
    }

    public int hashCode() {
        return this.myThreadInfo != null ? this.myThreadInfo.hashCode() : 0;
    }

    public String getThreadId() {
        return this.myThreadInfo.getId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PyExecutionStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PyExecutionStack";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

