/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.StaticSymbolWhiteSpaceDefinitionStrategy;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.editor.PyEditorHandlerConfig;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementPart;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyWhiteSpaceFormattingStrategy
extends StaticSymbolWhiteSpaceDefinitionStrategy {
    public PyWhiteSpaceFormattingStrategy() {
        super(new char[]{'\\'});
    }

    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        CharSequence whiteSpace;
        if (whiteSpaceText == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(0);
        }
        if (startElement == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(1);
        }
        if ((whiteSpace = super.adjustWhiteSpaceIfNecessary(whiteSpaceText, startElement, startOffset, endOffset, codeStyleSettings)).length() > 0 && whiteSpace.charAt(0) == '\n' && !Strings.contains((CharSequence)whiteSpace, (int)0, (int)whiteSpace.length(), (char)'\\') && PyWhiteSpaceFormattingStrategy.needInsertBackslash(startElement.getContainingFile(), startOffset, false)) {
            return PyWhiteSpaceFormattingStrategy.addBackslashPrefix(whiteSpace, codeStyleSettings);
        }
        return whiteSpace;
    }

    private static String addBackslashPrefix(CharSequence whiteSpace, CodeStyleSettings settings) {
        PyCodeStyleSettings pySettings = (PyCodeStyleSettings)settings.getCustomSettings(PyCodeStyleSettings.class);
        return (pySettings.SPACE_BEFORE_BACKSLASH ? " \\" : "\\") + whiteSpace.toString();
    }

    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        Int2IntMap initialBackSlashes;
        if (whiteSpaceText == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(2);
        }
        if (text == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(3);
        }
        if ((initialBackSlashes = PyWhiteSpaceFormattingStrategy.countBackSlashes(text, startOffset, endOffset)).isEmpty()) {
            if (nodeAfter != null && whiteSpaceText.length() > 0 && whiteSpaceText.charAt(0) == '\n' && PyWhiteSpaceFormattingStrategy.needInsertBackslash(nodeAfter, false)) {
                String string = PyWhiteSpaceFormattingStrategy.addBackslashPrefix(whiteSpaceText, codeStyleSettings);
                if (string == null) {
                    PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(4);
                }
                return string;
            }
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        Int2IntMap newBackSlashes = PyWhiteSpaceFormattingStrategy.countBackSlashes(whiteSpaceText, 0, whiteSpaceText.length());
        boolean continueProcessing = false;
        IntIterator iterator = initialBackSlashes.keySet().iterator();
        while (iterator.hasNext()) {
            if (newBackSlashes.containsKey(iterator.nextInt())) continue;
            continueProcessing = true;
            break;
        }
        if (!continueProcessing) {
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(6);
            }
            return charSequence;
        }
        PyCodeStyleSettings settings = (PyCodeStyleSettings)codeStyleSettings.getCustomSettings(PyCodeStyleSettings.class);
        StringBuilder result2 = new StringBuilder();
        int line2 = 0;
        for (int i = 0; i < whiteSpaceText.length(); ++i) {
            char c = whiteSpaceText.charAt(i);
            if (c != '\n') {
                result2.append(c);
                continue;
            }
            if (!newBackSlashes.containsKey(line2++)) {
                if ((i == 0 || whiteSpaceText.charAt(i - 1) != ' ') && settings.SPACE_BEFORE_BACKSLASH) {
                    result2.append(' ');
                }
                result2.append('\\');
            }
            result2.append(c);
        }
        StringBuilder stringBuilder = result2;
        if (stringBuilder == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(7);
        }
        return stringBuilder;
    }

    @NotNull
    static Int2IntMap countBackSlashes(CharSequence text, int start, int end) {
        Int2IntOpenHashMap result2 = new Int2IntOpenHashMap();
        int line2 = 0;
        if (end > text.length()) {
            end = text.length();
        }
        block4: for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    ++line2;
                    continue block4;
                }
                case '\\': {
                    result2.put(line2, 1);
                }
            }
        }
        Int2IntOpenHashMap int2IntOpenHashMap = result2;
        if (int2IntOpenHashMap == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(8);
        }
        return int2IntOpenHashMap;
    }

    public static boolean needInsertBackslash(PsiFile file, int offset, boolean autoWrapInProgress) {
        PsiElement beforeCaret;
        if (offset > 0 && (beforeCaret = file.findElementAt(offset - 1)) instanceof PsiWhiteSpace && beforeCaret.getText().indexOf(92) >= 0) {
            return false;
        }
        PsiElement atCaret = file.findElementAt(offset);
        if (atCaret == null) {
            return false;
        }
        ASTNode nodeAtCaret = atCaret.getNode();
        return PyWhiteSpaceFormattingStrategy.needInsertBackslash(nodeAtCaret, autoWrapInProgress);
    }

    private static boolean needInsertBackslash(ASTNode nodeAtCaret, boolean autoWrapInProgress) {
        PsiElement next;
        PsiElement statementAfter;
        if (PsiTreeUtil.getParentOfType((PsiElement)nodeAtCaret.getPsi(), PyFStringFragment.class) != null) {
            return false;
        }
        PsiElement statementBefore = PyWhiteSpaceFormattingStrategy.findStatementBeforeCaret(nodeAtCaret);
        if (statementBefore != (statementAfter = PyWhiteSpaceFormattingStrategy.findStatementAfterCaret(nodeAtCaret))) {
            return false;
        }
        if (statementBefore == null) {
            return false;
        }
        if (PsiTreeUtil.hasErrorElements((PsiElement)statementBefore) && !autoWrapInProgress) {
            return false;
        }
        int offset = nodeAtCaret.getTextRange().getStartOffset();
        if (PyWhiteSpaceFormattingStrategy.inFromImportParentheses(statementBefore, offset) || PyWhiteSpaceFormattingStrategy.inWithItemsParentheses(statementBefore, offset) || PyWhiteSpaceFormattingStrategy.inCaseClauseParentheses(statementBefore, offset)) {
            return false;
        }
        PsiElement wrappableBefore = PyWhiteSpaceFormattingStrategy.findWrappable(nodeAtCaret, true);
        PsiElement wrappableAfter = PyWhiteSpaceFormattingStrategy.findWrappable(nodeAtCaret, false);
        if (!(wrappableBefore instanceof PsiComment)) {
            while (wrappableBefore != null && (next = PsiTreeUtil.getParentOfType((PsiElement)wrappableBefore, (Class[])PyEditorHandlerConfig.WRAPPABLE_CLASSES)) != null) {
                wrappableBefore = next;
            }
        }
        if (!(wrappableAfter instanceof PsiComment)) {
            while (wrappableAfter != null && (next = PsiTreeUtil.getParentOfType((PsiElement)wrappableAfter, (Class[])PyEditorHandlerConfig.WRAPPABLE_CLASSES)) != null) {
                wrappableAfter = next;
            }
        }
        if (wrappableBefore instanceof PsiComment || wrappableAfter instanceof PsiComment) {
            return false;
        }
        if (wrappableAfter == null) {
            return !(wrappableBefore instanceof PyDecoratorList);
        }
        return wrappableBefore != wrappableAfter;
    }

    @Nullable
    private static PsiElement findWrappable(ASTNode nodeAtCaret, boolean before) {
        PsiElement wrappable;
        PsiElement psiElement = wrappable = before ? PyWhiteSpaceFormattingStrategy.findBeforeCaret(nodeAtCaret, PyEditorHandlerConfig.WRAPPABLE_CLASSES) : PyWhiteSpaceFormattingStrategy.findAfterCaret(nodeAtCaret, PyEditorHandlerConfig.WRAPPABLE_CLASSES);
        if (wrappable == null) {
            PsiElement emptyTuple;
            PsiElement psiElement2 = emptyTuple = before ? PyWhiteSpaceFormattingStrategy.findBeforeCaret(nodeAtCaret, PyTupleExpression.class) : PyWhiteSpaceFormattingStrategy.findAfterCaret(nodeAtCaret, PyTupleExpression.class);
            if (emptyTuple != null && emptyTuple.getNode().getFirstChildNode().getElementType() == PyTokenTypes.LPAR) {
                wrappable = emptyTuple;
            }
        }
        return wrappable;
    }

    @Nullable
    private static PsiElement findStatementBeforeCaret(ASTNode node) {
        return PyWhiteSpaceFormattingStrategy.findBeforeCaret(node, PyStatement.class, PyStatementPart.class);
    }

    @Nullable
    private static PsiElement findStatementAfterCaret(ASTNode node) {
        return PyWhiteSpaceFormattingStrategy.findAfterCaret(node, PyStatement.class, PyStatementPart.class);
    }

    private static PsiElement findBeforeCaret(ASTNode atCaret, Class<? extends PsiElement> ... classes) {
        while (atCaret != null) {
            if ((atCaret = TreeUtil.prevLeaf((ASTNode)atCaret)) == null || atCaret.getElementType() == TokenType.WHITE_SPACE) continue;
            return PyWhiteSpaceFormattingStrategy.getNonStrictParentOfType(atCaret.getPsi(), classes);
        }
        return null;
    }

    private static PsiElement findAfterCaret(ASTNode atCaret, Class<? extends PsiElement> ... classes) {
        while (atCaret != null) {
            if (atCaret.getElementType() != TokenType.WHITE_SPACE) {
                return PyWhiteSpaceFormattingStrategy.getNonStrictParentOfType(atCaret.getPsi(), classes);
            }
            atCaret = TreeUtil.nextLeaf((ASTNode)atCaret);
        }
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T getNonStrictParentOfType(@NotNull PsiElement element, Class<? extends T> ... classes) {
        if (element == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(9);
        }
        if (classes == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(10);
        }
        for (PsiElement run = element; run != null; run = run.getParent()) {
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(run)) continue;
                return (T)run;
            }
            if (run instanceof PsiFile || run instanceof PyStatementList) break;
        }
        return null;
    }

    private static boolean inFromImportParentheses(PsiElement statement, int offset) {
        if (!(statement instanceof PyFromImportStatement)) {
            return false;
        }
        PyFromImportStatement fromImportStatement = (PyFromImportStatement)statement;
        PsiElement leftParen = fromImportStatement.getLeftParen();
        return leftParen != null && offset >= leftParen.getTextRange().getEndOffset();
    }

    private static boolean inWithItemsParentheses(@NotNull PsiElement statement, int offset) {
        if (statement == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(11);
        }
        if (!(statement instanceof PyWithStatement)) {
            return false;
        }
        PsiElement leftParen = PyPsiUtils.getFirstChildOfType(statement, PyTokenTypes.LPAR);
        return leftParen != null && offset >= leftParen.getTextRange().getEndOffset();
    }

    private static boolean inCaseClauseParentheses(@NotNull PsiElement statement, int offset) {
        if (statement == null) {
            PyWhiteSpaceFormattingStrategy.$$$reportNull$$$0(12);
        }
        if (!(statement instanceof PyCaseClause)) {
            return false;
        }
        PyCaseClause caseClause = (PyCaseClause)statement;
        PyPattern pattern = caseClause.getPattern();
        if (pattern == null) {
            return false;
        }
        PsiElement leftParen = PyPsiUtils.getChildByFilter((PsiElement)pattern, PyTokenTypes.OPEN_BRACES, 0);
        return leftParen != null && offset >= leftParen.getTextRange().getEndOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyWhiteSpaceFormattingStrategy";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "countBackSlashes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParentOfType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inWithItemsParentheses";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inCaseClauseParentheses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

