/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.common.hash.HashFunction;
import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.io.HttpRequests;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.PySdkToInstallCollector;
import com.jetbrains.python.sdk.PySdkToInstallKt;
import com.jetbrains.python.sdk.PySdkToInstallOnWindows;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002/0B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001b0\u001aH\u0002J\u0012\u0010\u001c\u001a\u00020\u00032\b\b\u0001\u0010\u001d\u001a\u00020\u0003H\u0017J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020$H\u0002J(\u0010%\u001a\u0004\u0018\u00010\u00182\b\u0010&\u001a\u0004\u0018\u00010'2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001b0\u001aH\u0016J0\u0010%\u001a\u0004\u0018\u00010\u00182\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u001b0\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0016J\"\u0010+\u001a\u00020,2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010+\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows;", "Lcom/jetbrains/python/sdk/PySdkToInstall;", "name", "", "version", "url", "size", "", "hash", "hashFunction", "Lcom/google/common/hash/HashFunction;", "targetFileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Lcom/google/common/hash/HashFunction;Ljava/lang/String;)V", "checkInstallerConsistency", "", "project", "Lcom/intellij/openapi/project/Project;", "installer", "Ljava/io/File;", "downloadInstaller", "targetFile", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "findInstalledSdk", "Lcom/jetbrains/python/sdk/PyDetectedSdk;", "systemWideSdksDetector", "Lkotlin/Function0;", "", "getInstallationWarning", "defaultButtonName", "handleExecutionException", "e", "Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows$PyInstallationExecutionException;", "handleIOException", "Ljava/io/IOException;", "handleInstallationException", "Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows$PyInstallationException;", "install", "module", "Lcom/intellij/openapi/module/Module;", "renderInList", "renderer", "Lcom/intellij/ui/SimpleColoredComponent;", "runInstaller", "Lcom/intellij/execution/process/ProcessOutput;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "PyInstallationException", "PyInstallationExecutionException", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPySdkToInstall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySdkToInstall.kt\ncom/jetbrains/python/sdk/PySdkToInstallOnWindows\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,449:1\n288#2,2:450\n288#2,2:452\n12#3,5:454\n*S KotlinDebug\n*F\n+ 1 PySdkToInstall.kt\ncom/jetbrains/python/sdk/PySdkToInstallOnWindows\n*L\n282#1:450,2\n294#1:452,2\n333#1:454,5\n*E\n"})
final class PySdkToInstallOnWindows
extends PySdkToInstall {
    @NotNull
    private final String version;
    @NotNull
    private final String url;
    private final long size;
    @NotNull
    private final String hash;
    @NotNull
    private final HashFunction hashFunction;
    @NotNull
    private final String targetFileName;

    public PySdkToInstallOnWindows(@NotNull String name2, @NotNull String version2, @NotNull String url, long size, @NotNull String hash, @NotNull HashFunction hashFunction, @NotNull String targetFileName) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)hashFunction, (String)"hashFunction");
        Intrinsics.checkNotNullParameter((Object)targetFileName, (String)"targetFileName");
        super(name2, version2);
        this.version = version2;
        this.url = url;
        this.size = size;
        this.hash = hash;
        this.hashFunction = hashFunction;
        this.targetFileName = targetFileName;
    }

    @Override
    public void renderInList(@NotNull SimpleColoredComponent renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        renderer.append(this.getName());
        renderer.append(" " + this.url, SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        renderer.setIcon(AllIcons.Actions.Download);
    }

    @Override
    @NlsContexts.DialogMessage
    @NotNull
    public String getInstallationWarning(@NlsContexts.Button @NotNull String defaultButtonName) {
        Intrinsics.checkNotNullParameter((Object)defaultButtonName, (String)"defaultButtonName");
        String string = StringUtil.formatFileSize((long)this.size);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(size)");
        String fileSize = string;
        HtmlChunk[] htmlChunkArray = new HtmlChunk[2];
        HtmlChunk[] htmlChunkArray2 = new HtmlChunk[1];
        Object[] objectArray = new Object[]{HtmlChunk.text((String)"...").bold(), "python.exe"};
        htmlChunkArray2[0] = HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.specify.path", objectArray));
        htmlChunkArray[0] = HtmlChunk.tag((String)"li").children(htmlChunkArray2);
        htmlChunkArray2 = new HtmlChunk[1];
        objectArray = new Object[]{HtmlChunk.text((String)defaultButtonName).bold(), fileSize};
        htmlChunkArray2[0] = HtmlChunk.raw((String)PyBundle.message("python.sdk.executable.not.found.option.download.and.install", objectArray));
        htmlChunkArray[1] = HtmlChunk.tag((String)"li").children(htmlChunkArray2);
        String string2 = new HtmlBuilder().append(PyBundle.message("python.sdk.executable.not.found.header", new Object[0])).append((HtmlChunk)HtmlChunk.tag((String)"ul").children(htmlChunkArray)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"HtmlBuilder()\n      .app\u2026ze)))\n      )).toString()");
        return string2;
    }

    @Override
    @Nullable
    public PyDetectedSdk install(@Nullable Module module, @NotNull Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        Intrinsics.checkNotNullParameter(systemWideSdksDetector, (String)"systemWideSdksDetector");
        try {
            Module module2 = module;
            Project project = module2 != null ? module2.getProject() : null;
            Object[] objectArray = new Object[]{this.getName()};
            String string = PyBundle.message("python.sdk.installing", objectArray);
            return (PyDetectedSdk)((Object)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<PyDetectedSdk, Exception>(project, this, systemWideSdksDetector, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ PySdkToInstallOnWindows this$0;
                final /* synthetic */ Function0<List<PyDetectedSdk>> $systemWideSdksDetector;
                {
                    this.$project = $project;
                    this.this$0 = $receiver;
                    this.$systemWideSdksDetector = $systemWideSdksDetector;
                    super($project, $super_call_param$1, true);
                }

                @Nullable
                protected PyDetectedSdk compute(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    return PySdkToInstallOnWindows.access$install(this.this$0, this.$project, this.$systemWideSdksDetector, indicator);
                }
            }));
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        catch (PyInstallationExecutionException e) {
            this.handleExecutionException(e);
        }
        catch (PyInstallationException e) {
            this.handleInstallationException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PyDetectedSdk install(Project project, Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector, ProgressIndicator indicator) {
        File targetFile = new File(PathManager.getTempPath(), this.targetFileName);
        try {
            Object object = new Object[]{this.targetFileName};
            indicator.setText(PyBundle.message("python.sdk.downloading", object));
            if (indicator.isCanceled()) {
                PySdkToInstallCollector.Companion.logSdkDownloadOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.CANCELLED);
                object = null;
                return object;
            }
            this.downloadInstaller(project, targetFile, indicator);
            if (indicator.isCanceled()) {
                PySdkToInstallCollector.Companion.logSdkDownloadOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.CANCELLED);
                object = null;
                return object;
            }
            this.checkInstallerConsistency(project, targetFile);
            PySdkToInstallCollector.Companion.logSdkDownloadOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.OK);
            object = new Object[]{this.targetFileName};
            indicator.setText(PyBundle.message("python.sdk.running", object));
            indicator.setText2(PyBundle.message("python.sdk.installing.windows.warning", new Object[0]));
            indicator.setIndeterminate(true);
            if (indicator.isCanceled()) {
                PySdkToInstallCollector.Companion.logSdkInstallationOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.CANCELLED);
                object = null;
                return object;
            }
            this.runInstaller(project, targetFile, indicator);
            PySdkToInstallCollector.Companion.logSdkInstallationOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.OK);
            object = this.findInstalledSdk(project, systemWideSdksDetector);
            return object;
        }
        finally {
            FileUtil.delete((File)targetFile);
        }
    }

    private final void downloadInstaller(Project project, File targetFile, ProgressIndicator indicator) {
        PySdkToInstallKt.access$getLOGGER$p().info("Downloading " + this.url + " to " + targetFile);
        try {
            HttpRequests.request((String)this.url).saveToFile(targetFile, indicator);
        }
        catch (IOException e) {
            PySdkToInstallCollector.Companion.logSdkDownloadOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.EXCEPTION);
            throw new IOException("Failed to download " + this.url + " to " + targetFile + ".", e);
        }
        catch (ProcessCanceledException e) {
            PySdkToInstallCollector.Companion.logSdkDownloadOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.CANCELLED);
            throw e;
        }
    }

    private final void checkInstallerConsistency(Project project, File installer) {
        PySdkToInstallKt.access$getLOGGER$p().debug("Checking installer size");
        long sizeDiff = installer.length() - this.size;
        if (sizeDiff != 0L) {
            PySdkToInstallCollector.Companion.logSdkDownloadOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.SIZE);
            throw new IOException("Downloaded " + installer + " has incorrect size, difference is " + Math.abs(sizeDiff) + " bytes.");
        }
        PySdkToInstallKt.access$getLOGGER$p().debug("Checking installer checksum");
        String string = Files.asByteSource((File)installer).hash(this.hashFunction).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asByteSource(installer).\u2026(hashFunction).toString()");
        String actualHashCode = string;
        if (!StringsKt.equals((String)actualHashCode, (String)this.hash, (boolean)true)) {
            PySdkToInstallCollector.Companion.logSdkDownloadOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.DownloadResult.CHECKSUM);
            throw new IOException("Checksums for " + installer + " does not match. Actual value is " + actualHashCode + ", expected " + this.hash + ".");
        }
    }

    private final void handleIOException(IOException e) {
        block0: {
            PySdkToInstallKt.access$getLOGGER$p().info((Throwable)e);
            String string = e.getMessage();
            if (string == null) break block0;
            String message = string;
            boolean bl = false;
            Object[] objectArray = new Object[]{this.getName()};
            Throwable throwable = e.getCause();
            PackagesNotificationPanel.showError((String)PyBundle.message("python.sdk.failed.to.install.title", objectArray), (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(message, null, throwable != null ? throwable.getMessage() : null, PyBundle.message("python.sdk.try.to.install.python.manually", new Object[0])));
        }
    }

    private final void runInstaller(Project project, File installer, ProgressIndicator indicator) {
        String[] stringArray = new String[]{installer.getAbsolutePath(), "/quiet"};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        PySdkToInstallKt.access$getLOGGER$p().info("Running " + commandLine.getCommandLineString());
        ProcessOutput output2 = this.runInstaller(project, commandLine, indicator);
        if (output2.isCancelled()) {
            PySdkToInstallCollector.Companion.logSdkInstallationOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.CANCELLED);
        }
        if (output2.getExitCode() != 0) {
            PySdkToInstallCollector.Companion.logSdkInstallationOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.EXIT_CODE);
        }
        if (output2.isTimeout()) {
            PySdkToInstallCollector.Companion.logSdkInstallationOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.TIMEOUT);
        }
        if (output2.getExitCode() != 0 || output2.isTimeout()) {
            throw new PyInstallationException(commandLine, output2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInstallationException(PyInstallationException e) {
        ProcessOutput processOutput = e.getOutput();
        processOutput.checkSuccess(PySdkToInstallKt.access$getLOGGER$p());
        if (processOutput.isCancelled()) {
            Object v2;
            String string;
            String string2;
            String string3;
            block6: {
                void $this$firstOrNull$iv;
                Object object = new Object[]{this.getName()};
                String string4 = PyBundle.message("python.sdk.installation.has.been.cancelled.title", object);
                object = new String[]{processOutput.getStderr(), processOutput.getStdout()};
                object = CollectionsKt.listOf((Object[])object);
                string3 = e.getCommandLine().getCommandLineString();
                string2 = PyBundle.message("python.sdk.some.installed.python.components.might.get.inconsistent.after.cancellation", new Object[0]);
                string = string4;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            Object var12_21 = v2;
            String string5 = PyBundle.message("python.sdk.consider.installing.python.manually", new Object[0]);
            String string6 = var12_21;
            String string7 = string3;
            String string8 = string2;
            PackagesNotificationPanel.showError((String)string, (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(string8, string7, string6, string5));
        } else {
            Object v6;
            String string;
            String string9;
            String string10;
            block7: {
                String string11;
                Object $this$firstOrNull$iv = new Object[]{this.getName()};
                String string12 = PyBundle.message("python.sdk.failed.to.install.title", (Object[])$this$firstOrNull$iv);
                if (processOutput.isTimeout()) {
                    string11 = PyBundle.message("python.sdk.failed.to.install.timed.out", new Object[0]);
                } else {
                    $this$firstOrNull$iv = new Object[]{processOutput.getExitCode()};
                    string11 = PyBundle.message("python.sdk.failed.to.install.exit.code", (Object[])$this$firstOrNull$iv);
                }
                $this$firstOrNull$iv = new String[]{processOutput.getStderr(), processOutput.getStdout()};
                $this$firstOrNull$iv = CollectionsKt.listOf((Object[])$this$firstOrNull$iv);
                string10 = e.getCommandLine().getCommandLineString();
                string9 = string11;
                string = string12;
                boolean $i$f$firstOrNull = false;
                Iterator iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    String it = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    boolean bl3 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl3) continue;
                    v6 = element$iv;
                    break block7;
                }
                v6 = null;
            }
            Object var12_22 = v6;
            String string13 = PyBundle.message("python.sdk.try.to.install.python.manually", new Object[0]);
            String string14 = var12_22;
            String string15 = string10;
            String string16 = string9;
            PackagesNotificationPanel.showError((String)string, (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(string16, string15, string14, string13));
        }
    }

    private final ProcessOutput runInstaller(Project project, GeneralCommandLine commandLine, ProgressIndicator indicator) {
        try {
            ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcessWithProgressIndicator(indicator);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"CapturingProcessHandler(\u2026gressIndicator(indicator)");
            return processOutput;
        }
        catch (ExecutionException e) {
            PySdkToInstallCollector.Companion.logSdkInstallationOnWindows$intellij_python_community_impl(project, this.version, PySdkToInstallCollector.Companion.InstallationResult.EXCEPTION);
            throw new PyInstallationExecutionException(commandLine, e);
        }
    }

    private final void handleExecutionException(PyInstallationExecutionException e) {
        block0: {
            PySdkToInstallKt.access$getLOGGER$p().info((Throwable)e);
            String string = e.getCause().getMessage();
            if (string == null) break block0;
            String message = string;
            boolean bl = false;
            Object[] objectArray = new Object[]{this.getName()};
            PackagesNotificationPanel.showError((String)PyBundle.message("python.sdk.failed.to.install.title", objectArray), (PackageManagementService.ErrorDescription)new PackageManagementService.ErrorDescription(message, e.getCommandLine().getCommandLineString(), null, PyBundle.message("python.sdk.try.to.install.python.manually", new Object[0])));
        }
    }

    private final PyDetectedSdk findInstalledSdk(Project project, Function0<? extends List<? extends PyDetectedSdk>> systemWideSdksDetector) {
        PySdkToInstallKt.access$getLOGGER$p().debug("Resetting system-wide sdks detectors");
        PySdkExtKt.resetSystemWideSdksDetectors();
        Object object = systemWideSdksDetector.invoke();
        List sdks = (List)object;
        boolean bl = false;
        Logger $this$debug_u24default$iv = PySdkToInstallKt.access$getLOGGER$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug(CollectionsKt.joinToString$default((Iterable)sdks, null, (CharSequence)"Detected system-wide sdks: ", null, (int)0, null, (Function1)findInstalledSdk.1.1.1.INSTANCE, (int)29, null), e$iv);
        }
        List it = (List)object;
        boolean bl3 = false;
        PySdkToInstallCollector.Companion.logSdkLookupOnWindows$intellij_python_community_impl(project, this.version, it.isEmpty() ? PySdkToInstallCollector.Companion.LookupResult.NOT_FOUND : PySdkToInstallCollector.Companion.LookupResult.FOUND);
        return (PyDetectedSdk)((Object)CollectionsKt.singleOrNull((List)((List)object)));
    }

    public static final /* synthetic */ PyDetectedSdk access$install(PySdkToInstallOnWindows $this, Project project, Function0 systemWideSdksDetector, ProgressIndicator indicator) {
        return $this.install(project, (Function0<? extends List<? extends PyDetectedSdk>>)systemWideSdksDetector, indicator);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows$PyInstallationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "output", "Lcom/intellij/execution/process/ProcessOutput;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/execution/process/ProcessOutput;)V", "getCommandLine", "()Lcom/intellij/execution/configurations/GeneralCommandLine;", "getOutput", "()Lcom/intellij/execution/process/ProcessOutput;", "intellij.python.community.impl"})
    private static final class PyInstallationException
    extends Exception {
        @NotNull
        private final GeneralCommandLine commandLine;
        @NotNull
        private final ProcessOutput output;

        public PyInstallationException(@NotNull GeneralCommandLine commandLine, @NotNull ProcessOutput output2) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            this.commandLine = commandLine;
            this.output = output2;
        }

        @NotNull
        public final GeneralCommandLine getCommandLine() {
            return this.commandLine;
        }

        @NotNull
        public final ProcessOutput getOutput() {
            return this.output;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/sdk/PySdkToInstallOnWindows$PyInstallationExecutionException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "cause", "Lcom/intellij/execution/ExecutionException;", "(Lcom/intellij/execution/configurations/GeneralCommandLine;Lcom/intellij/execution/ExecutionException;)V", "getCause", "()Lcom/intellij/execution/ExecutionException;", "getCommandLine", "()Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.python.community.impl"})
    private static final class PyInstallationExecutionException
    extends Exception {
        @NotNull
        private final GeneralCommandLine commandLine;
        @NotNull
        private final ExecutionException cause;

        public PyInstallationExecutionException(@NotNull GeneralCommandLine commandLine, @NotNull ExecutionException cause) {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
            this.commandLine = commandLine;
            this.cause = cause;
        }

        @NotNull
        public final GeneralCommandLine getCommandLine() {
            return this.commandLine;
        }

        @Override
        @NotNull
        public ExecutionException getCause() {
            return this.cause;
        }
    }
}

